/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealIndexRowToBaseRowStatistics
extends RealNoPutResultSetStatistics {
    public String tableName;
    public ResultSetStatistics childResultSetStatistics;
    public String colsAccessedFromHeap;

    public RealIndexRowToBaseRowStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, String string2, FormatableBitSet formatableBitSet, double d, double d2, ResultSetStatistics resultSetStatistics) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.tableName = string2;
        this.colsAccessedFromHeap = formatableBitSet == null ? "{" + MessageService.getTextMessage("43X59.U") + "}" : formatableBitSet.toString();
        this.childResultSetStatistics = resultSetStatistics;
    }

    public String getStatementExecutionPlanText(int n) {
        this.initFormatInfo(n);
        return this.indent + MessageService.getTextMessage("43X60.U", this.tableName) + ":" + "\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X61.U") + " = " + this.colsAccessedFromHeap + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    public String getScanStatisticsText(String string2, int n) {
        if (string2 == null || string2.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.childResultSetStatistics);
        return vector;
    }

    public String getNodeOn() {
        return MessageService.getTextMessage("43X62.U", this.tableName);
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43X63.U");
    }

    ResultSetStatistics getChildResultSetStatistics() {
        return this.childResultSetStatistics;
    }

    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.childResultSetStatistics != null) {
            ++n;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    public String getRSXplainType() {
        return "ROWIDSCAN";
    }

    public String getRSXplainDetails() {
        return "(" + this.resultSetNumber + ")," + this.tableName;
    }
}

