/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.security;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.derby.iapi.util.StringUtil;

public final class DatabasePermission
extends Permission {
    public static final String URL_PROTOCOL_DIRECTORY = "directory:";
    public static final String URL_PATH_INCLUSIVE_STRING = "<<ALL FILES>>";
    public static final char URL_PATH_INCLUSIVE_CHAR = 'I';
    public static final char URL_PATH_SEPARATOR_CHAR = '/';
    public static final char URL_PATH_RELATIVE_CHAR = '.';
    public static final char URL_PATH_WILDCARD_CHAR = '*';
    public static final char URL_PATH_RECURSIVE_CHAR = '-';
    public static final String URL_PATH_SEPARATOR_STRING = String.valueOf('/');
    public static final String URL_PATH_RELATIVE_STRING = String.valueOf('.');
    public static final String URL_PATH_RELATIVE_PREFIX = URL_PATH_RELATIVE_STRING + '/';
    public static final String URL_PATH_WILDCARD_STRING = String.valueOf('*');
    public static final String URL_PATH_WILDCARD_SUFFIX = URL_PATH_SEPARATOR_STRING + '*';
    public static final String URL_PATH_RECURSIVE_STRING = String.valueOf('-');
    public static final String URL_PATH_RECURSIVE_SUFFIX = URL_PATH_SEPARATOR_STRING + '-';
    public static final String CREATE = "create";
    protected static final Set LEGAL_ACTIONS = new HashSet();
    private final String url;
    private transient String path;
    private transient String parentPath;
    private char pathType;

    public DatabasePermission(String string2, String string3) throws IOException {
        super(string2);
        this.initActions(string3);
        this.initLocation(string2);
        this.url = string2;
    }

    protected void initActions(String string2) {
        if (string2 == null) {
            throw new NullPointerException("actions can't be null");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("actions can't be empty");
        }
        string2 = string2.toLowerCase(Locale.ENGLISH);
        String[] stringArray = StringUtil.split(string2, ',');
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (LEGAL_ACTIONS.contains(string3)) continue;
            String string4 = "Illegal action '" + string3 + "'";
            throw new IllegalArgumentException(string4);
        }
    }

    protected void initLocation(String string2) throws IOException {
        if (string2 == null) {
            throw new NullPointerException("URL can't be null");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("URL can't be empty");
        }
        if (!string2.startsWith(URL_PROTOCOL_DIRECTORY)) {
            String string3 = "Unsupported protocol in URL '" + string2 + "'";
            throw new IllegalArgumentException(string3);
        }
        String string4 = string2.substring(URL_PROTOCOL_DIRECTORY.length());
        if (string4.equals(URL_PATH_INCLUSIVE_STRING)) {
            this.pathType = (char)73;
        } else if (string4.equals(URL_PATH_RECURSIVE_STRING)) {
            this.pathType = (char)45;
            string4 = URL_PATH_RELATIVE_PREFIX;
        } else if (string4.equals(URL_PATH_WILDCARD_STRING)) {
            this.pathType = (char)42;
            string4 = URL_PATH_RELATIVE_PREFIX;
        } else if (string4.endsWith(URL_PATH_RECURSIVE_SUFFIX)) {
            this.pathType = (char)45;
            string4 = string4.substring(0, string4.length() - 1);
        } else if (string4.endsWith(URL_PATH_WILDCARD_SUFFIX)) {
            this.pathType = (char)42;
            string4 = string4.substring(0, string4.length() - 1);
        } else {
            this.pathType = (char)47;
        }
        if (this.pathType == 'I') {
            this.path = URL_PATH_INCLUSIVE_STRING;
        } else {
            File file;
            String string5;
            if (string4.startsWith(URL_PATH_RELATIVE_PREFIX)) {
                string5 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
                string4 = string5 + URL_PATH_SEPARATOR_STRING + string4;
            }
            string5 = string4;
            try {
                file = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new File(string5).getCanonicalFile();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getCause();
            }
            this.path = file.getPath();
            this.parentPath = this.pathType != '/' ? this.path : file.getParent();
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof DatabasePermission)) {
            return false;
        }
        DatabasePermission databasePermission = (DatabasePermission)permission;
        if (this.pathType == 'I') {
            return true;
        }
        if (databasePermission.pathType == 'I') {
            return false;
        }
        if (this.pathType == '-') {
            return databasePermission.parentPath != null && databasePermission.parentPath.startsWith(this.path);
        }
        if (databasePermission.pathType == '-') {
            return false;
        }
        if (this.pathType == '*') {
            return this.path.equals(databasePermission.parentPath);
        }
        if (databasePermission.pathType == '*') {
            return false;
        }
        return this.path.equals(databasePermission.path);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DatabasePermission)) {
            return false;
        }
        DatabasePermission databasePermission = (DatabasePermission)object;
        return this.pathType == databasePermission.pathType && this.path.equals(databasePermission.path);
    }

    public int hashCode() {
        return this.path.hashCode() ^ this.pathType;
    }

    public String getActions() {
        return CREATE;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initLocation(this.url);
    }

    static {
        LEGAL_ACTIONS.add(CREATE);
    }
}

