/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.swecommon20.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.jersey.client.ClientResponse;
import org.opengis.cite.swecommon20.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class URIUtils {
    private static final String FIXUP_BASE_URI = "http://apache.org/xml/features/xinclude/fixup-base-uris";

    public static Document parseURI(URI uriRef) throws SAXException, IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setExpandEntityReferences(false);
        docFactory.setXIncludeAware(true);
        Document doc = null;
        try {
            docFactory.setFeature(FIXUP_BASE_URI, false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(uriRef.toString());
        }
        catch (ParserConfigurationException x) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DocumentBuilder." + x);
        }
        if (null != doc) {
            doc.setDocumentURI(uriRef.toString());
        }
        return doc;
    }

    public static File dereferenceURI(URI uriRef) throws IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        if (uriRef.getScheme().equalsIgnoreCase("file")) {
            return new File(uriRef);
        }
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(uriRef);
        ClientResponse rsp = webTarget.request("application/xml").get(ClientResponse.class);
        String suffix = null;
        if (rsp.getHeaders().getFirst("Content-Type").endsWith("xml")) {
            suffix = ".xml";
        }
        File destFile = File.createTempFile("entity-", suffix);
        if (rsp.hasEntity()) {
            int bytesRead;
            InputStream is = rsp.getEntityStream();
            FileOutputStream os = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            is.close();
            os.flush();
            ((OutputStream)os).close();
        }
        TestSuiteLogger.log(Level.FINE, "Wrote " + destFile.length() + " bytes to file at " + destFile.getAbsolutePath());
        return destFile;
    }

    public static URI resolveRelativeURI(String baseURI, String uriRef) {
        URI uri;
        URI uRI = uri = null != baseURI ? URI.create(baseURI) : URI.create("");
        if (null != baseURI && null == uri.getScheme()) {
            throw new IllegalArgumentException("Base URI has no scheme component: " + baseURI);
        }
        return uri.resolve(uriRef);
    }

    public static File resolveURIAsFile(URI uriRef) throws IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        if (uriRef.getScheme().equalsIgnoreCase("file")) {
            return new File(uriRef);
        }
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(uriRef);
        ClientResponse rsp = webTarget.request("application/xml").get(ClientResponse.class);
        File destFile = File.createTempFile("entity-", ".xml");
        if (rsp.hasEntity()) {
            int bytesRead;
            InputStream is = rsp.getEntityStream();
            FileOutputStream os = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            is.close();
            os.flush();
            ((OutputStream)os).close();
        }
        TestSuiteLogger.log(Level.FINE, "Wrote " + destFile.length() + " bytes to file at " + destFile.getAbsolutePath());
        return destFile;
    }
}

