/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.encoding.soap.SOAP12Constants;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class SimpleTypeSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String encoder = null;
    private String serializerMemberName;
    private SOAPType dataType;
    private static Map encoderMap = null;
    private static Set attachmentTypes = null;

    public SimpleTypeSerializerWriter(SOAPType type, Names names) {
        super(type, names);
        this.encoder = SimpleTypeSerializerWriter.getTypeEncoder(type);
        this.dataType = type;
        if (this.encoder == null) {
            throw new GeneratorException("generator.simpleTypeSerializerWriter.no.encoder.for.type", new Object[]{type.getName().toString(), type.getJavaType().getName()});
        }
        String partialSerializerName = this.encoder.substring(0, this.encoder.lastIndexOf("Encoder"));
        if (partialSerializerName.startsWith("XSD")) {
            partialSerializerName = partialSerializerName.substring(3);
        }
        String serializerName = partialSerializerName + "_Serializer";
        this.serializerMemberName = names.getClassMemberName(partialSerializerName, type, "_Serializer");
    }

    private QName getQNameTypeString() {
        if (this.soapVer.equals(SOAPVersion.SOAP_12.toString())) {
            return SOAP12Constants.QNAME_TYPE_STRING;
        }
        return SOAPConstants.QNAME_TYPE_STRING;
    }

    private QName getQNameTypeBase64Binary() {
        if (this.soapVer.equals(SOAPVersion.SOAP_12.toString())) {
            return SOAP12Constants.QNAME_TYPE_BASE64_BINARY;
        }
        return SOAPConstants.QNAME_TYPE_BASE64_BINARY;
    }

    private QName getQNameTypeBase64() {
        if (this.soapVer.equals(SOAPVersion.SOAP_12.toString())) {
            return SOAP12Constants.QNAME_TYPE_BASE64;
        }
        return SOAPConstants.QNAME_TYPE_BASE64;
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        SOAPType type = (SOAPType)this.type;
        String nillable = type.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String referenceable = type.isReferenceable() ? "REFERENCEABLE" : "NOT_REFERENCEABLE";
        String multiRef = multiRefEncoding && type.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String encodeType = encodeTypes ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(p, typeName, type.getName(), false, false);
        QName typeQName = type.getName();
        if (attachmentTypes.contains(typeQName)) {
            boolean serAsAttachment = !typeQName.equals(this.getQNameTypeString()) && !typeQName.equals(BuiltInTypes.STRING);
            p.plnI(this.serializerName() + " " + serName + " = new " + "AttachmentSerializer" + "(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ", " + serAsAttachment + ", " + this.encoder + ".getInstance()," + this.getSOAPVersionString() + ");");
            multiRef = "DONT_SERIALIZE_AS_REF";
        } else if (typeQName.equals(BuiltInTypes.BASE64_BINARY) || typeQName.equals(this.getQNameTypeBase64Binary()) || typeQName.equals(this.getQNameTypeBase64())) {
            p.plnI(this.serializerName() + " " + serName + " = new " + "SimpleMultiTypeSerializer" + "(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ", " + this.encoder + ".getInstance(),");
            p.plnI("new QName[] {");
            GeneratorUtil.writeNewQName(p, BuiltInTypes.BASE64_BINARY);
            p.pln(",");
            GeneratorUtil.writeNewQName(p, this.getQNameTypeBase64Binary());
            p.pln(",");
            GeneratorUtil.writeNewQName(p, this.getQNameTypeBase64());
            p.pOln("});");
        } else {
            p.plnI(this.serializerName() + " " + serName + " = new " + "SimpleTypeSerializer" + "(" + typeName + ",");
            if (type instanceof SOAPListType) {
                p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ", " + this.encoder + ".getInstance(" + this.getItemType() + "));");
            } else {
                p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ", " + this.encoder + ".getInstance());");
            }
        }
        p.pO();
        if (type.isReferenceable()) {
            p.plnI(serName + " = new " + "ReferenceableSerializerImpl" + "(" + multiRef + ", " + serName + ", " + this.getSOAPVersionString() + ");");
            p.pO();
        }
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName() + ";");
    }

    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }

    public static String getTypeEncoder(AbstractType type) {
        QName name = type.getName();
        String encoder = null;
        encoder = type instanceof SOAPListType ? "XSDListTypeEncoder" : (String)encoderMap.get(name);
        if (encoder == null) {
            String javaName = type.getJavaType().getName();
            if (name.equals(BuiltInTypes.DATE_TIME) || name.equals(SOAP12Constants.QNAME_TYPE_DATE_TIME) || name.equals(SOAPConstants.QNAME_TYPE_DATE_TIME)) {
                if (javaName.equals("java.util.Date")) {
                    encoder = "XSDDateTimeDateEncoder";
                } else if (javaName.equals("java.util.Calendar")) {
                    encoder = "XSDDateTimeCalendarEncoder";
                }
            } else if (name.equals(BuiltInTypes.BASE64_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_BASE64_BINARY) || name.equals(SOAP12Constants.QNAME_TYPE_BASE64_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_BASE64) || name.equals(SOAP12Constants.QNAME_TYPE_BASE64)) {
                if (javaName.equals("byte[]")) {
                    encoder = "XSDBase64BinaryEncoder";
                }
            } else if ((name.equals(BuiltInTypes.HEX_BINARY) || name.equals(SOAP12Constants.QNAME_TYPE_HEX_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_HEX_BINARY)) && javaName.equals("byte[]")) {
                encoder = "XSDHexBinaryEncoder";
            }
        }
        return encoder;
    }

    public static String getTypeEncoder(QName typeName) {
        return (String)encoderMap.get(typeName);
    }

    protected String getEncoder() {
        return SimpleTypeSerializerWriter.getTypeEncoder(this.type);
    }

    protected String getItemType() {
        String strType = null;
        SOAPListType lt = (SOAPListType)this.type;
        strType = lt.getItemType() instanceof SOAPEnumerationType ? new String(lt.getItemType().getJavaType().getName() + "_Encoder.getInstance(), " + lt.getItemType().getJavaType().getName() + ".class") : SimpleTypeSerializerWriter.getTypeEncoder(lt.getItemType()) + ".getInstance(), " + lt.getItemType().getJavaType().getName() + ".class";
        if (strType == null) {
            throw new GeneratorException("generator.simpleTypeSerializerWriter.invalidType", new Object[]{lt.getItemType().getName().toString(), lt.getItemType().getJavaType().getName()});
        }
        return strType;
    }

    static {
        attachmentTypes = new HashSet();
        attachmentTypes.add(QNAME_TYPE_IMAGE);
        attachmentTypes.add(QNAME_TYPE_MIME_MULTIPART);
        attachmentTypes.add(QNAME_TYPE_SOURCE);
        attachmentTypes.add(QNAME_TYPE_DATA_HANDLER);
        attachmentTypes.add(BuiltInTypes.STRING);
        attachmentTypes.add(SOAPConstants.QNAME_TYPE_STRING);
        attachmentTypes.add(SOAP12Constants.QNAME_TYPE_STRING);
        encoderMap = new HashMap();
        encoderMap.put(QNAME_TYPE_IMAGE, "ImageAttachmentEncoder");
        encoderMap.put(QNAME_TYPE_MIME_MULTIPART, "MimeMultipartAttachmentEncoder");
        encoderMap.put(QNAME_TYPE_SOURCE, "SourceAttachmentEncoder");
        encoderMap.put(QNAME_TYPE_DATA_HANDLER, "DataHandlerAttachmentEncoder");
        encoderMap.put(BuiltInTypes.BOOLEAN, "XSDBooleanEncoder");
        encoderMap.put(BuiltInTypes.BYTE, "XSDByteEncoder");
        encoderMap.put(BuiltInTypes.BASE64_BINARY, null);
        encoderMap.put(BuiltInTypes.HEX_BINARY, null);
        encoderMap.put(BuiltInTypes.DOUBLE, "XSDDoubleEncoder");
        encoderMap.put(BuiltInTypes.FLOAT, "XSDFloatEncoder");
        encoderMap.put(BuiltInTypes.INT, "XSDIntEncoder");
        encoderMap.put(BuiltInTypes.INTEGER, "XSDIntegerEncoder");
        encoderMap.put(BuiltInTypes.LONG, "XSDLongEncoder");
        encoderMap.put(BuiltInTypes.SHORT, "XSDShortEncoder");
        encoderMap.put(BuiltInTypes.DECIMAL, "XSDDecimalEncoder");
        encoderMap.put(BuiltInTypes.DATE_TIME, null);
        encoderMap.put(BuiltInTypes.STRING, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.QNAME, "XSDQNameEncoder");
        encoderMap.put(BuiltInTypes.LANGUAGE, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.NORMALIZED_STRING, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.TOKEN, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.NMTOKEN, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.NAME, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.ID, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.NCNAME, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.POSITIVE_INTEGER, "XSDPositiveIntegerEncoder");
        encoderMap.put(BuiltInTypes.NON_POSITIVE_INTEGER, "XSDNonPositiveIntegerEncoder");
        encoderMap.put(BuiltInTypes.NEGATIVE_INTEGER, "XSDNegativeIntegerEncoder");
        encoderMap.put(BuiltInTypes.NON_NEGATIVE_INTEGER, "XSDNonNegativeIntegerEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_LONG, "XSDUnsignedLongEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_INT, "XSDUnsignedIntEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_SHORT, "XSDUnsignedShortEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_BYTE, "XSDUnsignedByteEncoder");
        encoderMap.put(BuiltInTypes.DURATION, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.TIME, "XSDTimeEncoder");
        encoderMap.put(BuiltInTypes.DATE, "XSDDateEncoder");
        encoderMap.put(BuiltInTypes.G_YEAR_MONTH, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.G_YEAR, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.G_MONTH_DAY, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.G_DAY, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.G_MONTH, "XSDStringEncoder");
        if (!VersionUtil.isJavaVersionGreaterThan1_3()) {
            encoderMap.put(BuiltInTypes.ANY_URI, "XSDStringEncoder");
        } else {
            encoderMap.put(BuiltInTypes.ANY_URI, "XSDAnyURIEncoder");
        }
        encoderMap.put(BuiltInTypes.IDREF, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.IDREFS, "XSDListTypeEncoder");
        encoderMap.put(BuiltInTypes.NMTOKENS, "XSDListTypeEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_BOOLEAN, "XSDBooleanEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_BYTE, "XSDByteEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_BASE64_BINARY, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DOUBLE, "XSDDoubleEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_FLOAT, "XSDFloatEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_INT, "XSDIntEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_LONG, "XSDLongEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_SHORT, "XSDShortEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_DECIMAL, "XSDDecimalEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_DATE_TIME, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_STRING, "XSDStringEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_QNAME, "XSDQNameEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_BOOLEAN, "XSDBooleanEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_BYTE, "XSDByteEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_BASE64_BINARY, null);
        encoderMap.put(SOAP12Constants.QNAME_TYPE_DOUBLE, "XSDDoubleEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_FLOAT, "XSDFloatEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_INT, "XSDIntEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_LONG, "XSDLongEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_SHORT, "XSDShortEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_DECIMAL, "XSDDecimalEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_DATE_TIME, null);
        encoderMap.put(SOAP12Constants.QNAME_TYPE_STRING, "XSDStringEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_QNAME, "XSDQNameEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_DATE, "XSDDateEncoder");
        encoderMap.put(BuiltInTypes.ANY_SIMPLE_URTYPE, "XSDStringEncoder");
    }
}

