/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.ApplyAfterFunction;
import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.DataDerivTypeFunction;
import com.thaiopensource.relaxng.pattern.NormalizedNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.StartAttributeDerivFunction;
import com.thaiopensource.relaxng.pattern.StartTagOpenDerivFunction;
import com.thaiopensource.relaxng.pattern.StartTagOpenRecoverDerivFunction;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PatternMemo {
    private final Pattern pattern;
    private final ValidatorPatternBuilder builder;
    private final boolean notAllowed;
    private PatternMemo memoEndAttributes;
    private PatternMemo memoTextOnly;
    private PatternMemo memoEndTagDeriv;
    private PatternMemo memoMixedTextDeriv;
    private PatternMemo memoIgnoreMissingAttributes;
    private Map<Name, PatternMemo> startTagOpenDerivMap;
    private Map<Name, PatternMemo> startTagOpenRecoverDerivMap;
    private Map<Name, PatternMemo> startAttributeDerivMap;
    private DataDerivType memoDataDerivType;
    private PatternMemo memoRecoverAfter;
    private PatternMemo memoEmptyAfter;
    private NormalizedNameClass memoPossibleAttributeNames;
    private NormalizedNameClass memoPossibleStartTagNames;

    PatternMemo(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder) {
        this.pattern = pattern;
        this.builder = validatorPatternBuilder;
        this.notAllowed = pattern.isNotAllowed();
    }

    Pattern getPattern() {
        return this.pattern;
    }

    ValidatorPatternBuilder getPatternBuilder() {
        return this.builder;
    }

    boolean isNotAllowed() {
        return this.notAllowed;
    }

    PatternMemo endAttributes() {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(this.builder.getEndAttributesFunction());
        }
        return this.memoEndAttributes;
    }

    PatternMemo endAttributes(PatternFunction<Pattern> patternFunction) {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(patternFunction);
        }
        return this.memoEndAttributes;
    }

    PatternMemo ignoreMissingAttributes() {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(this.builder.getIgnoreMissingAttributesFunction());
        }
        return this.memoIgnoreMissingAttributes;
    }

    PatternMemo ignoreMissingAttributes(PatternFunction<Pattern> patternFunction) {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(patternFunction);
        }
        return this.memoIgnoreMissingAttributes;
    }

    PatternMemo textOnly() {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(this.builder.getTextOnlyFunction());
        }
        return this.memoTextOnly;
    }

    PatternMemo textOnly(PatternFunction<Pattern> patternFunction) {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(patternFunction);
        }
        return this.memoTextOnly;
    }

    PatternMemo endTagDeriv() {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(this.builder.getEndTagDerivFunction());
        }
        return this.memoEndTagDeriv;
    }

    PatternMemo endTagDeriv(PatternFunction<Pattern> patternFunction) {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(patternFunction);
        }
        return this.memoEndTagDeriv;
    }

    PatternMemo mixedTextDeriv() {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(this.builder.getMixedTextDerivFunction());
        }
        return this.memoMixedTextDeriv;
    }

    PatternMemo mixedTextDeriv(PatternFunction<Pattern> patternFunction) {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(patternFunction);
        }
        return this.memoMixedTextDeriv;
    }

    PatternMemo startTagOpenDeriv(Name name) {
        return this.startTagOpenDeriv(name, null);
    }

    PatternMemo startTagOpenDeriv(StartTagOpenDerivFunction startTagOpenDerivFunction) {
        return this.startTagOpenDeriv(startTagOpenDerivFunction.getName(), startTagOpenDerivFunction);
    }

    private PatternMemo startTagOpenDeriv(Name name, StartTagOpenDerivFunction startTagOpenDerivFunction) {
        PatternMemo patternMemo;
        if (this.startTagOpenDerivMap == null) {
            this.startTagOpenDerivMap = new HashMap<Name, PatternMemo>();
        } else {
            patternMemo = this.startTagOpenDerivMap.get(name);
            if (patternMemo != null) {
                return patternMemo;
            }
        }
        if (startTagOpenDerivFunction == null) {
            startTagOpenDerivFunction = new StartTagOpenDerivFunction(name, this.builder);
        }
        patternMemo = this.applyForPatternMemo(startTagOpenDerivFunction);
        this.startTagOpenDerivMap.put(name, patternMemo);
        return patternMemo;
    }

    PatternMemo startTagOpenRecoverDeriv(Name name) {
        return this.startTagOpenRecoverDeriv(name, null);
    }

    PatternMemo startTagOpenRecoverDeriv(StartTagOpenRecoverDerivFunction startTagOpenRecoverDerivFunction) {
        return this.startTagOpenRecoverDeriv(startTagOpenRecoverDerivFunction.getName(), startTagOpenRecoverDerivFunction);
    }

    private PatternMemo startTagOpenRecoverDeriv(Name name, StartTagOpenRecoverDerivFunction startTagOpenRecoverDerivFunction) {
        PatternMemo patternMemo;
        if (this.startTagOpenRecoverDerivMap == null) {
            this.startTagOpenRecoverDerivMap = new HashMap<Name, PatternMemo>();
        } else {
            patternMemo = this.startTagOpenRecoverDerivMap.get(name);
            if (patternMemo != null) {
                return patternMemo;
            }
        }
        if (startTagOpenRecoverDerivFunction == null) {
            startTagOpenRecoverDerivFunction = new StartTagOpenRecoverDerivFunction(name, this.builder);
        }
        patternMemo = this.applyForPatternMemo(startTagOpenRecoverDerivFunction);
        this.startTagOpenRecoverDerivMap.put(name, patternMemo);
        return patternMemo;
    }

    PatternMemo startAttributeDeriv(Name name) {
        return this.startAttributeDeriv(name, null);
    }

    PatternMemo startAttributeDeriv(StartAttributeDerivFunction startAttributeDerivFunction) {
        return this.startAttributeDeriv(startAttributeDerivFunction.getName(), startAttributeDerivFunction);
    }

    private PatternMemo startAttributeDeriv(Name name, StartAttributeDerivFunction startAttributeDerivFunction) {
        PatternMemo patternMemo;
        if (this.startAttributeDerivMap == null) {
            this.startAttributeDerivMap = new HashMap<Name, PatternMemo>();
        } else {
            patternMemo = this.startAttributeDerivMap.get(name);
            if (patternMemo != null) {
                return patternMemo;
            }
        }
        if (startAttributeDerivFunction == null) {
            startAttributeDerivFunction = new StartAttributeDerivFunction(name, this.builder);
        }
        patternMemo = this.applyForPatternMemo(startAttributeDerivFunction);
        this.startAttributeDerivMap.put(name, patternMemo);
        return patternMemo;
    }

    DataDerivType dataDerivType() {
        if (this.memoDataDerivType == null) {
            this.memoDataDerivType = DataDerivTypeFunction.dataDerivType(this.builder, this.pattern).copy();
        }
        return this.memoDataDerivType;
    }

    PatternMemo dataDeriv(String string2, ValidationContext validationContext) {
        return this.dataDerivType().dataDeriv(this.builder, this.pattern, string2, validationContext, null);
    }

    PatternMemo dataDeriv(String string2, ValidationContext validationContext, List<DataDerivFailure> list) {
        return this.dataDerivType().dataDeriv(this.builder, this.pattern, string2, validationContext, list);
    }

    PatternMemo recoverAfter() {
        if (this.memoRecoverAfter == null) {
            this.memoRecoverAfter = this.applyForPatternMemo(this.builder.getRecoverAfterFunction());
        }
        return this.memoRecoverAfter;
    }

    PatternMemo emptyAfter() {
        if (this.memoEmptyAfter == null) {
            this.memoEmptyAfter = this.applyForPatternMemo(new ApplyAfterFunction(this.builder){

                Pattern apply(Pattern pattern) {
                    return PatternMemo.this.builder.makeEmpty();
                }

                public Pattern caseOther(Pattern pattern) {
                    return pattern;
                }
            });
        }
        return this.memoEmptyAfter;
    }

    NormalizedNameClass possibleStartTagNames() {
        if (this.memoPossibleStartTagNames == null) {
            this.memoPossibleStartTagNames = this.builder.getPossibleStartTagNamesFunction().applyTo(this.pattern);
        }
        return this.memoPossibleStartTagNames;
    }

    NormalizedNameClass possibleAttributeNames() {
        if (this.memoPossibleAttributeNames == null) {
            this.memoPossibleAttributeNames = this.builder.getPossibleAttributeNamesFunction().applyTo(this.pattern);
        }
        return this.memoPossibleAttributeNames;
    }

    private PatternMemo applyForPatternMemo(PatternFunction<Pattern> patternFunction) {
        return this.builder.getPatternMemo(this.pattern.apply(patternFunction));
    }
}

