/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.ParseReceiver;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.ParsedPatternFuture;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.SubParser;
import com.thaiopensource.relaxng.pattern.AnnotationsImpl;
import com.thaiopensource.relaxng.pattern.AnyNameClass;
import com.thaiopensource.relaxng.pattern.AnyNameExceptNameClass;
import com.thaiopensource.relaxng.pattern.AttributeNameClassChecker;
import com.thaiopensource.relaxng.pattern.BuiltinDatatypeLibraryFactory;
import com.thaiopensource.relaxng.pattern.ChoiceNameClass;
import com.thaiopensource.relaxng.pattern.CommentListImpl;
import com.thaiopensource.relaxng.pattern.ErrorNameClass;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameFormatter;
import com.thaiopensource.relaxng.pattern.NsNameClass;
import com.thaiopensource.relaxng.pattern.NsNameExceptNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFuture;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBuilderImpl
extends AnnotationsImpl
implements ElementAnnotationBuilder<Locator, VoidValue, CommentListImpl>,
SchemaBuilder<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
    private final SchemaBuilderImpl parent;
    private boolean hadError = false;
    private final SubParser<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> subParser;
    private final SchemaPatternBuilder pb;
    private final DatatypeLibraryFactory datatypeLibraryFactory;
    private final String inheritNs;
    private final ErrorHandler eh;
    private final OpenIncludes openIncludes;
    private final AttributeNameClassChecker attributeNameClassChecker = new AttributeNameClassChecker();
    static final Localizer localizer = new Localizer(SchemaBuilderImpl.class);

    public static Pattern parse(Parseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parseable, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder schemaPatternBuilder, boolean bl) throws IllegalSchemaException, IOException, SAXException {
        try {
            SchemaBuilderImpl schemaBuilderImpl = new SchemaBuilderImpl(parseable, errorHandler, new BuiltinDatatypeLibraryFactory(datatypeLibraryFactory), schemaPatternBuilder);
            Pattern pattern = parseable.parse(schemaBuilderImpl, new RootScope(schemaBuilderImpl));
            if (bl) {
                pattern = schemaBuilderImpl.wrapAttributesPattern(pattern);
            }
            return schemaBuilderImpl.expandPattern(pattern);
        }
        catch (BuildException buildException) {
            throw SchemaBuilderImpl.unwrapBuildException(buildException);
        }
    }

    public static PatternFuture installHandlers(ParseReceiver<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parseReceiver, XMLReader xMLReader, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder schemaPatternBuilder) throws SAXException {
        final SchemaBuilderImpl schemaBuilderImpl = new SchemaBuilderImpl(parseReceiver, errorHandler, new BuiltinDatatypeLibraryFactory(datatypeLibraryFactory), schemaPatternBuilder);
        final ParsedPatternFuture<Pattern> parsedPatternFuture = parseReceiver.installHandlers(xMLReader, schemaBuilderImpl, new RootScope(schemaBuilderImpl));
        return new PatternFuture(){

            public Pattern getPattern(boolean bl) throws IllegalSchemaException, SAXException, IOException {
                try {
                    Pattern pattern = (Pattern)parsedPatternFuture.getParsedPattern();
                    if (bl) {
                        pattern = schemaBuilderImpl.wrapAttributesPattern(pattern);
                    }
                    return schemaBuilderImpl.expandPattern(pattern);
                }
                catch (BuildException buildException) {
                    throw SchemaBuilderImpl.unwrapBuildException(buildException);
                }
            }
        };
    }

    public static RuntimeException unwrapBuildException(BuildException buildException) throws SAXException, IllegalSchemaException, IOException {
        Throwable throwable = buildException.getCause();
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof IllegalSchemaException) {
            throw new IllegalSchemaException();
        }
        if (throwable instanceof SAXException) {
            throw (SAXException)throwable;
        }
        if (throwable instanceof Exception) {
            throw new SAXException((Exception)throwable);
        }
        throw new SAXException(throwable.getClass().getName() + " thrown");
    }

    private Pattern wrapAttributesPattern(Pattern pattern) {
        return this.makeElement(this.makeAnyName(null, null), pattern, null, null);
    }

    private Pattern expandPattern(Pattern pattern) throws IllegalSchemaException, BuildException {
        if (!this.hadError) {
            try {
                pattern.checkRecursion(0);
                pattern = pattern.expand(this.pb);
                pattern.checkRestrictions(0, null, null);
                if (!this.hadError) {
                    return pattern;
                }
            }
            catch (SAXParseException sAXParseException) {
                this.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new BuildException(sAXException);
            }
            catch (RestrictionViolationException restrictionViolationException) {
                if (restrictionViolationException.getName() != null) {
                    this.error(restrictionViolationException.getMessageId(), NameFormatter.format(restrictionViolationException.getName()), restrictionViolationException.getLocator());
                }
                if (restrictionViolationException.getNamespaceUri() != null) {
                    this.error(restrictionViolationException.getMessageId(), restrictionViolationException.getNamespaceUri(), restrictionViolationException.getLocator());
                }
                this.error(restrictionViolationException.getMessageId(), restrictionViolationException.getLocator());
            }
        }
        throw new IllegalSchemaException();
    }

    private SchemaBuilderImpl(SubParser<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> subParser, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder schemaPatternBuilder) {
        this.parent = null;
        this.subParser = subParser;
        this.eh = errorHandler;
        this.datatypeLibraryFactory = datatypeLibraryFactory;
        this.pb = schemaPatternBuilder;
        this.inheritNs = "";
        this.openIncludes = null;
    }

    private SchemaBuilderImpl(String string2, String string3, SchemaBuilderImpl schemaBuilderImpl) {
        this.parent = schemaBuilderImpl;
        this.subParser = schemaBuilderImpl.subParser;
        this.eh = schemaBuilderImpl.eh;
        this.datatypeLibraryFactory = schemaBuilderImpl.datatypeLibraryFactory;
        this.pb = schemaBuilderImpl.pb;
        this.inheritNs = schemaBuilderImpl.resolveInherit(string2);
        this.openIncludes = new OpenIncludes(string3, schemaBuilderImpl.openIncludes);
    }

    @java.lang.Override
    public Pattern makeChoice(List<Pattern> list, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        int n = list.size();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern pattern = list.get(0);
        for (int i = 1; i < n; ++i) {
            pattern = this.pb.makeChoice(pattern, list.get(i));
        }
        return pattern;
    }

    @java.lang.Override
    public Pattern makeInterleave(List<Pattern> list, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        int n = list.size();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern pattern = list.get(0);
        for (int i = 1; i < n; ++i) {
            pattern = this.pb.makeInterleave(pattern, list.get(i));
        }
        return pattern;
    }

    @java.lang.Override
    public Pattern makeGroup(List<Pattern> list, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        int n = list.size();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern pattern = list.get(0);
        for (int i = 1; i < n; ++i) {
            pattern = this.pb.makeGroup(pattern, list.get(i));
        }
        return pattern;
    }

    @java.lang.Override
    public Pattern makeOneOrMore(Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        return this.pb.makeOneOrMore(pattern);
    }

    @java.lang.Override
    public Pattern makeZeroOrMore(Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        return this.pb.makeZeroOrMore(pattern);
    }

    @java.lang.Override
    public Pattern makeOptional(Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        return this.pb.makeOptional(pattern);
    }

    @java.lang.Override
    public Pattern makeList(Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        return this.pb.makeList(pattern, locator);
    }

    @java.lang.Override
    public Pattern makeMixed(Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        return this.pb.makeMixed(pattern);
    }

    @java.lang.Override
    public Pattern makeEmpty(Locator locator, AnnotationsImpl annotationsImpl) {
        return this.pb.makeEmpty();
    }

    @java.lang.Override
    public Pattern makeNotAllowed(Locator locator, AnnotationsImpl annotationsImpl) {
        return this.pb.makeUnexpandedNotAllowed();
    }

    @java.lang.Override
    public Pattern makeText(Locator locator, AnnotationsImpl annotationsImpl) {
        return this.pb.makeText();
    }

    @java.lang.Override
    public Pattern makeErrorPattern() {
        return this.pb.makeError();
    }

    @java.lang.Override
    public NameClass makeErrorNameClass() {
        return new ErrorNameClass();
    }

    @java.lang.Override
    public Pattern makeAttribute(NameClass nameClass, Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        String string2 = this.attributeNameClassChecker.checkNameClass(nameClass);
        if (string2 != null) {
            this.error(string2, locator);
        }
        return this.pb.makeAttribute(nameClass, pattern, locator);
    }

    @java.lang.Override
    public Pattern makeElement(NameClass nameClass, Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        return this.pb.makeElement(nameClass, pattern, locator);
    }

    @java.lang.Override
    public DataPatternBuilder<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeDataPatternBuilder(String string2, String string3, Locator locator) throws BuildException {
        DatatypeLibrary datatypeLibrary = this.datatypeLibraryFactory.createDatatypeLibrary(string2);
        if (datatypeLibrary == null) {
            this.error("unrecognized_datatype_library", string2, locator);
        } else {
            try {
                return new DataPatternBuilderImpl(datatypeLibrary.createDatatypeBuilder(string3), new Name(string2, string3));
            }
            catch (DatatypeException datatypeException) {
                String string4 = datatypeException.getMessage();
                if (string4 != null) {
                    this.error("unsupported_datatype_detail", string2, string3, string4, locator);
                }
                this.error("unrecognized_datatype", string2, string3, locator);
            }
        }
        return new DummyDataPatternBuilder();
    }

    @java.lang.Override
    public Pattern makeValue(String string2, String string3, String string4, Context context, String string5, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        block8: {
            DatatypeLibrary datatypeLibrary = this.datatypeLibraryFactory.createDatatypeLibrary(string2);
            if (datatypeLibrary == null) {
                this.error("unrecognized_datatype_library", string2, locator);
            } else {
                try {
                    DatatypeBuilder datatypeBuilder = datatypeLibrary.createDatatypeBuilder(string3);
                    try {
                        Datatype datatype = datatypeBuilder.createDatatype();
                        Object object = datatype.createValue(string4, new ValidationContextImpl(context, string5));
                        if (object != null) {
                            return this.pb.makeValue(datatype, new Name(string2, string3), object, string4);
                        }
                        this.error("invalid_value", string4, locator);
                    }
                    catch (DatatypeException datatypeException) {
                        String string6 = datatypeException.getMessage();
                        if (string6 != null) {
                            this.error("datatype_requires_param_detail", string6, locator);
                            break block8;
                        }
                        this.error("datatype_requires_param", locator);
                    }
                }
                catch (DatatypeException datatypeException) {
                    this.error("unrecognized_datatype", string2, string3, locator);
                }
            }
        }
        return this.pb.makeError();
    }

    @java.lang.Override
    public Grammar<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeGrammar(Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> scope) {
        return new GrammarImpl(this, scope);
    }

    @java.lang.Override
    public Pattern makeExternalRef(String string2, String string3, String string4, Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> scope, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        SubParseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> subParseable = this.subParser.createSubParseable(string2, string3);
        String string5 = subParseable.getUri();
        OpenIncludes openIncludes = this.openIncludes;
        while (openIncludes != null) {
            if (openIncludes.uri.equals(string5)) {
                this.error("recursive_include", string5, locator);
                return this.pb.makeError();
            }
            openIncludes = openIncludes.parent;
        }
        try {
            return subParseable.parse(new SchemaBuilderImpl(string4, string5, this), scope);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            this.noteError();
            return this.pb.makeError();
        }
    }

    @java.lang.Override
    public NameClass makeNameClassChoice(List<NameClass> list, Locator locator, AnnotationsImpl annotationsImpl) {
        int n = list.size();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        NameClass nameClass = list.get(0);
        for (int i = 1; i < n; ++i) {
            nameClass = new ChoiceNameClass(nameClass, list.get(i));
        }
        return nameClass;
    }

    @java.lang.Override
    public NameClass makeName(String string2, String string3, String string4, Locator locator, AnnotationsImpl annotationsImpl) {
        return new SimpleNameClass(new Name(this.resolveInherit(string2), string3));
    }

    @java.lang.Override
    public NameClass makeNsName(String string2, Locator locator, AnnotationsImpl annotationsImpl) {
        return new NsNameClass(this.resolveInherit(string2));
    }

    @java.lang.Override
    public NameClass makeNsName(String string2, NameClass nameClass, Locator locator, AnnotationsImpl annotationsImpl) {
        return new NsNameExceptNameClass(this.resolveInherit(string2), nameClass);
    }

    @java.lang.Override
    public NameClass makeAnyName(Locator locator, AnnotationsImpl annotationsImpl) {
        return new AnyNameClass();
    }

    @java.lang.Override
    public NameClass makeAnyName(NameClass nameClass, Locator locator, AnnotationsImpl annotationsImpl) {
        return new AnyNameExceptNameClass(nameClass);
    }

    @java.lang.Override
    public AnnotationsImpl makeAnnotations(CommentListImpl commentListImpl, Context context) {
        return this;
    }

    @java.lang.Override
    public VoidValue makeElementAnnotation() throws BuildException {
        return VoidValue.VOID;
    }

    @java.lang.Override
    public void addText(String string2, Locator locator, CommentListImpl commentListImpl) throws BuildException {
    }

    @java.lang.Override
    public ElementAnnotationBuilder<Locator, VoidValue, CommentListImpl> makeElementAnnotationBuilder(String string2, String string3, String string4, Locator locator, CommentListImpl commentListImpl, Context context) {
        return this;
    }

    @java.lang.Override
    public CommentListImpl makeCommentList() {
        return this;
    }

    @java.lang.Override
    public boolean usesComments() {
        return false;
    }

    @java.lang.Override
    public Pattern annotatePattern(Pattern pattern, AnnotationsImpl annotationsImpl) throws BuildException {
        return pattern;
    }

    @java.lang.Override
    public NameClass annotateNameClass(NameClass nameClass, AnnotationsImpl annotationsImpl) throws BuildException {
        return nameClass;
    }

    @java.lang.Override
    public Pattern annotateAfterPattern(Pattern pattern, VoidValue voidValue) throws BuildException {
        return pattern;
    }

    @java.lang.Override
    public NameClass annotateAfterNameClass(NameClass nameClass, VoidValue voidValue) throws BuildException {
        return nameClass;
    }

    @java.lang.Override
    public Pattern commentAfterPattern(Pattern pattern, CommentListImpl commentListImpl) throws BuildException {
        return pattern;
    }

    @java.lang.Override
    public NameClass commentAfterNameClass(NameClass nameClass, CommentListImpl commentListImpl) throws BuildException {
        return nameClass;
    }

    private String resolveInherit(String string2) {
        if (string2 == INHERIT_NS) {
            return this.inheritNs;
        }
        return string2;
    }

    @java.lang.Override
    public Locator makeLocation(String string2, int n, int n2) {
        return new LocatorImpl(string2, n, n2);
    }

    private void error(SAXParseException sAXParseException) throws BuildException {
        this.noteError();
        try {
            if (this.eh != null) {
                this.eh.error(sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            throw new BuildException(sAXException);
        }
    }

    private void error(String string2, Locator locator) throws BuildException {
        this.error(new SAXParseException(localizer.message(string2), locator));
    }

    private void error(String string2, String string3, Locator locator) throws BuildException {
        this.error(new SAXParseException(localizer.message(string2, string3), locator));
    }

    private void error(String string2, String string3, String string4, Locator locator) throws BuildException {
        this.error(new SAXParseException(localizer.message(string2, string3, string4), locator));
    }

    private void error(String string2, String string3, String string4, String string5, Locator locator) throws BuildException {
        this.error(new SAXParseException(localizer.message(string2, new Object[]{string3, string4, string5}), locator));
    }

    private void noteError() {
        if (!this.hadError && this.parent != null) {
            this.parent.noteError();
        }
        this.hadError = true;
    }

    private class LocatorImpl
    implements Locator {
        private final String systemId;
        private final int lineNumber;
        private final int columnNumber;

        private LocatorImpl(String string2, int n, int n2) {
            this.systemId = string2;
            this.lineNumber = n;
            this.columnNumber = n2;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncludeImpl
    implements Include<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl>,
    Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final SchemaBuilderImpl sb;
        private Override overrides;
        private final GrammarImpl grammar;

        private IncludeImpl(SchemaBuilderImpl schemaBuilderImpl, GrammarImpl grammarImpl) {
            this.sb = schemaBuilderImpl;
            this.grammar = grammarImpl;
        }

        @java.lang.Override
        public void define(String string2, GrammarSection.Combine combine, Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            RefPattern refPattern = this.grammar.lookup(string2);
            this.overrides = new Override(refPattern, this.overrides);
            this.grammar.define(refPattern, combine, pattern, locator);
        }

        @java.lang.Override
        public void endDiv(Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        }

        @java.lang.Override
        public void topLevelAnnotation(VoidValue voidValue) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentListImpl commentListImpl) throws BuildException {
        }

        @java.lang.Override
        public Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeDiv() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @java.lang.Override
        public void endInclude(String string2, String string3, String string4, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            SubParseable subParseable = this.sb.subParser.createSubParseable(string2, string3);
            String string5 = subParseable.getUri();
            Object object = this.sb.openIncludes;
            while (object != null) {
                if (((OpenIncludes)object).uri.equals(string5)) {
                    this.sb.error("recursive_include", string5, locator);
                    return;
                }
                object = ((OpenIncludes)object).parent;
            }
            object = this.overrides;
            while (object != null) {
                ((Override)object).replacementStatus = ((Override)object).prp.getReplacementStatus();
                ((Override)object).prp.setReplacementStatus((byte)1);
                object = ((Override)object).next;
            }
            try {
                object = new SchemaBuilderImpl(string4, string5, this.sb);
                subParseable.parseAsInclude(object, new GrammarImpl((SchemaBuilderImpl)object, this.grammar));
                Override override = this.overrides;
                while (override != null) {
                    if (override.prp.getReplacementStatus() == 1) {
                        if (override.prp.getName() == null) {
                            this.sb.error("missing_start_replacement", locator);
                        } else {
                            this.sb.error("missing_define_replacement", override.prp.getName(), locator);
                        }
                    }
                    override = override.next;
                }
                object = this.overrides;
            }
            catch (IllegalSchemaException illegalSchemaException) {
                Override override;
                try {
                    this.sb.noteError();
                    override = this.overrides;
                }
                catch (Throwable throwable) {
                    Override override2 = this.overrides;
                    while (override2 != null) {
                        override2.prp.setReplacementStatus(override2.replacementStatus);
                        override2 = override2.next;
                    }
                    throw throwable;
                }
                while (override != null) {
                    override.prp.setReplacementStatus(override.replacementStatus);
                    override = override.next;
                }
            }
            while (object != null) {
                ((Override)object).prp.setReplacementStatus(((Override)object).replacementStatus);
                object = ((Override)object).next;
            }
        }

        @java.lang.Override
        public Include<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeInclude() {
            return null;
        }
    }

    static class Override {
        final RefPattern prp;
        final Override next;
        byte replacementStatus;

        Override(RefPattern refPattern, Override override) {
            this.prp = refPattern;
            this.next = override;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RootScope
    implements Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final SchemaBuilderImpl sb;

        RootScope(SchemaBuilderImpl schemaBuilderImpl) {
            this.sb = schemaBuilderImpl;
        }

        @java.lang.Override
        public Pattern makeParentRef(String string2, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            this.sb.error("parent_ref_outside_grammar", locator);
            return this.sb.makeErrorPattern();
        }

        @java.lang.Override
        public Pattern makeRef(String string2, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            this.sb.error("ref_outside_grammar", locator);
            return this.sb.makeErrorPattern();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GrammarImpl
    implements Grammar<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl>,
    Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl>,
    IncludedGrammar<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final SchemaBuilderImpl sb;
        private final Map<String, RefPattern> defines;
        private final RefPattern startRef;
        private final Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parent;

        private GrammarImpl(SchemaBuilderImpl schemaBuilderImpl, Scope<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> scope) {
            this.sb = schemaBuilderImpl;
            this.parent = scope;
            this.defines = new HashMap<String, RefPattern>();
            this.startRef = new RefPattern(null);
        }

        protected GrammarImpl(SchemaBuilderImpl schemaBuilderImpl, GrammarImpl grammarImpl) {
            this.sb = schemaBuilderImpl;
            this.parent = grammarImpl.parent;
            this.startRef = grammarImpl.startRef;
            this.defines = grammarImpl.defines;
        }

        @java.lang.Override
        public Pattern endGrammar(Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            for (String string2 : this.defines.keySet()) {
                RefPattern refPattern = this.defines.get(string2);
                if (refPattern.getPattern() != null) continue;
                this.sb.error("reference_to_undefined", string2, refPattern.getRefLocator());
                refPattern.setPattern(this.sb.pb.makeError());
            }
            Object object = this.startRef.getPattern();
            if (object == null) {
                this.sb.error("missing_start_element", locator);
                object = this.sb.pb.makeError();
            }
            return object;
        }

        @java.lang.Override
        public void endDiv(Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        }

        @java.lang.Override
        public Pattern endIncludedGrammar(Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            return null;
        }

        @java.lang.Override
        public void define(String string2, GrammarSection.Combine combine, Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            this.define(this.lookup(string2), combine, pattern, locator);
        }

        private void define(RefPattern refPattern, GrammarSection.Combine combine, Pattern pattern, Locator locator) throws BuildException {
            switch (refPattern.getReplacementStatus()) {
                case 0: {
                    if (combine == null) {
                        if (refPattern.isCombineImplicit()) {
                            if (refPattern.getName() == null) {
                                this.sb.error("duplicate_start", locator);
                            } else {
                                this.sb.error("duplicate_define", refPattern.getName(), locator);
                            }
                        } else {
                            refPattern.setCombineImplicit();
                        }
                    } else {
                        byte by;
                        byte by2 = by = combine == COMBINE_CHOICE ? (byte)1 : 2;
                        if (refPattern.getCombineType() != 0 && refPattern.getCombineType() != by) {
                            if (refPattern.getName() == null) {
                                this.sb.error("conflict_combine_start", locator);
                            } else {
                                this.sb.error("conflict_combine_define", refPattern.getName(), locator);
                            }
                        }
                        refPattern.setCombineType(by);
                    }
                    if (refPattern.getPattern() == null) {
                        refPattern.setPattern(pattern);
                        break;
                    }
                    if (refPattern.getCombineType() == 2) {
                        refPattern.setPattern(this.sb.pb.makeInterleave(refPattern.getPattern(), pattern));
                        break;
                    }
                    refPattern.setPattern(this.sb.pb.makeChoice(refPattern.getPattern(), pattern));
                    break;
                }
                case 1: {
                    refPattern.setReplacementStatus((byte)2);
                    break;
                }
            }
        }

        @java.lang.Override
        public void topLevelAnnotation(VoidValue voidValue) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentListImpl commentListImpl) throws BuildException {
        }

        private RefPattern lookup(String string2) {
            if (string2 == "#start") {
                return this.startRef;
            }
            return this.lookup1(string2);
        }

        private RefPattern lookup1(String string2) {
            RefPattern refPattern = this.defines.get(string2);
            if (refPattern == null) {
                refPattern = new RefPattern(string2);
                this.defines.put(string2, refPattern);
            }
            return refPattern;
        }

        @java.lang.Override
        public Pattern makeRef(String string2, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            RefPattern refPattern = this.lookup1(string2);
            if (refPattern.getRefLocator() == null && locator != null) {
                refPattern.setRefLocator(locator);
            }
            return refPattern;
        }

        @java.lang.Override
        public Pattern makeParentRef(String string2, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            if (this.parent == null) {
                this.sb.error("parent_ref_outside_grammar", locator);
                return this.sb.makeErrorPattern();
            }
            return this.parent.makeRef(string2, locator, annotationsImpl);
        }

        @java.lang.Override
        public Div<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeDiv() {
            return this;
        }

        @java.lang.Override
        public Include<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> makeInclude() {
            return new IncludeImpl(this.sb, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPatternBuilderImpl
    implements DataPatternBuilder<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private final DatatypeBuilder dtb;
        private final Name dtName;
        private final List<String> params = new ArrayList<String>();

        DataPatternBuilderImpl(DatatypeBuilder datatypeBuilder, Name name) {
            this.dtb = datatypeBuilder;
            this.dtName = name;
        }

        @java.lang.Override
        public void addParam(String string2, String string3, Context context, String string4, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            try {
                this.dtb.addParameter(string2, string3, new ValidationContextImpl(context, string4));
                this.params.add(string2);
                this.params.add(string3);
            }
            catch (DatatypeException datatypeException) {
                String string5 = datatypeException.getMessage();
                int n = datatypeException.getIndex();
                String string6 = n == -1 ? null : this.displayParam(string3, n);
                if (string6 != null) {
                    if (string5 != null) {
                        SchemaBuilderImpl.this.error("invalid_param_detail_display", string5, string6, locator);
                    } else {
                        SchemaBuilderImpl.this.error("invalid_param_display", string6, locator);
                    }
                }
                if (string5 != null) {
                    SchemaBuilderImpl.this.error("invalid_param_detail", string5, locator);
                }
                SchemaBuilderImpl.this.error("invalid_param", locator);
            }
        }

        @java.lang.Override
        public void annotation(VoidValue voidValue) throws BuildException {
        }

        String displayParam(String string2, int n) {
            if (n < 0) {
                n = 0;
            } else if (n > string2.length()) {
                n = string2.length();
            }
            return localizer.message("display_param", string2.substring(0, n), string2.substring(n));
        }

        @java.lang.Override
        public Pattern makePattern(Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeData(this.dtb.createDatatype(), this.dtName, this.params);
            }
            catch (DatatypeException datatypeException) {
                String string2 = datatypeException.getMessage();
                if (string2 != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", string2, locator);
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", locator);
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }

        @java.lang.Override
        public Pattern makePattern(Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeDataExcept(this.dtb.createDatatype(), this.dtName, this.params, pattern, locator);
            }
            catch (DatatypeException datatypeException) {
                String string2 = datatypeException.getMessage();
                if (string2 != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", string2, locator);
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", locator);
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }
    }

    private class ValidationContextImpl
    implements ValidationContext {
        private final ValidationContext vc;
        private final String ns;

        ValidationContextImpl(ValidationContext validationContext, String string2) {
            this.vc = validationContext;
            this.ns = string2.length() == 0 ? null : string2;
        }

        public String resolveNamespacePrefix(String string2) {
            String string3;
            String string4 = string3 = string2.length() == 0 ? this.ns : this.vc.resolveNamespacePrefix(string2);
            if (string3 == SchemaBuilder.INHERIT_NS) {
                if (SchemaBuilderImpl.this.inheritNs.length() == 0) {
                    return null;
                }
                return SchemaBuilderImpl.this.inheritNs;
            }
            return string3;
        }

        public String getBaseUri() {
            return this.vc.getBaseUri();
        }

        public boolean isUnparsedEntity(String string2) {
            return this.vc.isUnparsedEntity(string2);
        }

        public boolean isNotation(String string2) {
            return this.vc.isNotation(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DummyDataPatternBuilder
    implements DataPatternBuilder<Pattern, Locator, VoidValue, CommentListImpl, AnnotationsImpl> {
        private DummyDataPatternBuilder() {
        }

        @java.lang.Override
        public void addParam(String string2, String string3, Context context, String string4, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
        }

        @java.lang.Override
        public void annotation(VoidValue voidValue) throws BuildException {
        }

        @java.lang.Override
        public Pattern makePattern(Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }

        @java.lang.Override
        public Pattern makePattern(Pattern pattern, Locator locator, AnnotationsImpl annotationsImpl) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }
    }

    static class OpenIncludes {
        final String uri;
        final OpenIncludes parent;

        OpenIncludes(String string2, OpenIncludes openIncludes) {
            this.uri = string2;
            this.parent = openIncludes;
        }
    }
}

