/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.load;

import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.SequenceResolver;
import com.thaiopensource.resolver.load.ResolverLoadException;
import com.thaiopensource.resolver.xml.sax.SAX;
import com.thaiopensource.resolver.xml.transform.Transform;
import javax.xml.transform.URIResolver;
import org.xml.sax.EntityResolver;

public class ResolverLoader {
    public static Resolver loadResolver(String string2, ClassLoader classLoader) throws ResolverLoadException {
        Object obj;
        try {
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null && (classLoader = ClassLoader.getSystemClassLoader()) == null) {
                throw new ResolverLoadException("no class loader");
            }
            obj = classLoader.loadClass(string2).newInstance();
        }
        catch (Exception exception) {
            throw new ResolverLoadException(exception);
        }
        if (obj instanceof Resolver) {
            return (Resolver)obj;
        }
        Resolver resolver2 = null;
        Resolver resolver3 = null;
        if (obj instanceof URIResolver) {
            resolver3 = Transform.createResolver((URIResolver)obj);
        }
        if (obj instanceof EntityResolver) {
            resolver2 = SAX.createResolver((EntityResolver)obj, resolver3 == null);
        }
        if (resolver3 == null) {
            if (resolver2 == null) {
                throw new ResolverLoadException(string2 + " not an instance of javax.xml.transform.URIResolver or org.xml.sax.EntityResolver");
            }
            return resolver2;
        }
        if (resolver2 == null) {
            return resolver3;
        }
        return new SequenceResolver(resolver2, resolver3);
    }
}

