/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Service<T> {
    private final Class<T> serviceClass;
    private final Enumeration<URL> configFiles;
    private Iterator<String> classNames = null;
    private final List<T> providers = new ArrayList<T>();
    private Loader loader;
    private static final int START = 0;
    private static final int IN_NAME = 1;
    private static final int IN_COMMENT = 2;

    public static <T> Service<T> newInstance(Class<T> clazz) {
        return new Service<T>(clazz);
    }

    private Service(Class<T> clazz) {
        try {
            this.loader = new Loader2();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.loader = new Loader();
        }
        this.serviceClass = clazz;
        String string2 = "META-INF/services/" + this.serviceClass.getName();
        this.configFiles = this.loader.getResources(string2);
    }

    public Iterator<T> getProviders() {
        return new ProviderIterator();
    }

    private synchronized boolean moreProviders() {
        while (true) {
            if (this.classNames == null) {
                if (!this.configFiles.hasMoreElements()) {
                    return false;
                }
                this.classNames = Service.parseConfigFile(this.configFiles.nextElement());
                continue;
            }
            while (this.classNames.hasNext()) {
                String string2 = this.classNames.next();
                try {
                    Class<?> clazz = this.loader.loadClass(string2);
                    Object obj = clazz.newInstance();
                    if (!this.serviceClass.isInstance(obj)) continue;
                    this.providers.add(this.serviceClass.cast(obj));
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (LinkageError linkageError) {
                }
            }
            this.classNames = null;
        }
    }

    private static Iterator<String> parseConfigFile(URL uRL) {
        try {
            int n;
            Reader reader;
            InputStream inputStream = uRL.openStream();
            try {
                reader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                reader = new InputStreamReader(inputStream, "UTF8");
            }
            reader = new BufferedReader(reader);
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while ((n = reader.read()) >= 0) {
                char c = (char)n;
                switch (c) {
                    case '\n': 
                    case '\r': {
                        n2 = 0;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '#': {
                        n2 = 2;
                        break;
                    }
                    default: {
                        if (n2 == 2) break;
                        n2 = 1;
                        stringBuilder.append(c);
                    }
                }
                if (stringBuilder.length() == 0 || n2 == 1) continue;
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            if (stringBuilder.length() != 0) {
                arrayList.add(stringBuilder.toString());
            }
            return arrayList.iterator();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        Service<?> service = Service.newInstance(Class.forName(stringArray[0]));
        Iterator<?> iterator = service.getProviders();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().getClass().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Loader2
    extends Loader {
        private ClassLoader cl = Loader2.class.getClassLoader();

        Loader2() {
            ClassLoader classLoader;
            for (ClassLoader classLoader2 = classLoader = Thread.currentThread().getContextClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                if (classLoader2 != this.cl) continue;
                this.cl = classLoader;
                break;
            }
        }

        @Override
        Enumeration<URL> getResources(String string2) {
            try {
                Enumeration<URL> enumeration = this.cl.getResources(string2);
                if (enumeration.hasMoreElements()) {
                    return enumeration;
                }
                return new Singleton<URL>(this.cl.getResource(string2));
            }
            catch (IOException iOException) {
                return new Singleton<URL>(null);
            }
        }

        @Override
        Class<?> loadClass(String string2) throws ClassNotFoundException {
            return Class.forName(string2, true, this.cl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Loader {
        private Loader() {
        }

        Enumeration<URL> getResources(String string2) {
            ClassLoader classLoader = Loader.class.getClassLoader();
            URL uRL = classLoader == null ? ClassLoader.getSystemResource(string2) : classLoader.getResource(string2);
            return new Singleton<URL>(uRL);
        }

        Class<?> loadClass(String string2) throws ClassNotFoundException {
            return Class.forName(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Singleton<T>
    implements Enumeration<T> {
        private T obj;

        private Singleton(T t) {
            this.obj = t;
        }

        @Override
        public boolean hasMoreElements() {
            return this.obj != null;
        }

        @Override
        public T nextElement() {
            if (this.obj == null) {
                throw new NoSuchElementException();
            }
            T t = this.obj;
            this.obj = null;
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProviderIterator
    implements Iterator<T> {
        private int nextIndex = 0;

        private ProviderIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < Service.this.providers.size() || Service.this.moreProviders();
        }

        @Override
        public T next() {
            try {
                return Service.this.providers.get(this.nextIndex++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

