/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.rng.impl;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.pattern.AnnotationsImpl;
import com.thaiopensource.relaxng.pattern.CommentListImpl;
import com.thaiopensource.relaxng.pattern.FeasibleTransform;
import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.IdTypeMapBuilder;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternDumper;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.CombineSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.impl.FeasibleIdTypeMapSchema;
import com.thaiopensource.validate.rng.impl.IdTypeMapSchema;
import com.thaiopensource.validate.rng.impl.PatternSchema;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaReaderImpl
extends AbstractSchemaReader {
    private static final PropertyId<?>[] supportedPropertyIds = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, RngProperty.DATATYPE_LIBRARY_FACTORY, RngProperty.CHECK_ID_IDREF, RngProperty.FEASIBLE, WrapProperty.ATTRIBUTE_OWNER};

    @Override
    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        SAXResolver sAXResolver = ResolverFactory.createResolver(propertyMap);
        ErrorHandler errorHandler = propertyMap.get(ValidateProperty.ERROR_HANDLER);
        DatatypeLibraryFactory datatypeLibraryFactory = propertyMap.get(RngProperty.DATATYPE_LIBRARY_FACTORY);
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        try {
            Pattern pattern = SchemaBuilderImpl.parse(this.createParseable(sAXSource, sAXResolver, errorHandler, propertyMap), errorHandler, datatypeLibraryFactory, schemaPatternBuilder, propertyMap.contains(WrapProperty.ATTRIBUTE_OWNER));
            return SchemaReaderImpl.wrapPattern(pattern, schemaPatternBuilder, propertyMap);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new IncorrectSchemaException();
        }
    }

    @Override
    public Option getOption(String string2) {
        return RngProperty.getOption(string2);
    }

    static Schema wrapPattern(Pattern pattern, SchemaPatternBuilder schemaPatternBuilder, PropertyMap propertyMap) throws SAXException, IncorrectSchemaException {
        if (propertyMap.contains(RngProperty.FEASIBLE)) {
            pattern = FeasibleTransform.transform(schemaPatternBuilder, pattern);
        }
        propertyMap = new SimplifiedSchemaPropertyMap(AbstractSchema.filterProperties(propertyMap, supportedPropertyIds), pattern);
        AbstractSchema abstractSchema = new PatternSchema(schemaPatternBuilder, pattern, propertyMap);
        if (schemaPatternBuilder.hasIdTypes() && propertyMap.contains(RngProperty.CHECK_ID_IDREF)) {
            ErrorHandler errorHandler = propertyMap.get(ValidateProperty.ERROR_HANDLER);
            IdTypeMap idTypeMap = new IdTypeMapBuilder(errorHandler, pattern).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            AbstractSchema abstractSchema2 = propertyMap.contains(RngProperty.FEASIBLE) ? new FeasibleIdTypeMapSchema(idTypeMap, propertyMap) : new IdTypeMapSchema(idTypeMap, propertyMap);
            abstractSchema = new CombineSchema(abstractSchema, abstractSchema2, propertyMap);
        }
        return abstractSchema;
    }

    protected abstract Parseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> createParseable(SAXSource var1, SAXResolver var2, ErrorHandler var3, PropertyMap var4) throws SAXException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimplifiedSchemaPropertyMap
    implements PropertyMap {
        private final PropertyMap base;
        private final Pattern start;

        SimplifiedSchemaPropertyMap(PropertyMap propertyMap, Pattern pattern) {
            this.base = propertyMap;
            this.start = pattern;
        }

        @Override
        public <T> T get(PropertyId<T> propertyId) {
            if (propertyId == RngProperty.SIMPLIFIED_SCHEMA) {
                String string2 = PatternDumper.toString(this.start);
                return propertyId.getValueClass().cast(string2);
            }
            return this.base.get(propertyId);
        }

        @Override
        public PropertyId<?> getKey(int n) {
            return n == this.base.size() ? RngProperty.SIMPLIFIED_SCHEMA : this.base.getKey(n);
        }

        @Override
        public int size() {
            return this.base.size() + 1;
        }

        @Override
        public boolean contains(PropertyId<?> propertyId) {
            return this.base.contains(propertyId) || propertyId == RngProperty.SIMPLIFIED_SCHEMA;
        }
    }
}

