/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class DefaultInfoImpl
implements DefaultInfo,
Formatable {
    private DataValueDescriptor defaultValue;
    private String defaultText;
    private int type;
    private String[] referencedColumnNames;
    private String originalCurrentSchema;
    private static final int BITS_MASK_IS_DEFAULTVALUE_AUTOINC = 1;
    private static final int BITS_MASK_IS_GENERATED_COLUMN = 2;

    public DefaultInfoImpl() {
    }

    public DefaultInfoImpl(boolean bl, String string2, DataValueDescriptor dataValueDescriptor) {
        this.type = DefaultInfoImpl.calcType(bl);
        this.defaultText = string2;
        this.defaultValue = dataValueDescriptor;
    }

    public DefaultInfoImpl(String string2, String[] stringArray, String string3) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.type = 2;
        this.defaultText = string2;
        this.referencedColumnNames = stringArray;
        this.originalCurrentSchema = string3;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public String[] getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public String getOriginalCurrentSchema() {
        return this.originalCurrentSchema;
    }

    public String toString() {
        if (this.isDefaultValueAutoinc()) {
            return "GENERATED_BY_DEFAULT";
        }
        if (this.isGeneratedColumn()) {
            return "GENERATED ALWAYS AS ( " + this.defaultText + " )";
        }
        return this.defaultText;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.defaultText = (String)objectInput.readObject();
        this.defaultValue = (DataValueDescriptor)objectInput.readObject();
        this.type = objectInput.readInt();
        if (this.isGeneratedColumn()) {
            int n = objectInput.readInt();
            this.referencedColumnNames = new String[n];
            for (int i = 0; i < n; ++i) {
                this.referencedColumnNames[i] = (String)objectInput.readObject();
            }
            this.originalCurrentSchema = (String)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.defaultText);
        objectOutput.writeObject(this.defaultValue);
        objectOutput.writeInt(this.type);
        if (this.isGeneratedColumn()) {
            int n = this.referencedColumnNames.length;
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutput.writeObject(this.referencedColumnNames[i]);
            }
            objectOutput.writeObject(this.originalCurrentSchema);
        }
    }

    public int getTypeFormatId() {
        return 326;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DataValueDescriptor dataValueDescriptor) {
        this.defaultValue = dataValueDescriptor;
    }

    public boolean isDefaultValueAutoinc() {
        return (this.type & 1) != 0;
    }

    public boolean isGeneratedColumn() {
        return (this.type & 2) != 0;
    }

    private static int calcType(boolean bl) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        return n;
    }
}

