/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.load.ExportAbstract;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.LoadError;

class ColumnInfo {
    private ArrayList vtiColumnNames = new ArrayList(1);
    private ArrayList insertColumnNames = new ArrayList(1);
    private ArrayList columnTypes = new ArrayList(1);
    private ArrayList jdbcColumnTypes = new ArrayList(1);
    private int noOfColumns = 0;
    private ArrayList columnPositions;
    private boolean createolumnNames = true;
    private int expectedNumberOfCols;
    private Connection conn;
    private String tableName;
    private String schemaName;
    private HashMap udtClassNames = new HashMap();

    public ColumnInfo(Connection connection, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        String string7;
        StringTokenizer stringTokenizer;
        this.conn = connection;
        if (string2 == null) {
            string2 = ((EngineConnection)connection).getCurrentSchemaName();
        }
        this.schemaName = string2;
        this.tableName = string3;
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string7 = stringTokenizer.nextToken().trim();
                if (this.initializeColumnInfo(string7)) continue;
                if (this.tableExists()) {
                    throw LoadError.invalidColumnName(string7);
                }
                String string8 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
                throw LoadError.tableNotFound(string8);
            }
        } else if (!this.initializeColumnInfo(null)) {
            String string9 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
            throw LoadError.tableNotFound(string9);
        }
        if (string5 != null) {
            stringTokenizer = new StringTokenizer(string5, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string7 = stringTokenizer.nextToken().trim();
                this.vtiColumnNames.add(string6 + string7);
                int n = new Integer(string7);
                if (n <= this.expectedNumberOfCols) continue;
                this.expectedNumberOfCols = n;
            }
        }
        if (this.vtiColumnNames.size() < 1) {
            for (int i = 1; i <= this.noOfColumns; ++i) {
                this.vtiColumnNames.add(string6 + i);
            }
            this.expectedNumberOfCols = this.noOfColumns;
        }
    }

    private boolean initializeColumnInfo(String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, this.schemaName, this.tableName, string2);
        boolean bl = false;
        while (resultSet.next()) {
            String string3 = resultSet.getString(4);
            short s = resultSet.getShort(5);
            String string4 = resultSet.getString(6);
            int n = resultSet.getInt(7);
            int n2 = resultSet.getInt(9);
            int n3 = resultSet.getInt(10);
            bl = true;
            if (ColumnInfo.importExportSupportedType(s)) {
                this.insertColumnNames.add(string3);
                String string5 = string4 + this.getTypeOption(string4, n, n, n2);
                this.columnTypes.add(string5);
                this.jdbcColumnTypes.add(new Integer(s));
                ++this.noOfColumns;
                if (s != 2000) continue;
                this.udtClassNames.put("COLUMN" + this.noOfColumns, this.getUDTClassName(databaseMetaData, string4));
                continue;
            }
            resultSet.close();
            throw LoadError.nonSupportedTypeColumn(string3, string4);
        }
        resultSet.close();
        return bl;
    }

    private String getUDTClassName(DatabaseMetaData databaseMetaData, String string2) throws SQLException {
        String string3 = null;
        try {
            if (string2.charAt(0) != '\"') {
                return string2;
            }
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string2);
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            ResultSet resultSet = databaseMetaData.getUDTs(null, string4, string5, new int[]{2000});
            if (resultSet.next()) {
                string3 = resultSet.getString(4);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
        if (string3 == null) {
            string3 = "???";
        }
        return string3;
    }

    public static final boolean importExportSupportedType(int n) {
        return n != -7 && n != 1111 && n != 2009;
    }

    private String getTypeOption(String string2, int n, int n2, int n3) {
        if ((string2.equals("CHAR") || string2.equals("BLOB") || string2.equals("CLOB") || string2.equals("VARCHAR")) && n != 0) {
            return "(" + n + ")";
        }
        if (string2.equals("FLOAT") && n2 != 0) {
            return "(" + n2 + ")";
        }
        if (string2.equals("DECIMAL") || string2.equals("NUMERIC")) {
            if (n2 != 0 && n3 == 0) {
                return "(" + n2 + ")";
            }
            if (n2 != 0 && n3 != 0) {
                return "(" + n2 + "," + n3 + ")";
            }
            if (n2 == 0 && n3 != 0) {
                return "(" + n3 + ")";
            }
        }
        if ((string2.equals("DECIMAL") || string2.equals("NUMERIC")) && n3 != 0) {
            return "(" + n3 + ")";
        }
        return "";
    }

    public String getColumnTypeNames() throws Exception {
        return ExportAbstract.stringifyObject(this.columnTypes);
    }

    public String getUDTClassNames() throws Exception {
        return ExportAbstract.stringifyObject(this.udtClassNames);
    }

    public String getColumnNamesWithCasts() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = this.vtiColumnNames.size();
        for (int i = 0; i < this.noOfColumns && i < n; ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            String string2 = (String)this.columnTypes.get(i);
            String string3 = (String)this.vtiColumnNames.get(i);
            if (string2.startsWith("SMALLINT") || string2.startsWith("INTEGER") || string2.startsWith("DECIMAL") || string2.startsWith("BIGINT") || string2.startsWith("NUMERIC")) {
                stringBuffer.append(" cast(" + string3 + " AS " + string2 + ") ");
                continue;
            }
            if (string2.startsWith("DOUBLE")) {
                stringBuffer.append(" DOUBLE(" + string3 + ") ");
                continue;
            }
            if (string2.startsWith("REAL")) {
                stringBuffer.append("cast( DOUBLE(" + string3 + ") " + " AS " + "REAL" + ") ");
                continue;
            }
            stringBuffer.append(" " + string3 + " ");
        }
        if (bl) {
            return " * ";
        }
        return stringBuffer.toString();
    }

    public String getInsertColumnNames() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.noOfColumns; ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            String string2 = (String)this.insertColumnNames.get(i);
            stringBuffer.append(IdUtil.normalToDelimited(string2));
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getExpectedNumberOfColumnsInFile() {
        return this.expectedNumberOfCols;
    }

    private boolean tableExists() throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, this.schemaName, this.tableName, null);
        boolean bl = false;
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        return bl;
    }

    public String getExpectedVtiColumnTypesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.noOfColumns && i < this.vtiColumnNames.size(); ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.vtiColumnNames.get(i) + ":" + this.jdbcColumnTypes.get(i));
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static int[] getExpectedVtiColumnTypes(String string2, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 12;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            int n2 = string3.indexOf(":");
            int n3 = new Integer(string3.substring(6, n2));
            int n4 = new Integer(string3.substring(n2 + 1));
            if (n3 > n) continue;
            nArray[n3 - 1] = n4;
        }
        return nArray;
    }

    public static String[] getExpectedColumnTypeNames(String string2, int n) throws Exception {
        ArrayList arrayList = (ArrayList)ImportAbstract.destringifyObject(string2);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static HashMap getExpectedUDTClasses(String string2) throws Exception {
        HashMap hashMap = ColumnInfo.deserializeHashMap(string2);
        if (hashMap == null) {
            return null;
        }
        HashMap hashMap2 = new HashMap();
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            Class<?> clazz = Class.forName(string4);
            hashMap2.put(string3, clazz);
        }
        return hashMap2;
    }

    public static HashMap deserializeHashMap(String string2) throws Exception {
        if (string2 == null) {
            return null;
        }
        HashMap hashMap = (HashMap)ImportAbstract.destringifyObject(string2);
        return hashMap;
    }
}

