/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.LoadError;

public class Import
extends ImportAbstract {
    private static int _importCounter;
    private static Hashtable _importers;
    private String inputFileName;

    public Import(String string2, String string3, String string4, String string5, int n, String string6, boolean bl, int n2, String string7, String string8) throws SQLException {
        try {
            this.inputFileName = string2;
            this.noOfColumnsExpected = n;
            this.tableColumnTypesStr = string6;
            this.columnTypeNamesString = string7;
            this.udtClassNamesString = string8;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string4, string3, string5);
            this.lobsInExtFile = bl;
            _importers.put(new Integer(n2), this);
            this.doImport();
        }
        catch (Exception exception) {
            throw this.importError(exception);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String string2, String string3, String string4, String string5, String string6, String string7, short s, boolean bl) throws SQLException {
        Import.performImport(connection, string2, null, null, string3, string4, string5, string6, string7, s, bl);
    }

    public static void importData(Connection connection, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, short s, boolean bl) throws SQLException {
        Import.performImport(connection, string2, string4, string5, string3, string6, string7, string8, string9, s, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performImport(Connection connection, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, short s, boolean bl) throws SQLException {
        Integer n = new Integer(Import.bumpImportCounter());
        try {
            if (connection == null) {
                throw LoadError.connectionNull();
            }
            if (string5 == null) {
                throw LoadError.entityNameMissing();
            }
            ColumnInfo columnInfo = new ColumnInfo(connection, string2, string5, string3, string4, "COLUMN");
            String string10 = null;
            String string11 = null;
            try {
                string10 = columnInfo.getColumnTypeNames();
                string11 = columnInfo.getUDTClassNames();
            }
            catch (Throwable throwable) {
                throw Import.formatImportError((Import)_importers.get(n), string6, throwable);
            }
            StringBuffer stringBuffer = new StringBuffer("new ");
            stringBuffer.append("org.apache.derby.impl.load.Import");
            stringBuffer.append("(");
            stringBuffer.append(Import.quoteStringArgument(string6));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string7));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string8));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string9));
            stringBuffer.append(", ");
            stringBuffer.append(columnInfo.getExpectedNumberOfColumnsInFile());
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(columnInfo.getExpectedVtiColumnTypesAsString()));
            stringBuffer.append(", ");
            stringBuffer.append(bl);
            stringBuffer.append(", ");
            stringBuffer.append(n);
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(string10));
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(string11));
            stringBuffer.append(" )");
            String string12 = stringBuffer.toString();
            String string13 = IdUtil.mkQualifiedName(string2, string5);
            String string14 = s > 0 ? "replace" : "bulkInsert";
            String string15 = columnInfo.getColumnNamesWithCasts();
            String string16 = columnInfo.getInsertColumnNames();
            string16 = string16 != null ? "(" + string16 + ") " : "";
            String string17 = "INSERT INTO " + string13 + string16 + " --DERBY-PROPERTIES insertMode=" + string14 + "\n" + " SELECT " + string15 + " from " + string12 + " AS importvti";
            PreparedStatement preparedStatement = connection.prepareStatement(string17);
            Statement statement = connection.createStatement();
            String string18 = "LOCK TABLE " + string13 + " IN EXCLUSIVE MODE";
            statement.executeUpdate(string18);
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                throw Import.formatImportError((Import)_importers.get(n), string6, throwable);
            }
            statement.close();
            preparedStatement.close();
        }
        finally {
            _importers.remove(n);
        }
    }

    ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader);
    }

    private static synchronized int bumpImportCounter() {
        return ++_importCounter;
    }

    private static SQLException formatImportError(Import import_, String string2, Throwable throwable) {
        int n = -1;
        if (import_ != null) {
            n = import_.getCurrentLineNumber();
        }
        StandardException standardException = StandardException.newException("XIE0R.S", (Object)new Integer(n), (Object)string2, (Object)throwable.getMessage());
        standardException.initCause(throwable);
        return PublicAPI.wrapStandardException(standardException);
    }

    private static String quoteStringArgument(String string2) {
        if (string2 == null) {
            return "NULL";
        }
        return StringUtil.quoteStringLiteral(string2);
    }

    static {
        _importers = new Hashtable();
    }
}

