/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;

public class CreateViewNode
extends DDLStatementNode {
    ResultColumnList resultColumns;
    ResultSetNode queryExpression;
    String qeText;
    int checkOption;
    ProviderInfo[] providerInfos;
    ColumnInfo[] colInfos;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) throws StandardException {
        this.initAndCheck(object);
        this.resultColumns = (ResultColumnList)object2;
        this.queryExpression = (ResultSetNode)object3;
        this.checkOption = (Integer)object4;
        this.qeText = ((String)object5).trim();
        this.orderByList = (OrderByList)object6;
        this.offset = (ValueNode)object7;
        this.fetchFirst = (ValueNode)object8;
        this.hasJDBClimitClause = object9 == null ? false : (Boolean)object9;
        this.implicitCreateSchema = true;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "CREATE VIEW";
    }

    public void printSubNodes(int n) {
    }

    public int getCheckOption() {
        return this.checkOption;
    }

    public ProviderInfo[] getProviderInfo() {
        return this.providerInfos;
    }

    public ColumnInfo[] getColumnInfo() {
        return this.colInfos;
    }

    public void bindStatement() throws StandardException {
        String string2;
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.providerInfos = this.bindViewDefinition(dataDictionary, compilerContext, this.getLanguageConnectionContext(), this.getNodeFactory(), this.queryExpression, this.getContextManager());
        ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
        if (this.resultColumns != null) {
            if (this.resultColumns.size() != resultColumnList.visibleSize()) {
                throw StandardException.newException("42X56", this.getFullName());
            }
            resultColumnList.copyResultColumnNames(this.resultColumns);
        }
        if ((string2 = resultColumnList.verifyUniqueNames(this.resultColumns == null)) != null) {
            throw StandardException.newException("42Y13", string2);
        }
        if (this.queryExpression.getResultColumns().size() > 5000) {
            throw StandardException.newException("54011", (Object)String.valueOf(this.queryExpression.getResultColumns().size()), (Object)this.getRelativeName(), (Object)String.valueOf(5000));
        }
        this.colInfos = new ColumnInfo[this.queryExpression.getResultColumns().visibleSize()];
        this.genColumnInfos(this.colInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo[] bindViewDefinition(DataDictionary dataDictionary, CompilerContext compilerContext, LanguageConnectionContext languageConnectionContext, NodeFactory nodeFactory, ResultSetNode resultSetNode, ContextManager contextManager) throws StandardException {
        ProviderInfo[] providerInfoArray;
        FromList fromList = (FromList)nodeFactory.getNode(37, nodeFactory.doJoinOrderOptimization(), contextManager);
        ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList providerList2 = new ProviderList();
        try {
            compilerContext.setCurrentAuxiliaryProviderList(providerList2);
            compilerContext.pushCurrentPrivType(0);
            resultSetNode = resultSetNode.bindNonVTITables(dataDictionary, fromList);
            resultSetNode = resultSetNode.bindVTITables(fromList);
            resultSetNode.bindExpressions(fromList);
            if (resultSetNode instanceof SelectNode && resultSetNode.referencesSessionSchema()) {
                throw StandardException.newException("XCL51.S");
            }
            resultSetNode.bindResultColumns(fromList);
            resultSetNode.bindUntypedNullsToResultColumns(null);
            providerInfoArray = null;
            compilerContext.popCurrentPrivType();
            compilerContext.setCurrentAuxiliaryProviderList(providerList);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            compilerContext.popCurrentPrivType();
            compilerContext.setCurrentAuxiliaryProviderList(providerList);
            throw throwable;
        }
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList2);
        dependencyManager.clearColumnInfoInProviders(providerList2);
        return providerInfoArray;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.queryExpression.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getCreateViewConstantAction(this.getSchemaDescriptor().getSchemaName(), this.getRelativeName(), 2, this.qeText, this.checkOption, this.colInfos, this.providerInfos, null);
    }

    private void genColumnInfos(ColumnInfo[] columnInfoArray) {
        ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
        for (int i = 0; i < columnInfoArray.length; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            columnInfoArray[i] = new ColumnInfo(resultColumn.getName(), resultColumn.getType(), null, null, null, null, null, 0, 0L, 0L, 0L);
        }
    }

    ResultSetNode getParsedQueryExpression() {
        return this.queryExpression;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.queryExpression != null) {
            this.queryExpression = (ResultSetNode)this.queryExpression.accept(visitor);
        }
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    public boolean hasJDBClimitClause() {
        return this.hasJDBClimitClause;
    }
}

