/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public abstract class StatementNode
extends QueryTreeNode {
    static final TableDescriptor[] EMPTY_TD_LIST = new TableDescriptor[0];
    static final int NEED_DDL_ACTIVATION = 5;
    static final int NEED_CURSOR_ACTIVATION = 4;
    static final int NEED_PARAM_ACTIVATION = 2;
    static final int NEED_ROW_ACTIVATION = 1;
    static final int NEED_NOTHING_ACTIVATION = 0;

    public boolean isAtomic() throws StandardException {
        return true;
    }

    public boolean needsSavepoint() {
        return true;
    }

    public String getSPSName() {
        return null;
    }

    public String executeStatementName() {
        return null;
    }

    public String executeSchemaName() {
        return null;
    }

    public ResultDescription makeResultDescription() {
        return null;
    }

    public String toString() {
        return "";
    }

    public abstract String statementToString();

    public void bindStatement() throws StandardException {
    }

    public void optimizeStatement() throws StandardException {
    }

    abstract int activationKind();

    protected TableDescriptor lockTableForCompilation(TableDescriptor tableDescriptor) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (dataDictionary.getCacheMode() == 1) {
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            ConglomerateController conglomerateController = transactionController.openConglomerate(tableDescriptor.getHeapConglomerateId(), false, 68, 6, 5);
            conglomerateController.close();
            String string2 = tableDescriptor.getName();
            tableDescriptor = this.getTableDescriptor(tableDescriptor.getName(), this.getSchemaDescriptor(tableDescriptor.getSchemaName()));
            if (tableDescriptor == null) {
                throw StandardException.newException("42X05", string2);
            }
        }
        return tableDescriptor;
    }

    public GeneratedClass generate(ByteArray byteArray) throws StandardException {
        String string2;
        int n = this.activationKind();
        switch (n) {
            case 4: {
                string2 = "org.apache.derby.impl.sql.execute.CursorActivation";
                break;
            }
            case 5: {
                return this.getClassFactory().loadGeneratedClass("org.apache.derby.impl.sql.execute.ConstantActionActivation", null);
            }
            case 0: 
            case 1: 
            case 2: {
                string2 = "org.apache.derby.impl.sql.execute.BaseActivation";
                break;
            }
            default: {
                throw StandardException.newException("42Z53", String.valueOf(n));
            }
        }
        ActivationClassBuilder activationClassBuilder = new ActivationClassBuilder(string2, this.getCompilerContext());
        MethodBuilder methodBuilder = activationClassBuilder.getClassBuilder().newMethodBuilder(4, "org.apache.derby.iapi.sql.ResultSet", "createResultSet");
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        this.generate(activationClassBuilder, methodBuilder);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        activationClassBuilder.finishExecuteMethod();
        activationClassBuilder.finishConstructor();
        try {
            GeneratedClass generatedClass = activationClassBuilder.getGeneratedClass(byteArray);
            return generatedClass;
        }
        catch (StandardException standardException) {
            String string3 = standardException.getMessageId();
            if ("XBCM4.S".equals(string3) || "XBCM1.S".equals(string3)) {
                throw StandardException.newException("42ZA0", standardException);
            }
            throw standardException;
        }
    }

    public TableDescriptor[] updateIndexStatisticsFor() throws StandardException {
        return EMPTY_TD_LIST;
    }
}

