/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherFactoryBuilder;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public final class RawStore
implements RawStoreFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction {
    private static final String BACKUP_HISTORY = "BACKUP.HISTORY";
    protected TransactionFactory xactFactory;
    protected DataFactory dataFactory;
    protected LogFactory logFactory;
    private SlaveFactory slaveFactory;
    private StorageFactory storageFactory;
    private SecureRandom random;
    private boolean isEncryptedDatabase;
    private CipherProvider encryptionEngine;
    private CipherProvider decryptionEngine;
    private CipherProvider newEncryptionEngine;
    private CipherProvider newDecryptionEngine;
    private CipherFactory currentCipherFactory;
    private CipherFactory newCipherFactory = null;
    private int counter_encrypt;
    private int counter_decrypt;
    private int encryptionBlockSize = 8;
    protected DaemonService rawStoreDaemon;
    private int actionCode;
    private static final int FILE_WRITER_ACTION = 1;
    private StorageFile actionStorageFile;
    private StorageFile actionToStorageFile;
    private boolean actionAppend;
    private static final int REGULAR_FILE_EXISTS_ACTION = 2;
    private File actionRegularFile;
    private static final int STORAGE_FILE_EXISTS_ACTION = 3;
    private static final int REGULAR_FILE_DELETE_ACTION = 4;
    private static final int REGULAR_FILE_MKDIRS_ACTION = 5;
    private static final int REGULAR_FILE_IS_DIRECTORY_ACTION = 6;
    private static final int REGULAR_FILE_REMOVE_DIRECTORY_ACTION = 7;
    private static final int REGULAR_FILE_RENAME_TO_ACTION = 8;
    private File actionRegularFile2;
    private static final int COPY_STORAGE_DIRECTORY_TO_REGULAR_ACTION = 9;
    private byte[] actionBuffer;
    private String[] actionFilter;
    private boolean actionCopySubDirs;
    private static final int COPY_REGULAR_DIRECTORY_TO_STORAGE_ACTION = 10;
    private static final int COPY_REGULAR_FILE_TO_STORAGE_ACTION = 11;
    private static final int REGULAR_FILE_LIST_DIRECTORY_ACTION = 12;
    private static final int STORAGE_FILE_LIST_DIRECTORY_ACTION = 13;
    private static final int COPY_STORAGE_FILE_TO_REGULAR_ACTION = 14;
    private static final int REGULAR_FILE_GET_CANONICALPATH_ACTION = 15;
    private static final int STORAGE_FILE_GET_CANONICALPATH_ACTION = 16;
    private static final int COPY_STORAGE_FILE_TO_STORAGE_ACTION = 17;
    private static final int STORAGE_FILE_DELETE_ACTION = 18;
    private static final int README_FILE_OUTPUTSTREAM_WRITER_ACTION = 19;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = null;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = null;

    public boolean canSupport(Properties properties) {
        return true;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        String string2;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = properties.getProperty("replication.slave.mode");
        if (string3 != null && string3.equals("slavemode")) {
            bl3 = true;
        }
        DaemonFactory daemonFactory = (DaemonFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        this.rawStoreDaemon = daemonFactory.createNewDaemon("rawStoreDaemon");
        this.xactFactory = (TransactionFactory)Monitor.bootServiceModule(bl, this, this.getTransactionFactoryModule(), properties);
        this.dataFactory = (DataFactory)Monitor.bootServiceModule(bl, this, this.getDataFactoryModule(), properties);
        this.storageFactory = this.dataFactory.getStorageFactory();
        String string4 = null;
        if (properties != null) {
            string4 = properties.getProperty("createFrom");
            if (string4 == null) {
                string4 = properties.getProperty("restoreFrom");
            }
            if (string4 == null) {
                string4 = properties.getProperty("rollForwardRecoveryFrom");
            }
        }
        if (bl) {
            bl2 = this.setupEncryptionEngines(bl, properties);
        }
        this.dataFactory.setRawStoreFactory(this, bl, properties);
        this.xactFactory.setRawStoreFactory(this);
        if (properties instanceof UpdateServiceProperties && this.storageFactory instanceof WritableStorageFactory) {
            ((UpdateServiceProperties)properties).setStorageFactory((WritableStorageFactory)this.storageFactory);
        }
        this.logFactory = (LogFactory)Monitor.findServiceModule(this, this.getLogFactoryModule());
        if (string4 != null) {
            this.restoreRemainingFromBackup(string4);
        }
        if ((string2 = properties.getProperty("logDevice")) != null) {
            if (!(this.isReadOnly() || !bl && string2.equals(this.logFactory.getCanonicalLogPath()) && string4 == null)) {
                properties.put("logDevice", this.logFactory.getCanonicalLogPath());
                properties.put("derby.storage.logDeviceWhenBackedUp", this.logFactory.getCanonicalLogPath());
            }
        } else if (string4 != null && this.logFactory.getCanonicalLogPath() != null) {
            properties.put("logDevice", this.logFactory.getCanonicalLogPath());
        } else {
            properties.remove("derby.storage.logDeviceWhenBackedUp");
        }
        if (string4 != null) {
            ((UpdateServiceProperties)properties).saveServiceProperties();
        }
        if (!bl) {
            if (properties.getProperty("derby.storage.databaseEncryptionStatus") != null) {
                this.handleIncompleteDbCryptoOperation(properties);
            }
            bl2 = this.setupEncryptionEngines(bl, properties);
        }
        if (this.isEncryptedDatabase) {
            this.logFactory.setDatabaseEncrypted(true, false);
            this.dataFactory.setDatabaseEncrypted(true);
        }
        this.logFactory.setRawStoreFactory(this);
        if (bl3) {
            this.slaveFactory = (SlaveFactory)Monitor.bootServiceModule(bl, this, this.getSlaveFactoryModule(), properties);
            this.slaveFactory.startSlave(this, this.logFactory);
        }
        this.logFactory.recover(this.dataFactory, this.xactFactory);
        if (bl2) {
            this.applyBulkCryptoOperation(properties, this.newCipherFactory);
        }
    }

    public void stop() {
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
        if (this.logFactory == null) {
            return;
        }
        try {
            if (this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false) && this.dataFactory != null) {
                this.dataFactory.removeStubsOK();
            }
        }
        catch (StandardException standardException) {
            this.markCorrupt(standardException);
        }
    }

    public boolean isReadOnly() {
        return this.dataFactory.isReadOnly();
    }

    public LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    public TransactionFactory getXactFactory() {
        return this.xactFactory;
    }

    public Object getXAResourceManager() throws StandardException {
        return this.xactFactory.getXAResourceManager();
    }

    public Transaction startGlobalTransaction(ContextManager contextManager, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        return this.xactFactory.startGlobalTransaction(this, contextManager, n, byArray, byArray2);
    }

    public Transaction startTransaction(ContextManager contextManager, String string2) throws StandardException {
        return this.xactFactory.startTransaction(this, contextManager, string2);
    }

    public Transaction startNestedReadOnlyUserTransaction(CompatibilitySpace compatibilitySpace, ContextManager contextManager, String string2) throws StandardException {
        return this.xactFactory.startNestedReadOnlyUserTransaction(this, compatibilitySpace, contextManager, string2);
    }

    public Transaction startNestedUpdateUserTransaction(ContextManager contextManager, String string2, boolean bl) throws StandardException {
        return this.xactFactory.startNestedUpdateUserTransaction(this, contextManager, string2, bl);
    }

    public Transaction findUserTransaction(ContextManager contextManager, String string2) throws StandardException {
        return this.xactFactory.findUserTransaction(this, contextManager, string2);
    }

    public Transaction startInternalTransaction(ContextManager contextManager) throws StandardException {
        return this.xactFactory.startInternalTransaction(this, contextManager);
    }

    public void checkpoint() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
    }

    public void startReplicationMaster(String string2, String string3, int n, String string4) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00");
        }
        RawTransaction rawTransaction = this.xactFactory.findUserTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        if (rawTransaction.isBlockingBackup()) {
            throw StandardException.newException("XRE23");
        }
        Properties properties = new Properties();
        properties.setProperty("derby.__rt.replication.master.mode", string4);
        MasterFactory masterFactory = (MasterFactory)Monitor.bootServiceModule(true, this, this.getMasterFactoryModule(), properties);
        masterFactory.startMaster(this, this.dataFactory, this.logFactory, string3, n, string2);
    }

    public void stopReplicationMaster() throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00");
        }
        try {
            masterFactory = (MasterFactory)Monitor.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException standardException) {
            throw StandardException.newException("XRE07");
        }
        masterFactory.stopMaster();
    }

    public void failover(String string2) throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00");
        }
        try {
            masterFactory = (MasterFactory)Monitor.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException standardException) {
            throw StandardException.newException("XRE07");
        }
        masterFactory.startFailover();
    }

    public void freeze() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.dataFactory.freezePersistentStore();
        this.logFactory.freezePersistentStore();
    }

    public void unfreeze() throws StandardException {
        this.logFactory.unfreezePersistentStore();
        this.dataFactory.unfreezePersistentStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String string2, boolean bl) throws StandardException {
        Object object;
        if (string2 == null || string2.equals("")) {
            throw StandardException.newException("XSRS6.S", (Object)null);
        }
        String string3 = null;
        try {
            object = new URL(string2);
            string3 = ((URL)object).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string3 != null) {
            string2 = string3;
        }
        object = this.xactFactory.findUserTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        try {
            if (((RawTransaction)object).isBlockingBackup()) {
                throw StandardException.newException("XSRSB.S");
            }
            if (!this.xactFactory.blockBackupBlockingOperations(bl)) {
                throw StandardException.newException("XSRSA.S");
            }
            this.backup((Transaction)object, new File(string2));
        }
        finally {
            this.xactFactory.unblockBackupBlockingOperations();
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void backup(Transaction transaction, File file) throws StandardException {
        Object object;
        StorageFile storageFile;
        Object object2;
        Object object3;
        Object object4;
        if (!this.privExists(file)) {
            if (!this.privMkdirs(file)) {
                throw StandardException.newException("XSRS6.S", file);
            }
        } else {
            if (!this.privIsDirectory(file)) {
                throw StandardException.newException("XSRS1.S", file);
            }
            if (this.privExists(new File(file, "service.properties"))) {
                throw StandardException.newException("XSRSC.S", file);
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        File file2 = null;
        File file3 = null;
        OutputStreamWriter outputStreamWriter = null;
        StorageFile storageFile2 = null;
        File file4 = null;
        LogInstant logInstant = this.logFactory.getFirstUnflushedInstant();
        StorageFile storageFile3 = this.storageFactory.newStorageFile(null);
        String string2 = this.storageFactory.getCanonicalName();
        int n = string2.lastIndexOf(this.storageFactory.getSeparator());
        String string3 = string2.substring(n + 1);
        outputStreamWriter = this.privFileWriter(this.storageFactory.newStorageFile(BACKUP_HISTORY), true);
        file3 = new File(file, string3);
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D004", string2, this.getFilePath(file3)));
        if (this.privExists(file3)) {
            file2 = new File(file, string3 + ".OLD");
            if (this.privExists(file2)) {
                if (this.privIsDirectory(file2)) {
                    this.privRemoveDirectory(file2);
                } else {
                    this.privDelete(file2);
                }
            }
            if (!this.privRenameTo(file3, file2)) {
                bl3 = true;
                throw StandardException.newException("XSRS4.S", (Object)file3, (Object)file2);
            }
            this.logHistory(outputStreamWriter, MessageService.getTextMessage("D005", this.getFilePath(file3), this.getFilePath(file2)));
            bl2 = true;
        }
        if (!this.privMkdirs(file3)) {
            throw StandardException.newException("XSRS6.S", file3);
        }
        storageFile2 = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        if (!this.privCopyFile(storageFile2, file4 = new File(file3, BACKUP_HISTORY))) {
            throw StandardException.newException("XSRS5.S", (Object)storageFile2, (Object)file4);
        }
        StorageFile storageFile4 = this.storageFactory.newStorageFile("jar");
        if (this.privExists(storageFile4)) {
            int n2;
            object4 = this.privList(storageFile4);
            object3 = new File(file3, "jar");
            if (!this.privMkdirs((File)object3)) {
                throw StandardException.newException("XSRS6.S", object3);
            }
            object2 = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
            boolean bl4 = object2.getDataDictionary().checkVersion(210, null);
            if (bl4) {
                for (n2 = 0; n2 < ((String[])object4).length; ++n2) {
                    storageFile = this.storageFactory.newStorageFile(storageFile4, (String)object4[n2]);
                    File file5 = new File((File)object3, (String)object4[n2]);
                    if (this.privIsDirectory(new File(storageFile.getPath())) || this.privCopyFile(storageFile, file5)) continue;
                    throw StandardException.newException("XSRS5.S", (Object)storageFile, (Object)file5);
                }
            } else {
                for (n2 = 0; n2 < ((String[])object4).length; ++n2) {
                    File file6;
                    storageFile = this.storageFactory.newStorageFile(storageFile4, (String)object4[n2]);
                    if (this.privCopyDirectory(storageFile, file6 = new File((File)object3, (String)object4[n2]), null, null, false)) continue;
                    throw StandardException.newException("XSRS5.S", (Object)storageFile, (Object)file6);
                }
            }
        }
        object4 = this.logFactory.getLogDirectory();
        try {
            object3 = Monitor.getMonitor().getServiceName(this);
            object2 = Monitor.getMonitor().getServiceType(this);
            object = object2.getCanonicalServiceName((String)object3);
            Properties properties = object2.getServiceProperties((String)object, null);
            storageFile = this.storageFactory.newStorageFile("log");
            if (!object4.equals(storageFile)) {
                properties.remove("logDevice");
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D007"));
            }
            object2.saveServiceProperties(file3.getPath(), properties);
        }
        catch (StandardException standardException) {
            this.logHistory(outputStreamWriter, MessageService.getTextMessage("D008") + standardException);
            Object var25_29 = null;
            try {
                if (bl) {
                    this.logFactory.abortLogBackup();
                    if (!bl3) {
                        this.privRemoveDirectory(file3);
                    }
                    if (bl2) {
                        this.privRenameTo(file2, file3);
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
                } else {
                    if (bl2 && this.privExists(file2)) {
                        this.privRemoveDirectory(file2);
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", this.getFilePath(file2)));
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                    if (!this.privCopyFile(storageFile2, file4)) {
                        throw StandardException.newException("XSRS5.S", (Object)storageFile2, (Object)file4);
                    }
                }
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw StandardException.newException("XSRS7.S", iOException);
            }
            return;
        }
        object3 = this.storageFactory.newStorageFile("verifyKey.dat");
        if (this.privExists((StorageFile)object3) && !this.privCopyFile((StorageFile)object3, (File)(object2 = new File(file3, "verifyKey.dat")))) {
            throw StandardException.newException("XSRS5.S", object3, object2);
        }
        object2 = new File(file3, "log");
        if (this.privExists((File)object2)) {
            this.privRemoveDirectory((File)object2);
        }
        if (!this.privMkdirs((File)object2)) {
            throw StandardException.newException("XSRS6.S", object2);
        }
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.startLogBackup((File)object2);
        object = new File(file3, "seg0");
        if (!this.privMkdirs((File)object)) {
            throw StandardException.newException("XSRS6.S", object);
        }
        this.dataFactory.backupDataFiles(transaction, (File)object);
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D006", this.getFilePath((File)object)));
        this.logFactory.endLogBackup((File)object2);
        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D009", this.getFilePath((StorageFile)object4), this.getFilePath((File)object2)));
        bl = false;
        Object var25_30 = null;
        try {
            if (bl) {
                this.logFactory.abortLogBackup();
                if (!bl3) {
                    this.privRemoveDirectory(file3);
                }
                if (bl2) {
                    this.privRenameTo(file2, file3);
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
            } else {
                if (bl2 && this.privExists(file2)) {
                    this.privRemoveDirectory(file2);
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", this.getFilePath(file2)));
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                if (!this.privCopyFile(storageFile2, file4)) {
                    throw StandardException.newException("XSRS5.S", (Object)storageFile2, (Object)file4);
                }
            }
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw StandardException.newException("XSRS7.S", iOException);
        }
        {
            catch (IOException iOException) {
                throw StandardException.newException("XSRS7.S", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var25_31 = null;
            try {
                if (bl) {
                    this.logFactory.abortLogBackup();
                    if (!bl3) {
                        this.privRemoveDirectory(file3);
                    }
                    if (bl2) {
                        this.privRenameTo(file2, file3);
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D010"));
                } else {
                    if (bl2 && this.privExists(file2)) {
                        this.privRemoveDirectory(file2);
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage("D011", this.getFilePath(file2)));
                    }
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage("D012", logInstant));
                    if (!this.privCopyFile(storageFile2, file4)) {
                        throw StandardException.newException("XSRS5.S", storageFile2, file4);
                    }
                }
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                throw StandardException.newException("XSRS7.S", iOException);
            }
            throw throwable;
        }
    }

    public void backupAndEnableLogArchiveMode(String string2, boolean bl, boolean bl2) throws StandardException {
        boolean bl3 = false;
        try {
            if (!this.logFactory.logArchived()) {
                this.logFactory.enableLogArchiveMode();
                bl3 = true;
            }
            this.backup(string2, bl2);
            if (bl) {
                this.logFactory.deleteOnlineArchivedLogFiles();
            }
        }
        catch (Throwable throwable) {
            if (bl3) {
                this.logFactory.disableLogArchiveMode();
            }
            throw StandardException.plainWrapException(throwable);
        }
    }

    public void disableLogArchiveMode(boolean bl) throws StandardException {
        this.logFactory.disableLogArchiveMode();
        if (bl) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    private void restoreRemainingFromBackup(String string2) throws StandardException {
        File file = new File(string2, "jar");
        StorageFile storageFile = this.storageFactory.newStorageFile("jar");
        if (!this.privExists(storageFile) && this.privExists(file) && !this.privCopyDirectory(file, storageFile)) {
            throw StandardException.newException("XBM0Z.D", (Object)file, (Object)storageFile);
        }
        StorageFile storageFile2 = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        File file2 = new File(string2, BACKUP_HISTORY);
        if (this.privExists(file2) && !this.privExists(storageFile2) && !this.privCopyFile(file2, storageFile2)) {
            throw StandardException.newException("XSRS5.S", (Object)file2, (Object)storageFile2);
        }
    }

    public void idle() throws StandardException {
        this.dataFactory.idle();
    }

    public TransactionInfo[] getTransactionInfo() {
        return this.xactFactory.getTransactionInfo();
    }

    public ScanHandle openFlushedScan(DatabaseInstant databaseInstant, int n) throws StandardException {
        return this.logFactory.openFlushedScan(databaseInstant, n);
    }

    public DaemonService getDaemon() {
        return this.rawStoreDaemon;
    }

    public void createFinished() throws StandardException {
        this.xactFactory.createFinished();
        this.dataFactory.createFinished();
    }

    public void getRawStoreProperties(PersistentSet persistentSet) throws StandardException {
        this.logFactory.getLogFactoryProperties(persistentSet);
    }

    public void freezePersistentStore() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.freezePersistentStore();
    }

    public void unfreezePersistentStore() throws StandardException {
        this.logFactory.unfreezePersistentStore();
    }

    private boolean setupEncryptionEngines(boolean bl, Properties properties) throws StandardException {
        Object object;
        boolean bl2 = RawStore.isTrue(properties, "decryptDatabase");
        boolean bl3 = RawStore.isTrue(properties, "dataEncryption");
        boolean bl4 = false;
        if (!bl) {
            String string2 = Monitor.getMonitor().getServiceName(this);
            object = Monitor.getMonitor().getServiceType(this);
            String string3 = object.getCanonicalServiceName(string2);
            Properties properties2 = object.getServiceProperties(string3, null);
            this.isEncryptedDatabase = RawStore.isTrue(properties2, "dataEncryption");
            if (this.isEncryptedDatabase) {
                bl3 = bl4 = RawStore.isSet(properties, "newBootPassword") || RawStore.isSet(properties, "newEncryptionKey");
            } else if (bl3 && bl2) {
                throw StandardException.newException("XJ048.C", "decryptDatabase, dataEncryption");
            }
            if ((bl3 || bl2) && this.isReadOnly()) {
                throw StandardException.newException("XBCXQ.S");
            }
        }
        if (this.isEncryptedDatabase || bl3) {
            boolean bl5 = bl || bl3 && !bl4;
            object = (CipherFactoryBuilder)Monitor.startSystemModule("org.apache.derby.iapi.services.crypto.CipherFactoryBuilder");
            this.currentCipherFactory = object.createCipherFactory(bl5, properties, false);
            this.currentCipherFactory.verifyKey(bl5, this.storageFactory, properties);
            this.encryptionEngine = this.currentCipherFactory.createNewCipher(1);
            if (bl5) {
                this.encryptionBlockSize = this.encryptionEngine.getEncryptionBlockSize();
                if (bl) {
                    properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                }
            } else {
                this.encryptionBlockSize = RawStore.isSet(properties, "derby.encryptionBlockSize") ? Integer.parseInt(properties.getProperty("derby.encryptionBlockSize")) : this.encryptionEngine.getEncryptionBlockSize();
            }
            this.decryptionEngine = this.currentCipherFactory.createNewCipher(2);
            this.random = this.currentCipherFactory.getSecureRandom();
            if (bl3) {
                if (bl4) {
                    this.newCipherFactory = object.createCipherFactory(bl5, properties, true);
                    this.newDecryptionEngine = this.newCipherFactory.createNewCipher(2);
                    this.newEncryptionEngine = this.newCipherFactory.createNewCipher(1);
                } else {
                    this.newDecryptionEngine = this.decryptionEngine;
                    this.newEncryptionEngine = this.encryptionEngine;
                }
            }
            if (bl) {
                this.currentCipherFactory.saveProperties(properties);
                this.isEncryptedDatabase = true;
            }
        }
        return !bl && (bl3 || this.isEncryptedDatabase && bl2);
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws StandardException {
        if (this.encryptionEngine == null && this.newEncryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_encrypt;
        if (bl) {
            return this.newEncryptionEngine.encrypt(byArray, n, n2, byArray2, n3);
        }
        return this.encryptionEngine.encrypt(byArray, n, n2, byArray2, n3);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        if (!this.isEncryptedDatabase || this.decryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_decrypt;
        return this.decryptionEngine.decrypt(byArray, n, n2, byArray2, n3);
    }

    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    public int random() {
        return this.isEncryptedDatabase ? this.random.nextInt() : 0;
    }

    public Serializable changeBootPassword(Properties properties, Serializable serializable) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XBCX9.S");
        }
        if (!this.isEncryptedDatabase) {
            throw StandardException.newException("XBCX8.S");
        }
        if (serializable == null) {
            throw StandardException.newException("XBCX5.S");
        }
        if (!(serializable instanceof String)) {
            throw StandardException.newException("XBCX6.S");
        }
        String string2 = (String)((Object)serializable);
        return this.currentCipherFactory.changeBootPassword((String)((Object)serializable), properties, this.encryptionEngine);
    }

    private void crashOnDebugFlag(String string2, boolean bl) throws StandardException {
    }

    private void applyBulkCryptoOperation(Properties properties, CipherFactory cipherFactory) throws StandardException {
        boolean bl = this.isEncryptedDatabase && RawStore.isTrue(properties, "decryptDatabase");
        boolean bl2 = this.isEncryptedDatabase && (RawStore.isSet(properties, "newBootPassword") || RawStore.isSet(properties, "newEncryptionKey"));
        this.cryptoOperationAllowed(bl2, bl);
        boolean bl3 = RawStore.isSet(properties, "encryptionKey");
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        RawTransaction rawTransaction = this.xactFactory.startTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        try {
            try {
                Object object;
                if (bl) {
                    this.dataFactory.decryptAllContainers(rawTransaction);
                } else {
                    this.dataFactory.encryptAllContainers(rawTransaction);
                }
                if (!this.logFactory.isCheckpointInLastLogFile()) {
                    this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
                }
                if (bl) {
                    this.isEncryptedDatabase = false;
                    this.logFactory.setDatabaseEncrypted(false, true);
                    this.dataFactory.setDatabaseEncrypted(false);
                } else {
                    this.logFactory.setDatabaseEncrypted(true, true);
                    if (bl2) {
                        this.decryptionEngine = this.newDecryptionEngine;
                        this.encryptionEngine = this.newEncryptionEngine;
                        this.currentCipherFactory = cipherFactory;
                    } else {
                        this.isEncryptedDatabase = true;
                        this.dataFactory.setDatabaseEncrypted(true);
                    }
                }
                this.logFactory.startNewLogFile();
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(1));
                if (bl2) {
                    if (bl3) {
                        StorageFile storageFile;
                        object = this.storageFactory.newStorageFile("verifyKey.dat");
                        if (!this.privCopyFile((StorageFile)object, storageFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
                            throw StandardException.newException("XSRS5.S", object, (Object)storageFile);
                        }
                        this.currentCipherFactory.verifyKey(bl2, this.storageFactory, properties);
                    } else {
                        object = properties.getProperty("encryptedBootPassword");
                        if (object != null) {
                            properties.put("OldEncryptedBootPassword", object);
                        }
                    }
                } else if (bl) {
                    properties.put("dataEncryption", "false");
                } else {
                    properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                }
                this.currentCipherFactory.saveProperties(properties);
                rawTransaction.commit();
                this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(3));
                this.dataFactory.removeOldVersionOfContainers();
                if (bl) {
                    this.removeCryptoProperties(properties);
                } else if (bl2) {
                    if (bl3) {
                        object = this.storageFactory.newStorageFile("verifyOldKey.dat");
                        if (!this.privDelete((StorageFile)object)) {
                            throw StandardException.newException("XBM0R.D", object);
                        }
                    } else {
                        properties.remove("OldEncryptedBootPassword");
                    }
                }
                properties.remove("derby.storage.databaseEncryptionStatus");
                rawTransaction.close();
            }
            catch (StandardException standardException) {
                throw StandardException.newException("XBCXU.S", standardException, (Object)standardException.getMessage());
            }
            Object var10_10 = null;
            this.newDecryptionEngine = null;
            this.newEncryptionEngine = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.newDecryptionEngine = null;
            this.newEncryptionEngine = null;
            throw throwable;
        }
    }

    public void handleIncompleteDbCryptoOperation(Properties properties) throws StandardException {
        StorageFile storageFile;
        boolean bl;
        int n = 0;
        String string2 = properties.getProperty("derby.storage.databaseEncryptionStatus");
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        boolean bl2 = false;
        boolean bl3 = bl = RawStore.isSet(properties, "dataEncryption") && !RawStore.isTrue(properties, "dataEncryption");
        if (n == 1) {
            if (this.logFactory.isCheckpointInLastLogFile()) {
                n = 3;
            } else {
                n = 2;
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(n));
            }
        }
        if (n == 2) {
            this.logFactory.deleteLogFileAfterCheckpointLogFile();
            storageFile = this.storageFactory.newStorageFile("verifyKey.dat");
            if (this.privExists(storageFile)) {
                StorageFile storageFile2 = this.storageFactory.newStorageFile("verifyOldKey.dat");
                if (this.privExists(storageFile2)) {
                    if (!this.privCopyFile(storageFile2, storageFile)) {
                        throw StandardException.newException("XSRS5.S", (Object)storageFile2, (Object)storageFile);
                    }
                    bl2 = true;
                } else if (!bl && !this.privDelete(storageFile)) {
                    throw StandardException.newException("XBM0R.D", storageFile);
                }
            } else {
                String string3 = properties.getProperty("OldEncryptedBootPassword");
                if (string3 != null) {
                    properties.put("encryptedBootPassword", string3);
                    bl2 = true;
                }
            }
            if (!bl && !bl2) {
                this.removeCryptoProperties(properties);
            }
        }
        if (n == 3) {
            this.dataFactory.removeOldVersionOfContainers();
        }
        if (this.privExists(storageFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
            if (!this.privDelete(storageFile)) {
                throw StandardException.newException("XBM0R.D", storageFile);
            }
        } else {
            properties.remove("OldEncryptedBootPassword");
        }
        if (bl) {
            if (n == 2) {
                properties.setProperty("dataEncryption", "true");
            } else {
                this.removeCryptoProperties(properties);
            }
        }
        properties.remove("derby.storage.databaseEncryptionStatus");
    }

    private void cryptoOperationAllowed(boolean bl, boolean bl2) throws StandardException {
        String string2 = bl2 ? "decryptDatabase attribute" : (bl ? "newBootPassword/newEncryptionKey attribute" : "dataEncryption attribute on an existing database");
        int n = bl2 ? 10 : 2;
        this.logFactory.checkVersion(10, n, string2);
        if (this.xactFactory.hasPreparedXact()) {
            throw StandardException.newException("XBCXO.S");
        }
        if (this.logFactory.logArchived()) {
            throw StandardException.newException("XBCXS.S");
        }
    }

    public StandardException markCorrupt(StandardException standardException) {
        this.logFactory.markCorrupt(standardException);
        this.dataFactory.markCorrupt(standardException);
        this.xactFactory.markCorrupt(standardException);
        return standardException;
    }

    public String getTransactionFactoryModule() {
        return "org.apache.derby.iapi.store.raw.xact.TransactionFactory";
    }

    public String getSlaveFactoryModule() {
        return "org.apache.derby.iapi.store.replication.slave.SlaveFactory";
    }

    public String getMasterFactoryModule() {
        return "org.apache.derby.iapi.store.replication.master.MasterFactory";
    }

    public String getDataFactoryModule() {
        return "org.apache.derby.iapi.store.raw.data.DataFactory";
    }

    public String getLogFactoryModule() {
        return "org.apache.derby.iapi.store.raw.log.LogFactory";
    }

    private void logHistory(OutputStreamWriter outputStreamWriter, String string2) throws IOException {
        Date date = new Date();
        outputStreamWriter.write(date.toString() + ":" + string2 + "\n");
        outputStreamWriter.flush();
    }

    private String getFilePath(StorageFile storageFile) {
        String string2 = this.privGetCanonicalPath(storageFile);
        if (string2 != null) {
            return string2;
        }
        return storageFile.getPath();
    }

    private String getFilePath(File file) {
        String string2 = this.privGetCanonicalPath(file);
        if (string2 != null) {
            return string2;
        }
        return file.getPath();
    }

    protected boolean privCopyDirectory(StorageFile storageFile, File file) throws StandardException {
        return this.privCopyDirectory(storageFile, file, null, null, true);
    }

    protected boolean privCopyDirectory(File file, StorageFile storageFile) {
        return this.privCopyDirectory(file, storageFile, null, null);
    }

    public long getMaxContainerId() throws StandardException {
        return this.dataFactory.getMaxContainerId();
    }

    public boolean checkVersion(int n, int n2, String string2) throws StandardException {
        return this.logFactory.checkVersion(n, n2, string2);
    }

    private void removeCryptoProperties(Properties properties) {
        properties.remove("dataEncryption");
        properties.remove("log_encrypt_algorithm_version");
        properties.remove("data_encrypt_algorithm_version");
        properties.remove("derby.encryptionBlockSize");
        properties.remove("encryptionKeyLength");
        properties.remove("encryptionProvider");
        properties.remove("encryptionAlgorithm");
        properties.remove("encryptedBootPassword");
    }

    private synchronized OutputStreamWriter privFileWriter(StorageFile storageFile, boolean bl) throws IOException {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        this.actionAppend = bl;
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)AccessController.doPrivileged(this);
            Object var5_5 = null;
            this.actionStorageFile = null;
            return outputStreamWriter;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                throw (IOException)privilegedActionException.getException();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(File file) {
        this.actionCode = 2;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var5_6 = null;
            this.actionStorageFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionStorageFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    private synchronized OutputStreamWriter privGetOutputStreamWriter(StorageFile storageFile) throws IOException {
        this.actionCode = 19;
        this.actionStorageFile = storageFile;
        try {
            return (OutputStreamWriter)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(File file) {
        this.actionCode = 4;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile storageFile) {
        this.actionCode = 18;
        this.actionStorageFile = storageFile;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var5_6 = null;
            this.actionStorageFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionStorageFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privMkdirs(File file) {
        this.actionCode = 5;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privIsDirectory(File file) {
        this.actionCode = 6;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRemoveDirectory(File file) {
        this.actionCode = 7;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRenameTo(File file, File file2) {
        this.actionCode = 8;
        this.actionRegularFile = file;
        this.actionRegularFile2 = file2;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var6_7 = null;
            this.actionRegularFile = null;
            this.actionRegularFile2 = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                this.actionRegularFile = null;
                this.actionRegularFile2 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.actionRegularFile = null;
                this.actionRegularFile2 = null;
                throw throwable;
            }
        }
    }

    private synchronized boolean privCopyDirectory(StorageFile storageFile, File file, byte[] byArray, String[] stringArray, boolean bl) throws StandardException {
        this.actionCode = 9;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        this.actionCopySubDirs = bl;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl2 = (Boolean)t;
            Object var9_9 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
            return bl2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                throw (StandardException)privilegedActionException.getCause();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyDirectory(File file, StorageFile storageFile, byte[] byArray, String[] stringArray) {
        this.actionCode = 10;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var8_9 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var8_10 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(File file, StorageFile storageFile) {
        this.actionCode = 11;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var6_7 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    private synchronized boolean privCopyFile(StorageFile storageFile, File file) throws StandardException {
        this.actionCode = 14;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var6_6 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                throw (StandardException)privilegedActionException.getCause();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(StorageFile storageFile, StorageFile storageFile2) {
        this.actionCode = 17;
        this.actionStorageFile = storageFile;
        this.actionToStorageFile = storageFile2;
        try {
            Object t = AccessController.doPrivileged(this);
            boolean bl = (Boolean)t;
            Object var6_7 = null;
            this.actionStorageFile = null;
            this.actionToStorageFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                this.actionStorageFile = null;
                this.actionToStorageFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.actionStorageFile = null;
                this.actionToStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] privList(StorageFile storageFile) {
        this.actionCode = 13;
        this.actionStorageFile = storageFile;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(this);
            Object var5_4 = null;
            this.actionStorageFile = null;
            return stringArray;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                String[] stringArray = null;
                Object var5_5 = null;
                this.actionStorageFile = null;
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String privGetCanonicalPath(StorageFile storageFile) {
        this.actionCode = 16;
        this.actionStorageFile = storageFile;
        try {
            try {
                String string2 = (String)AccessController.doPrivileged(this);
                Object var5_5 = null;
                this.actionStorageFile = null;
                return string2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                String string3 = null;
                Object var5_6 = null;
                this.actionStorageFile = null;
                return string3;
            }
            catch (SecurityException securityException) {
                String string4 = null;
                Object var5_7 = null;
                this.actionStorageFile = null;
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.actionStorageFile = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String privGetCanonicalPath(File file) {
        this.actionCode = 15;
        this.actionRegularFile = file;
        try {
            try {
                String string2 = (String)AccessController.doPrivileged(this);
                Object var5_5 = null;
                this.actionRegularFile = null;
                return string2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                String string3 = null;
                Object var5_6 = null;
                this.actionRegularFile = null;
                return string3;
            }
            catch (SecurityException securityException) {
                String string4 = null;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    public final Object run() throws IOException, StandardException {
        switch (this.actionCode) {
            case 1: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(this.actionAppend));
            }
            case 2: {
                return ReuseFactory.getBoolean(this.actionRegularFile.exists());
            }
            case 3: {
                return ReuseFactory.getBoolean(this.actionStorageFile.exists());
            }
            case 4: {
                return ReuseFactory.getBoolean(this.actionRegularFile.delete());
            }
            case 18: {
                return ReuseFactory.getBoolean(this.actionStorageFile.delete());
            }
            case 5: {
                boolean bl = this.actionRegularFile.mkdirs();
                FileUtil.limitAccessToOwner(this.actionRegularFile);
                return ReuseFactory.getBoolean(bl);
            }
            case 6: {
                return ReuseFactory.getBoolean(this.actionRegularFile.isDirectory());
            }
            case 7: {
                return ReuseFactory.getBoolean(FileUtil.removeDirectory(this.actionRegularFile));
            }
            case 8: {
                return ReuseFactory.getBoolean(this.actionRegularFile.renameTo(this.actionRegularFile2));
            }
            case 9: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory(this.storageFactory, this.actionStorageFile, this.actionRegularFile, this.actionBuffer, this.actionFilter, this.actionCopySubDirs));
            }
            case 10: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile, this.actionBuffer, this.actionFilter));
            }
            case 11: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile));
            }
            case 12: {
                return this.actionRegularFile.list();
            }
            case 13: {
                return this.actionStorageFile.list();
            }
            case 14: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((StorageFactory)((WritableStorageFactory)this.storageFactory), this.actionStorageFile, this.actionRegularFile));
            }
            case 17: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionStorageFile, this.actionToStorageFile));
            }
            case 15: {
                return this.actionRegularFile.getCanonicalPath();
            }
            case 16: {
                return this.actionStorageFile.getCanonicalPath();
            }
            case 19: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(), "UTF8");
            }
        }
        return null;
    }

    private static boolean isSet(Properties properties, String string2) {
        return properties.getProperty(string2) != null;
    }

    private static boolean isTrue(Properties properties, String string2) {
        return Boolean.valueOf(properties.getProperty(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createDataWarningFile() throws StandardException {
        StorageFile storageFile = this.storageFactory.newStorageFile("seg0", "README_DO_NOT_TOUCH_FILES.txt");
        OutputStreamWriter outputStreamWriter = null;
        if (this.privExists(storageFile)) return;
        outputStreamWriter = this.privGetOutputStreamWriter(storageFile);
        outputStreamWriter.write(MessageService.getTextMessage("M007"));
        Object var5_3 = null;
        if (outputStreamWriter == null) return;
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (outputStreamWriter == null) return;
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

