/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.EmbeddedDataSourceInterface;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.EmbeddedXADataSourceInterface;
import org.apache.derby.jdbc.InternalDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedBaseDataSource
implements Serializable,
EmbeddedDataSourceInterface {
    private static final long serialVersionUID = 1872877359127597176L;
    protected String description;
    protected String dataSourceName;
    protected String databaseName;
    protected String connectionAttributes;
    protected String createDatabase;
    protected String shutdownDatabase;
    protected boolean attributesAsPassword;
    private String shortDatabaseName;
    private String password;
    private String user;
    protected int loginTimeout;
    private transient PrintWriter printer;
    protected transient String jdbcurl;
    protected transient InternalDriver driver;

    public EmbeddedBaseDataSource() {
        this.update();
    }

    @Override
    public final synchronized void setDatabaseName(String string2) {
        this.databaseName = string2;
        if (string2 != null && string2.indexOf(";") >= 0) {
            String[] stringArray = string2.split(";");
            this.shortDatabaseName = stringArray[0];
        } else {
            this.shortDatabaseName = string2;
        }
        this.update();
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    protected String getShortDatabaseName() {
        return this.shortDatabaseName;
    }

    @Override
    public final void setDataSourceName(String string2) {
        this.dataSourceName = string2;
    }

    @Override
    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public final void setDescription(String string2) {
        this.description = string2;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final void setUser(String string2) {
        this.user = string2;
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    @Override
    public final void setPassword(String string2) {
        this.password = string2;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printer = printWriter;
    }

    protected void update() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("jdbc:derby:");
        String string2 = this.getDatabaseName();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = " ";
        }
        stringBuffer.append(string2);
        String string3 = this.getConnectionAttributes();
        if (string3 != null && (string3 = string3.trim()).length() != 0) {
            stringBuffer.append(';');
            stringBuffer.append(this.connectionAttributes);
        }
        this.jdbcurl = stringBuffer.toString();
    }

    @Override
    public final void setCreateDatabase(String string2) {
        this.createDatabase = string2 != null && string2.toLowerCase(Locale.ENGLISH).equals("create") ? string2 : null;
    }

    @Override
    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalDriver findDriver() throws SQLException {
        String string2 = this.jdbcurl;
        EmbeddedBaseDataSource embeddedBaseDataSource = this;
        synchronized (embeddedBaseDataSource) {
            if (this.driver == null || !this.driver.acceptsURL(string2)) {
                new EmbeddedDriver();
                Driver driver = DriverManager.getDriver(string2);
                this.driver = driver instanceof AutoloadedDriver ? (InternalDriver)((Object)AutoloadedDriver.getDriverModule()) : (InternalDriver)((Object)driver);
            }
        }
        return this.driver;
    }

    @Override
    public final void setConnectionAttributes(String string2) {
        this.connectionAttributes = string2;
        this.update();
    }

    @Override
    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    @Override
    public final void setShutdownDatabase(String string2) {
        this.shutdownDatabase = string2 != null && string2.equalsIgnoreCase("shutdown") ? string2 : null;
    }

    @Override
    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    @Override
    public final void setAttributesAsPassword(boolean bl) {
        this.attributesAsPassword = bl;
        this.update();
    }

    @Override
    public final boolean getAttributesAsPassword() {
        return this.attributesAsPassword;
    }

    public boolean equals(Object object) {
        if (object instanceof EmbeddedDataSource) {
            EmbeddedDataSource embeddedDataSource = (EmbeddedDataSource)object;
            boolean bl = true;
            if (this.databaseName != null) {
                if (!this.databaseName.equals(embeddedDataSource.databaseName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.databaseName != null) {
                bl = false;
            }
            if (this.dataSourceName != null) {
                if (!this.dataSourceName.equals(embeddedDataSource.dataSourceName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.dataSourceName != null) {
                bl = false;
            }
            if (this.description != null) {
                if (!this.description.equals(embeddedDataSource.description)) {
                    bl = false;
                }
            } else if (embeddedDataSource.description != null) {
                bl = false;
            }
            if (this.createDatabase != null) {
                if (!this.createDatabase.equals(embeddedDataSource.createDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.createDatabase != null) {
                bl = false;
            }
            if (this.shutdownDatabase != null) {
                if (!this.shutdownDatabase.equals(embeddedDataSource.shutdownDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.shutdownDatabase != null) {
                bl = false;
            }
            if (this.connectionAttributes != null) {
                if (!this.connectionAttributes.equals(embeddedDataSource.connectionAttributes)) {
                    bl = false;
                }
            } else if (embeddedDataSource.connectionAttributes != null) {
                bl = false;
            }
            if (this.loginTimeout != embeddedDataSource.loginTimeout) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword(), false);
    }

    @Override
    public Connection getConnection(String string2, String string3) throws SQLException {
        return this.getConnection(string2, string3, true);
    }

    final Connection getConnection(String string2, String string3, boolean bl) throws SQLException {
        Object object;
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (!(bl && this.attributesAsPassword || string3 == null)) {
            properties.put("password", string3);
        }
        if (this.createDatabase != null) {
            properties.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            properties.put("shutdown", "true");
        }
        String string4 = this.jdbcurl;
        if (this.attributesAsPassword && bl && string3 != null) {
            object = new StringBuffer(string4.length() + string3.length() + 1);
            ((StringBuffer)object).append(string4);
            ((StringBuffer)object).append(';');
            ((StringBuffer)object).append(string3);
            string4 = ((StringBuffer)object).toString();
        }
        if ((object = this.findDriver().connect(string4, properties, this.loginTimeout)) == null) {
            throw Util.generateCsSQLException("XCY00.S", (Object)"databaseName", this.getDatabaseName());
        }
        return object;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw Util.generateCsSQLException("XJ128.S", clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ResourceAdapter setupResourceAdapter(EmbeddedXADataSourceInterface embeddedXADataSourceInterface, ResourceAdapter resourceAdapter, String string2, String string3, boolean bl) throws SQLException {
        EmbeddedXADataSourceInterface embeddedXADataSourceInterface2 = embeddedXADataSourceInterface;
        synchronized (embeddedXADataSourceInterface2) {
            if (resourceAdapter == null || !resourceAdapter.isActive()) {
                Object object;
                resourceAdapter = null;
                String string4 = ((EmbeddedBaseDataSource)((Object)embeddedXADataSourceInterface)).getShortDatabaseName();
                if (string4 != null) {
                    object = null;
                    if (Monitor.getMonitor() != null) {
                        object = (Database)Monitor.findService("org.apache.derby.database.Database", string4);
                    }
                    if (object == null) {
                        if (bl) {
                            embeddedXADataSourceInterface.getConnection(string2, string3).close();
                        } else {
                            embeddedXADataSourceInterface.getConnection().close();
                        }
                        object = (Database)Monitor.findService("org.apache.derby.database.Database", string4);
                    }
                    if (object != null) {
                        resourceAdapter = (ResourceAdapter)object.getResourceAdapter();
                    }
                }
                if (resourceAdapter == null) {
                    throw new SQLException(MessageService.getTextMessage("I024"), "08006", 45000);
                }
                object = ((EmbeddedBaseDataSource)((Object)embeddedXADataSourceInterface)).findDriver();
                if (object == null) {
                    throw new SQLException(MessageService.getTextMessage("I025"), "08006", 45000);
                }
            }
        }
        return resourceAdapter;
    }
}

