/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.transaction.xa.XAException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.jdbc.XATransactionState;

public class ResourceAdapterImpl
implements ResourceAdapter,
ModuleControl {
    private boolean active;
    private XAResourceManager rm;
    private Hashtable<XAXactId, XATransactionState> connectionTable;

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.connectionTable = new Hashtable();
        AccessFactory accessFactory = (AccessFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.rm = (XAResourceManager)accessFactory.getXAResourceManager();
        this.active = true;
    }

    public void stop() {
        this.active = false;
        Enumeration<XATransactionState> enumeration = this.connectionTable.elements();
        while (enumeration.hasMoreElements()) {
            XATransactionState xATransactionState = enumeration.nextElement();
            try {
                xATransactionState.conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized Object findConnection(XAXactId xAXactId) {
        return this.connectionTable.get(xAXactId);
    }

    public synchronized boolean addConnection(XAXactId xAXactId, Object object) {
        if (this.connectionTable.get(xAXactId) != null) {
            return false;
        }
        this.connectionTable.put(xAXactId, (XATransactionState)object);
        return true;
    }

    public synchronized Object removeConnection(XAXactId xAXactId) {
        return this.connectionTable.remove(xAXactId);
    }

    public void cancelXATransaction(XAXactId xAXactId, String string2) throws XAException {
        XATransactionState xATransactionState = (XATransactionState)this.findConnection(xAXactId);
        if (xATransactionState != null) {
            xATransactionState.cancel(string2);
        }
    }

    public XAResourceManager getXAResourceManager() {
        return this.rm;
    }
}

