/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.jena.atlas.io.IO;

public final class BufferingWriter
extends Writer {
    private static final int SIZE = 8192;
    private static final int BLOB_SIZE = 4096;
    private final int blockSize;
    private final int blobSize;
    private char[] buffer = new char[8192];
    private int idx = 0;
    private Writer out;

    public BufferingWriter(Writer dest) {
        this(dest, 8192, 4096);
    }

    public BufferingWriter(Writer dest, int size) {
        this(dest, size, size / 2);
    }

    public BufferingWriter(Writer dest, int size, int blobSize) {
        this.out = dest;
        this.blockSize = size;
        this.blobSize = blobSize;
    }

    public void output(String string2) {
        this.output(string2, 0, string2.length());
    }

    public void output(String string2, int off, int length) {
        boolean largeBlob;
        boolean bl = largeBlob = length > this.blobSize;
        if (largeBlob || this.blockSize - this.idx < length) {
            this.flushBuffer();
        }
        if (largeBlob) {
            try {
                this.out.write(string2, off, length);
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
            return;
        }
        int n = string2.length();
        string2.getChars(off, n + off, this.buffer, this.idx);
        this.idx += n;
    }

    public void output(char[] chars) {
        this.output(chars, 0, chars.length);
    }

    public void output(char[] chars, int start, int length) {
        boolean largeBlob;
        boolean bl = largeBlob = length > this.blobSize;
        if (largeBlob || this.blockSize - this.idx < length) {
            this.flushBuffer();
        }
        if (largeBlob) {
            try {
                this.out.write(chars);
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
            return;
        }
        System.arraycopy(chars, start, this.buffer, this.idx, length);
        this.idx += length;
    }

    public void output(char ch) {
        if (this.blockSize == this.idx) {
            this.flushBuffer();
        }
        this.buffer[this.idx++] = ch;
    }

    private void flushBuffer() {
        if (this.idx > 0) {
            try {
                this.out.write(this.buffer, 0, this.idx);
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
            this.idx = 0;
        }
    }

    @Override
    public void close() {
        this.flushBuffer();
        IO.close(this.out);
    }

    @Override
    public void flush() {
        this.flushBuffer();
        IO.flush(this.out);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.output(cbuf, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String string2, int off, int len) throws IOException {
        this.output(string2, off, len);
    }

    @Override
    public void write(String string2) throws IOException {
        this.output(string2, 0, string2.length());
    }

    @Override
    public void write(int ch) throws IOException {
        this.output((char)ch);
    }
}

