/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.fastinfoset.sax.AttributesHolder;
import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.ElementIdStack;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class FastInfosetReader
extends StAXDocumentParser
implements XMLReader {
    int _state;
    ElementIdStack _elementIds;
    int _elementId;
    AttributesAdapter _attrsAdapter = new AttributesAdapter();

    public FastInfosetReader(InputStream is) {
        this.setInputStream(is);
    }

    public void reset() {
        super.reset();
        this._state = 0;
        if (this._elementIds == null) {
            this._elementIds = new ElementIdStack();
        } else {
            this._elementIds.reset();
        }
        this._elementId = 0;
    }

    public int next() {
        if (this._state == 5) {
            return 5;
        }
        try {
            int readerEvent = super.next();
            while (readerEvent != 8) {
                switch (readerEvent) {
                    case 1: {
                        this._elementId = this._elementIds.pushNext();
                        this._state = 1;
                        return 1;
                    }
                    case 2: {
                        this._elementId = this._elementIds.pop();
                        this._state = 2;
                        return 2;
                    }
                    case 4: 
                    case 12: {
                        this._state = 3;
                        return 3;
                    }
                    case 3: {
                        this._state = 4;
                        return 4;
                    }
                }
                readerEvent = super.next();
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
        this._state = 5;
        return 5;
    }

    public int nextElementContent() {
        int state = this.nextContent();
        if (state == 3) {
            throw new XMLReaderException("xmlreader.unexpectedCharacterContent", this.getValue());
        }
        return state;
    }

    public int nextContent() {
        block5: while (true) {
            int state = this.next();
            switch (state) {
                case 1: 
                case 2: 
                case 5: {
                    return state;
                }
                case 3: {
                    if (this._characters == null || this.isWhiteSpaceCharacters()) continue block5;
                    return 3;
                }
                case 4: {
                    continue block5;
                }
            }
        }
    }

    public int getState() {
        return this._state;
    }

    public String getURI() {
        return this.getNamespaceURI();
    }

    public Attributes getAttributes() {
        return this._attrsAdapter.setTarget(this._attributes);
    }

    public String getValue() {
        return this._state == 4 ? this.getPIData() : this.getText();
    }

    public int getElementId() {
        return this._elementId;
    }

    public int getLineNumber() {
        return -1;
    }

    public XMLReader recordElement() {
        throw new UnsupportedOperationException("recordElement()");
    }

    public void skipElement() {
        this.skipElement(this.getElementId());
    }

    public void skipElement(int elementId) {
        while (this._state != 5 && (this._state != 2 || this._elementId != elementId)) {
            this.next();
        }
    }

    public void close() {
        try {
            this._state = 5;
            super.close();
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    private XMLReaderException wrapException(XMLStreamException e) {
        return new XMLReaderException("xmlreader.ioException", new LocalizableExceptionAdapter(e));
    }

    private boolean isWhiteSpaceCharacters() {
        int i = this._charactersOffset;
        int end = i + this._charactersLength;
        while (i < end) {
            if (this._characters[i++] <= ' ') continue;
            return false;
        }
        return true;
    }

    static final class AttributesAdapter
    implements Attributes {
        AttributesHolder _attr;

        public final AttributesAdapter setTarget(AttributesHolder attr) {
            this._attr = attr;
            return this;
        }

        public final int getLength() {
            return this._attr.getLength();
        }

        public final boolean isNamespaceDeclaration(int index) {
            return false;
        }

        public final QName getName(int index) {
            return this._attr.getQualifiedName(index).getQName();
        }

        public final String getURI(int index) {
            return this._attr.getURI(index);
        }

        public final String getLocalName(int index) {
            return this._attr.getLocalName(index);
        }

        public final String getPrefix(int index) {
            return this._attr.getPrefix(index);
        }

        public final String getValue(int index) {
            return this._attr.getValue(index);
        }

        public final int getIndex(QName name) {
            return this._attr.getIndex(name.getNamespaceURI(), name.getLocalPart());
        }

        public final int getIndex(String uri, String localName) {
            return this._attr.getIndex(uri, localName);
        }

        public final int getIndex(String localName) {
            return this._attr.getIndex(localName);
        }

        public final String getValue(QName name) {
            return this._attr.getValue(name.getNamespaceURI(), name.getLocalPart());
        }

        public final String getValue(String uri, String localName) {
            return this._attr.getValue(uri, localName);
        }

        public final String getValue(String localName) {
            return this._attr.getValue(localName);
        }

        public final String toString() {
            StringBuffer attributes = new StringBuffer();
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    attributes.append("\n");
                }
                attributes.append(this.getURI(i) + ":" + this.getLocalName(i) + " = " + this.getValue(i));
            }
            return attributes.toString();
        }
    }
}

