/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import com.occamlab.te.util.ZipUtils;
import com.occamlab.te.web.Config;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EmailLogServlet
extends HttpServlet
implements Servlet {
    Config Conf;

    @Override
    public void init() throws ServletException {
        this.Conf = new Config();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            File userdir = new File(this.Conf.getUsersDir(), request.getParameter("userId"));
            File zipFile = new File(userdir, request.getParameter("zipFileName"));
            if (this.sendLog(this.getServletConfig().getInitParameter("mail.smtp.host"), this.getServletConfig().getInitParameter("mail.smtp.userid"), this.getServletConfig().getInitParameter("mail.smtp.passwd"), request.getParameter("to"), request.getParameter("from"), request.getParameter("subject"), request.getParameter("message"), zipFile)) {
                request.setAttribute("emailStatus", "Email sent Succesfully");
            } else {
                request.setAttribute("emailStatus", "Email failed");
            }
            RequestDispatcher rd = request.getRequestDispatcher("emailSent.jsp");
            rd.forward(request, response);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String sessionId = request.getParameter("session");
            String zipFileName = sessionId + ".zip";
            File userdir = new File(this.Conf.getUsersDir(), request.getRemoteUser());
            File sessiondir = new File(userdir, sessionId);
            File zipFile = new File(userdir, zipFileName);
            ZipUtils.zipDir(zipFile, sessiondir);
            request.setAttribute("zipFileName", zipFileName);
            request.setAttribute("to", this.getServletConfig().getInitParameter("mail.to"));
            RequestDispatcher rd = request.getRequestDispatcher("emailLog.jsp");
            rd.forward(request, response);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public boolean sendLog(String host, String userId, String password, String to, String from, String subject, String message, File filename) {
        boolean success;
        block2: {
            success = true;
            System.out.println("host: " + host);
            System.out.println("userId: " + userId);
            System.out.println("to: " + to);
            System.out.println("from: " + from);
            System.out.println("subject: " + subject);
            System.out.println("message: " + message);
            System.out.println("filename: " + filename.getName());
            System.out.println("filename: " + filename.getAbsolutePath());
            Properties props = System.getProperties();
            props.put("mail.smtp.host", host);
            props.put("mail.smtp.auth", "true");
            Session session = Session.getInstance(props, null);
            session.setDebug(true);
            try {
                MimeMessage msg = new MimeMessage(session);
                msg.setFrom(new InternetAddress(from));
                Address[] address = new InternetAddress[]{new InternetAddress(to)};
                msg.setRecipients(Message.RecipientType.TO, address);
                msg.setSubject(subject);
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(message);
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(filename);
                mbp2.setDataHandler(new DataHandler(fds));
                mbp2.setFileName(fds.getName());
                MimeMultipart mp = new MimeMultipart();
                ((Multipart)mp).addBodyPart(mbp1);
                ((Multipart)mp).addBodyPart(mbp2);
                msg.setContent(mp);
                msg.setSentDate(new Date());
                Transport trans = session.getTransport("smtp");
                trans.connect(host, userId, password);
                trans.sendMessage(msg, msg.getAllRecipients());
                trans.close();
            }
            catch (MessagingException mex) {
                success = false;
                mex.printStackTrace();
                Exception ex = null;
                ex = mex.getNextException();
                if (ex == null) break block2;
                ex.printStackTrace();
            }
        }
        return success;
    }
}

