/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import com.occamlab.te.TECore;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.web.CachedHttpURLConnection;
import com.occamlab.te.web.MonitorCall;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.XdmNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class MonitorServlet
extends HttpServlet {
    private static final Logger LOGR = Logger.getLogger(MonitorServlet.class.getPackage().getName());
    public static final String CTL_NS = "http://www.occamlab.com/ctl";
    static DocumentBuilder DB;
    static Transformer identityTransformer;
    static String baseServletURL;
    static String servletName;
    static int monitorCallSeq;
    static int monitorUrlSeq;
    static Map<String, MonitorCall> monitors;

    public static String allocateMonitorUrl(String url) {
        String monitorUrl = baseServletURL + "/" + servletName + "/" + Integer.toString(monitorUrlSeq);
        ++monitorUrlSeq;
        MonitorCall mc = new MonitorCall(url);
        monitors.put(monitorUrl, mc);
        return monitorUrl;
    }

    public static String createMonitor(String monitorUrl, TECore core) {
        return MonitorServlet.createMonitor((String)monitorUrl, null, (String)"", (TECore)core);
    }

    public static String createMonitor(String monitorUrl, Node parserInstruction, String modifiesResponse, TECore core) {
        MonitorCall mc = (MonitorCall)monitors.get(monitorUrl);
        mc.setCore(core);
        if (parserInstruction != null) {
            mc.setParserInstruction(DomUtils.getElement(parserInstruction));
            mc.setModifiesResponse(Boolean.parseBoolean(modifiesResponse));
        }
        LOGR.log(Level.CONFIG, "Configured monitor without test:\n {0}", mc);
        return "";
    }

    public static String createMonitor(XPathContext context, String url, String localName, String namespaceURI, NodeInfo params, String callId, TECore core) throws Exception {
        return MonitorServlet.createMonitor((XPathContext)context, (String)url, (String)localName, (String)namespaceURI, (NodeInfo)params, null, (String)"", (String)callId, (TECore)core);
    }

    public static String createMonitor(XPathContext context, String monitorUrl, String localName, String namespaceURI, NodeInfo params, NodeInfo parserInstruction, String modifiesResponse, String callId, TECore core) throws Exception {
        NodeOverNodeInfo node;
        MonitorCall mc = (MonitorCall)monitors.get(monitorUrl);
        mc.setContext(context);
        mc.setLocalName(localName);
        mc.setNamespaceURI(namespaceURI);
        mc.setCore(core);
        if (params != null) {
            node = NodeOverNodeInfo.wrap(params);
            if (node.getNodeType() == 9) {
                mc.setParams(((Document)((Object)node)).getDocumentElement());
            } else {
                mc.setParams((Element)((Object)node));
            }
        }
        if (parserInstruction != null) {
            node = NodeOverNodeInfo.wrap(parserInstruction);
            if (node.getNodeType() == 9) {
                mc.setParserInstruction(((Document)((Object)node)).getDocumentElement());
            } else {
                mc.setParserInstruction((Element)((Object)node));
            }
            mc.setModifiesResponse(Boolean.parseBoolean(modifiesResponse));
        }
        mc.setCallId(callId);
        LOGR.log(Level.CONFIG, "Configured monitor with test:\n {0}", mc);
        return "";
    }

    public static String destroyMonitors(TECore core) {
        ArrayList keysToDelete = new ArrayList();
        for (Map.Entry entry : monitors.entrySet()) {
            MonitorCall mc = (MonitorCall)entry.getValue();
            if (mc.getCore() != core || !mc.getTestPath().equals(core.getTestPath())) continue;
            keysToDelete.add(entry.getKey());
            mc.destroy();
        }
        for (String key : keysToDelete) {
            monitors.remove(key);
        }
        return "";
    }

    public void process(HttpServletRequest request, HttpServletResponse response, boolean post) throws ServletException {
        try {
            String uri = request.getRequestURL().toString();
            MonitorCall mc = (MonitorCall)monitors.get(uri);
            if (mc == null) {
                response.sendError(410, "This URL is no longer valid");
                return;
            }
            if (null == request.getContentType()) {
                String query = null;
                query = URLDecoder.decode(request.getQueryString(), "UTF-8");
                mc.checkCoverage(query);
            }
            TECore core = mc.getCore();
            String url = mc.getUrl();
            String queryString = request.getQueryString();
            if (queryString != null) {
                url = url.contains("?") ? url + queryString : url + "?" + queryString;
            }
            LOGR.log(Level.FINE, "Opening connection to " + url);
            HttpURLConnection huc = (HttpURLConnection)new URL(url).openConnection();
            CachedHttpURLConnection uc = new CachedHttpURLConnection(huc);
            String method = request.getMethod();
            uc.setRequestMethod(method);
            uc.setDoInput(true);
            uc.setDoOutput(post);
            byte[] data = null;
            if (post) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MonitorServlet.copy_stream((InputStream)request.getInputStream(), (OutputStream)baos);
                data = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                MonitorServlet.copy_stream((InputStream)bais, (OutputStream)uc.getOutputStream());
            }
            Document doc = DB.newDocument();
            Element eRequest = this.encodeRequest(request, doc, data);
            Element parserInstruction = mc.getParserInstruction();
            Element eResponse = core.parse((URLConnection)uc, parserInstruction);
            Map responseHeaders = uc.getHeaderFields();
            for (Map.Entry entry : responseHeaders.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null || key.length() == 0 || key.equalsIgnoreCase("Transfer-Encoding")) continue;
                for (String value : (List)entry.getValue()) {
                    response.setHeader(key, value);
                }
            }
            if (mc.getModifiesResponse()) {
                LOGR.log(Level.FINE, DomUtils.serializeNode(eResponse));
                Element content = DomUtils.getElementByTagName(eResponse, "content");
                Element root = DomUtils.getChildElement(content);
                identityTransformer.transform(new DOMSource(root), new StreamResult(response.getOutputStream()));
            } else {
                response.setContentLength(uc.getLength());
                MonitorServlet.copy_stream((InputStream)uc.getInputStream(), (OutputStream)response.getOutputStream());
            }
            if (mc.getCallId() != null) {
                identityTransformer.transform(new DOMSource(mc.getParams()), new DOMResult(doc));
                Element eParams = DomUtils.getElementByTagName(doc, "params");
                Element eReqParam = doc.createElement("param");
                eReqParam.setAttribute("local-name", "request");
                eReqParam.setAttribute("namespace-uri", "");
                eReqParam.setAttribute("prefix", "");
                eReqParam.setAttribute("type", "node()");
                Element eReqValue = doc.createElement("value");
                eReqValue.appendChild(eRequest);
                eReqParam.appendChild(eReqValue);
                eParams.appendChild(eReqParam);
                Element eRespParam = doc.createElement("param");
                eRespParam.setAttribute("local-name", "response");
                eRespParam.setAttribute("namespace-uri", "");
                eRespParam.setAttribute("prefix", "");
                eRespParam.setAttribute("type", "node()");
                Element eRespValue = doc.createElement("value");
                identityTransformer.transform(new DOMSource(eResponse), new DOMResult(eRespValue));
                eRespParam.appendChild(eRespValue);
                eParams.appendChild(eRespParam);
                net.sf.saxon.s9api.DocumentBuilder builder = core.getEngine().getBuilder();
                XdmNode paramsNode = builder.build(new DOMSource(doc));
                String callId = mc.getCallId() + "_" + Integer.toString(++monitorCallSeq);
                core.callTest(mc.getContext(), mc.getLocalName(), mc.getNamespaceURI(), paramsNode.getUnderlyingNode(), callId);
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    @Override
    public void init() throws ServletException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            DB = dbf.newDocumentBuilder();
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            identityTransformer = tf.newTransformer();
            servletName = this.getServletName();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.process(request, response, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.process(request, response, true);
    }

    Element encodeRequest(HttpServletRequest request, Document doc, byte[] data) throws Exception {
        Element eRequest = doc.createElementNS("http://www.occamlab.com/ctl", "ctl:request");
        Element eURL = doc.createElementNS("http://www.occamlab.com/ctl", "ctl:url");
        eURL.setTextContent(request.getRequestURL().toString());
        eRequest.appendChild(eURL);
        Element eMethod = doc.createElementNS("http://www.occamlab.com/ctl", "ctl:method");
        eMethod.setTextContent(request.getMethod());
        eRequest.appendChild(eMethod);
        Enumeration requestHeaders = request.getHeaderNames();
        while (requestHeaders.hasMoreElements()) {
            String key = (String)requestHeaders.nextElement();
            Element eHeader = doc.createElementNS("http://www.occamlab.com/ctl", "ctl:header");
            eHeader.setAttribute("name", key);
            eHeader.setTextContent(request.getHeader(key));
            eRequest.appendChild(eHeader);
        }
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String key = (String)params.nextElement();
            Element eParam = doc.createElementNS("http://www.occamlab.com/ctl", "ctl:param");
            eParam.setAttribute("name", key);
            eParam.setTextContent(request.getParameter(key));
            eRequest.appendChild(eParam);
        }
        if (data != null) {
            String mime = request.getContentType();
            if (mime.indexOf("text/xml") == 0 || mime.indexOf("application/xml") == 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                Element eBody = doc.createElementNS("http://www.occamlab.com/ctl", "ctl:body");
                TransformerFactory tf = TransformerFactory.newInstance();
                tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer t = tf.newTransformer();
                t.transform(new StreamSource(bais), new DOMResult(eBody));
                eRequest.appendChild(eBody);
            } else if (mime.indexOf("text/") == 0) {
                Element eBody = doc.createElementNS("http://www.occamlab.com/ctl", "ctl:body");
                eBody.appendChild(doc.createCDATASection(data.toString()));
                eRequest.appendChild(eBody);
            }
        }
        return eRequest;
    }

    static void copy_stream(InputStream in, OutputStream out) throws IOException {
        int i = in.read();
        while (i >= 0) {
            out.write(i);
            i = in.read();
        }
    }

    public static String getBaseServletURL() {
        return baseServletURL;
    }

    public static void setBaseServletURL(String baseServletURL) {
        MonitorServlet.baseServletURL = baseServletURL;
    }

    static {
        monitorCallSeq = 0;
        monitorUrlSeq = 0;
        monitors = new HashMap();
    }
}

