/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.ValueRestrictDatatype;
import java.math.BigDecimal;
import org.relaxng.datatype.DatatypeException;

class PrecisionRestrictDatatype
extends ValueRestrictDatatype {
    private final int precision;

    PrecisionRestrictDatatype(DatatypeBase datatypeBase, int n) {
        super(datatypeBase);
        this.precision = n;
    }

    void checkRestriction(Object object) throws DatatypeException {
        int n = PrecisionRestrictDatatype.getPrecision((BigDecimal)object);
        if (n > this.precision) {
            String string2 = this.precision == 1 ? PrecisionRestrictDatatype.localizer().message("precision_1_violation", this.getDescriptionForRestriction(), n) : PrecisionRestrictDatatype.localizer().message("precision_violation", new Object[]{this.getDescriptionForRestriction(), this.precision, n});
            throw new DatatypeException(string2);
        }
    }

    static int getPrecision(BigDecimal bigDecimal) {
        return bigDecimal.movePointRight(bigDecimal.scale()).abs().toString().length();
    }
}

