/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.jaxp;

import com.thaiopensource.relaxng.jaxp.SchemaFactoryImpl;
import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMatcher;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.sax.Context;
import com.thaiopensource.validation.ValidatorHandler2;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import com.thaiopensource.xml.util.Name;
import javax.xml.validation.TypeInfoProvider;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

class ValidatorHandlerImpl
extends ValidatorHandler2 {
    private Matcher matcher;
    private static final ErrorHandler defaultErrorHandler = new DraconianErrorHandler();
    private ErrorHandler specifiedErrorHandler = null;
    private ErrorHandler actualErrorHandler = defaultErrorHandler;
    private boolean bufferingCharacters = false;
    private final StringBuffer charBuf = new StringBuffer();
    private Locator locator = null;
    private final Context context;
    private ContentHandler contentHandler = null;
    private DTDHandler dtdHandler;
    private LSResourceResolver resourceResolver = null;
    private boolean secureProcessing;

    ValidatorHandlerImpl(SchemaFactoryImpl schemaFactoryImpl, Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder) {
        this.matcher = new PatternMatcher(pattern, validatorPatternBuilder);
        this.context = new Context();
        this.secureProcessing = false;
    }

    public void reset() {
        this.bufferingCharacters = false;
        this.locator = null;
        this.matcher = this.matcher.start();
        this.context.reset();
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), this.context));
        }
        Name name = new Name(string2, string3);
        this.check(this.matcher.matchStartTagOpen(name, string4, this.context));
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Name name2 = new Name(attributes.getURI(i), attributes.getLocalName(i));
            String string5 = attributes.getQName(i);
            this.check(this.matcher.matchAttributeName(name2, string5, this.context));
            this.check(this.matcher.matchAttributeValue(attributes.getValue(i), name2, string5, this.context));
        }
        this.check(this.matcher.matchStartTagClose(name, string4, this.context));
        if (this.matcher.isTextTyped()) {
            this.bufferingCharacters = true;
            this.charBuf.setLength(0);
        }
        if (this.contentHandler != null) {
            this.contentHandler.startElement(string2, string3, string4, attributes);
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            if (this.charBuf.length() > 0) {
                this.check(this.matcher.matchTextBeforeEndTag(this.charBuf.toString(), new Name(string2, string3), string4, this.context));
            }
        }
        this.check(this.matcher.matchEndTag(new Name(string2, string3), string4, this.context));
        if (this.contentHandler != null) {
            this.contentHandler.endElement(string2, string3, string4);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.bufferingCharacters) {
            this.charBuf.append(cArray, n, n2);
            return;
        }
        block3: for (int i = 0; i < n2; ++i) {
            switch (cArray[n + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.check(this.matcher.matchUntypedText(this.context));
                    return;
                }
            }
        }
    }

    public void endDocument() throws SAXException {
        this.check(this.matcher.matchEndDocument());
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        this.check(this.matcher.matchStartDocument());
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(string2, string3);
        }
    }

    public void skippedEntity(String string2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(string2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    private void check(boolean bl) throws SAXException {
        if (!bl) {
            this.actualErrorHandler.error(new SAXParseException(this.matcher.getErrorMessage(), this.locator));
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.specifiedErrorHandler = errorHandler;
        this.actualErrorHandler = errorHandler == null ? defaultErrorHandler : errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.specifiedErrorHandler;
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.resourceResolver = lSResourceResolver;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), this.context));
        }
        this.context.startPrefixMapping(string2, string3);
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(string2, string3);
        }
    }

    public void endPrefixMapping(String string2) throws SAXException {
        this.context.endPrefixMapping(string2);
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(string2);
        }
    }

    public void notationDecl(String string2, String string3, String string4) throws SAXException {
        this.context.notationDecl(string2, string3, string4);
        if (this.dtdHandler != null) {
            this.dtdHandler.notationDecl(string2, string3, string4);
        }
    }

    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
        this.context.unparsedEntityDecl(string2, string3, string4, string5);
        if (this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(string2, string3, string4, string5);
        }
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(string2)) {
            this.secureProcessing = bl;
        } else {
            super.setFeature(string2, bl);
        }
    }

    public boolean getFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(string2)) {
            return this.secureProcessing;
        }
        return super.getFeature(string2);
    }
}

