/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.sax;

import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.sax.SAXSubParser;
import com.thaiopensource.relaxng.parse.sax.SchemaParser;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.Uri;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXParseable<P, NC, L, EA, CL extends CommentList<L>, A extends Annotations<L, EA, CL>>
extends SAXSubParser<P, NC, L, EA, CL, A>
implements SubParseable<P, NC, L, EA, CL, A> {
    private final SAXSource source;

    public SAXParseable(SAXSource sAXSource, SAXResolver sAXResolver, ErrorHandler errorHandler) {
        super(sAXResolver, errorHandler);
        this.source = sAXSource;
    }

    @Override
    public P parse(SchemaBuilder<P, NC, L, EA, CL, A> schemaBuilder, Scope<P, L, EA, CL, A> scope) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.source.getXMLReader();
            SchemaParser<P, NC, L, EA, CL, A> schemaParser = new SchemaParser<P, NC, L, EA, CL, A>(xMLReader, this.eh, schemaBuilder, null, scope);
            xMLReader.parse(this.source.getInputSource());
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw BuildException.fromSAXException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    @Override
    public P parseAsInclude(SchemaBuilder<P, NC, L, EA, CL, A> schemaBuilder, IncludedGrammar<P, L, EA, CL, A> includedGrammar) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.source.getXMLReader();
            SchemaParser<P, NC, L, EA, CL, A> schemaParser = new SchemaParser<P, NC, L, EA, CL, A>(xMLReader, this.eh, schemaBuilder, includedGrammar, includedGrammar);
            xMLReader.parse(this.source.getInputSource());
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw BuildException.fromSAXException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    @Override
    public String getUri() {
        String string2 = this.source.getInputSource().getSystemId();
        if (string2 == null) {
            return null;
        }
        return Uri.escapeDisallowedChars(string2);
    }
}

