/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.derby.authentication.SystemPrincipal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;

public class SecurityUtil {
    public static Subject createSystemPrincipalSubject(String string2) {
        HashSet<SystemPrincipal> hashSet = new HashSet<SystemPrincipal>();
        if (string2 != null) {
            hashSet.add(new SystemPrincipal(string2));
            hashSet.add(new SystemPrincipal(SecurityUtil.getAuthorizationId(string2)));
        }
        HashSet hashSet2 = new HashSet();
        return new Subject(true, hashSet, hashSet2, hashSet2);
    }

    private static String getAuthorizationId(String string2) {
        if (string2 == null) {
            throw new NullPointerException("name can't be null");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        try {
            return IdUtil.getUserAuthorizationId(string2);
        }
        catch (StandardException standardException) {
            throw new IllegalArgumentException(standardException.getMessage());
        }
    }

    public static void checkSubjectHasPermission(final Subject subject, final Permission permission) {
        final PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AccessController.checkPermission(permission);
                return null;
            }
        };
        PrivilegedAction<Void> privilegedAction2 = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AccessControlContext accessControlContext = null;
                Subject.doAsPrivileged(subject, privilegedAction, accessControlContext);
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction2);
    }

    public static void checkUserHasPermission(String string2, Permission permission) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Subject subject = SecurityUtil.createSystemPrincipalSubject(string2);
        SecurityUtil.checkSubjectHasPermission(subject, permission);
    }
}

