/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.LimitInputStream;

public final class RawToBinaryFormatStream
extends LimitInputStream {
    private int encodedOffset;
    private byte[] encodedLength;
    private boolean eof = false;
    private final int length;
    private final int maximumLength;
    private final String typeName;

    public RawToBinaryFormatStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n < 0) {
            throw new IllegalArgumentException("Stream length cannot be negative: " + n);
        }
        this.length = n;
        this.maximumLength = -1;
        this.typeName = null;
        this.setLimit(n);
        if (n <= 31) {
            this.encodedLength = new byte[1];
            this.encodedLength[0] = (byte)(0x80 | n & 0xFF);
        } else if (n <= 65535) {
            this.encodedLength = new byte[3];
            this.encodedLength[0] = -96;
            this.encodedLength[1] = (byte)(n >> 8);
            this.encodedLength[2] = (byte)n;
        } else {
            this.encodedLength = new byte[5];
            this.encodedLength[0] = -64;
            this.encodedLength[1] = (byte)(n >> 24);
            this.encodedLength[2] = (byte)(n >> 16);
            this.encodedLength[3] = (byte)(n >> 8);
            this.encodedLength[4] = (byte)n;
        }
    }

    public RawToBinaryFormatStream(InputStream inputStream, int n, String string2) {
        super(inputStream);
        if (n < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + n);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        this.length = -1;
        this.maximumLength = n;
        this.typeName = string2;
        this.encodedLength = new byte[4];
        this.setLimit(n);
    }

    public int read() throws IOException {
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.encodedOffset < this.encodedLength.length) {
            return this.encodedLength[this.encodedOffset++] & 0xFF;
        }
        int n = super.read();
        if (n == -1) {
            this.checkSufficientData();
        }
        return n;
    }

    private void checkSufficientData() throws IOException {
        this.eof = true;
        if (!this.limitInPlace) {
            return;
        }
        int n = this.clearLimit();
        if (this.length > -1 && n > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
        }
        if (n == 0) {
            int n2;
            try {
                n2 = super.read();
            }
            catch (IOException iOException) {
                n2 = -1;
            }
            if (n2 != -1) {
                if (this.length > -1) {
                    throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
                }
                throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "XXXX", String.valueOf(this.maximumLength)), "22001");
            }
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        int n4 = this.encodedLength.length - this.encodedOffset;
        if (n4 != 0) {
            if (n2 < n4) {
                n4 = n2;
            }
            System.arraycopy(this.encodedLength, this.encodedOffset, byArray, n, n4);
            this.encodedOffset += n4;
            n += n4;
            if ((n2 -= n4) == 0) {
                return n4;
            }
        }
        if ((n3 = super.read(byArray, n, n2)) < 0) {
            if (n4 != 0) {
                return n4;
            }
            this.checkSufficientData();
            return n3;
        }
        return n4 + n3;
    }
}

