/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.EmbedCallableStatement;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedCallableStatement20
extends EmbedCallableStatement {
    public EmbedCallableStatement20(EmbedConnection embedConnection, String string2, int n, int n2, int n3) throws SQLException {
        super(embedConnection, string2, n, n2, n3);
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public Array getArray(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    public void setArray(int n, Array array) throws SQLException {
        throw Util.notImplemented();
    }

    public void registerOutParameter(String string2, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void registerOutParameter(String string2, int n, String string3) throws SQLException {
        throw Util.notImplemented();
    }

    public void registerOutParameter(String string2, int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public Ref getRef(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Blob getBlob(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Clob getClob(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Array getArray(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setNull(String string2, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setNull(String string2, int n, String string3) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBoolean(String string2, boolean bl) throws SQLException {
        throw Util.notImplemented();
    }

    public boolean getBoolean(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setByte(String string2, byte by) throws SQLException {
        throw Util.notImplemented();
    }

    public byte getByte(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setShort(String string2, short s) throws SQLException {
        throw Util.notImplemented();
    }

    public short getShort(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setInt(String string2, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public int getInt(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setLong(String string2, long l) throws SQLException {
        throw Util.notImplemented();
    }

    public long getLong(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setFloat(String string2, float f) throws SQLException {
        throw Util.notImplemented();
    }

    public float getFloat(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setDouble(String string2, double d) throws SQLException {
        throw Util.notImplemented();
    }

    public double getDouble(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBigDecimal(String string2, BigDecimal bigDecimal) throws SQLException {
        throw Util.notImplemented();
    }

    public BigDecimal getBigDecimal(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setString(String string2, String string3) throws SQLException {
        throw Util.notImplemented();
    }

    public String getString(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBytes(String string2, byte[] byArray) throws SQLException {
        throw Util.notImplemented();
    }

    public byte[] getBytes(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setDate(String string2, Date date) throws SQLException {
        throw Util.notImplemented();
    }

    public void setDate(String string2, Date date, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public Date getDate(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Date getDate(String string2, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTime(String string2, Time time) throws SQLException {
        throw Util.notImplemented();
    }

    public Time getTime(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Time getTime(String string2, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTime(String string2, Time time, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTimestamp(String string2, Timestamp timestamp) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTimestamp(String string2, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public Timestamp getTimestamp(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Timestamp getTimestamp(String string2, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setAsciiStream(String string2, InputStream inputStream, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBinaryStream(String string2, InputStream inputStream, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setCharacterStream(String string2, Reader reader, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setObject(String string2, Object object, int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String string2, Map map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(string2);
    }

    public void setObject(String string2, Object object, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setObject(String string2, Object object) throws SQLException {
        throw Util.notImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkStatus();
        switch (this.getParms().getParameterMode(n)) {
            case 0: 
            case 1: {
                throw this.newSQLException("XCL26.S", Integer.toString(n));
            }
        }
        Reader reader = null;
        int n2 = this.getParameterJDBCType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                Object object;
                boolean bl = false;
                Object object2 = object = this.getConnectionSynchronization();
                synchronized (object2) {
                    try {
                        StringDataValue stringDataValue = (StringDataValue)this.getParms().getParameterForGet(n - 1);
                        if (stringDataValue.isNull()) {
                            break;
                        }
                        bl = true;
                        this.setupContextStack();
                        if (stringDataValue.hasStream()) {
                            CharacterStreamDescriptor characterStreamDescriptor = stringDataValue.getStreamWithDescriptor();
                            reader = new UTF8Reader(characterStreamDescriptor, this, object);
                        } else {
                            reader = new StringReader(stringDataValue.getString());
                        }
                    }
                    catch (Throwable throwable) {
                        throw EmbedResultSet.noStateChangeException(throwable);
                    }
                    finally {
                        if (bl) {
                            this.restoreContextStack();
                        }
                    }
                    break;
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n);
                    if (inputStream == null) break;
                    reader = new InputStreamReader(inputStream, "UTF-16BE");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw this.newSQLException(unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw this.newSQLException("22005", "java.io.Reader", Util.typeName(n2));
            }
        }
        this.wasNull = reader == null;
        return reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getBinaryStream(int n) throws SQLException {
        int n2 = this.getParameterJDBCType(n);
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw this.newSQLException("22005", "java.io.InputStream", Util.typeName(n2));
            }
        }
        boolean bl = false;
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                bl = true;
                this.setupContextStack();
                InputStream inputStream = dataValueDescriptor.hasStream() ? new BinaryToRawStream(dataValueDescriptor.getStream(), dataValueDescriptor) : new ByteArrayInputStream(dataValueDescriptor.getBytes());
                InputStream inputStream2 = inputStream;
                return inputStream2;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }
}

