/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.EngineParameterMetaData;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedParameterSetMetaData;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;

public class EmbedPreparedStatement
extends EmbedStatement
implements EnginePreparedStatement {
    protected ResultSetMetaData rMetaData;
    private String gcDuringGetMetaData;
    protected org.apache.derby.iapi.sql.PreparedStatement preparedStatement;
    private Activation activation;
    private Boolean usePreTenFiveHdrFormat;
    private BrokeredConnectionControl bcc = null;

    public EmbedPreparedStatement(EmbedConnection embedConnection, String string2, boolean bl, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws SQLException {
        super(embedConnection, bl, n, n2, n3);
        this.isPoolable = true;
        if (string2 == null) {
            throw this.newSQLException("XJ067.S");
        }
        this.SQLText = string2;
        try {
            this.preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), string2, n2 == 1007, bl);
            this.addWarning(this.preparedStatement.getCompileTimeWarnings());
            this.activation = this.preparedStatement.getActivation(this.lcc, n == 1004);
            this.checkRequiresCallableStatement(this.activation);
            if (n4 == 1) {
                this.activation.setAutoGeneratedKeysResultsetInfo(nArray, stringArray);
            }
            InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.activation != null) {
            this.activation.markUnused();
        }
    }

    public final boolean execute(String string2) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String)");
    }

    public final boolean execute(String string2, int n) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int)");
    }

    public final boolean execute(String string2, int[] nArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int[])");
    }

    public final boolean execute(String string2, String[] stringArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, String[])");
    }

    public final ResultSet executeQuery(String string2) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeQuery(String)");
    }

    public final int executeUpdate(String string2) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String)");
    }

    public final int executeUpdate(String string2, int n) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int)");
    }

    public final int executeUpdate(String string2, int[] nArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int[])");
    }

    public final int executeUpdate(String string2, String[] stringArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, String[])");
    }

    public final void addBatch(String string2) throws SQLException {
        throw this.newSQLException("XJ016.S", "addBatch(String)");
    }

    void closeActions() throws SQLException {
        if (this.bcc != null) {
            PreparedStatement preparedStatement = (PreparedStatement)((Object)this.applicationStatement);
            this.bcc.onStatementClose(preparedStatement);
        }
        this.preparedStatement = null;
        try {
            this.setupContextStack();
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            this.activation.close();
            this.activation = null;
            InterruptStatus.restoreIntrFlagIfSeen();
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
        finally {
            this.restoreContextStack();
        }
    }

    public final ResultSet executeQuery() throws SQLException {
        try {
            this.executeStatement(this.activation, true, false);
        }
        catch (SQLException sQLException) {
            this.checkStatementValidity(sQLException);
        }
        return this.results;
    }

    public final int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    public final long executeLargeUpdate() throws SQLException {
        try {
            this.executeStatement(this.activation, false, true);
        }
        catch (SQLException sQLException) {
            this.checkStatementValidity(sQLException);
        }
        return this.updateCount;
    }

    public void setNull(int n, int n2) throws SQLException {
        Util.checkForSupportedDataType(n2);
        this.checkStatus();
        int n3 = this.getParameterJDBCType(n);
        if (!DataTypeDescriptor.isJDBCTypeEquivalent(n3, n2)) {
            throw this.dataTypeConversion(n, Util.typeName(n2));
        }
        try {
            this.getParms().getParameterForSet(n - 1).setToNull();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(bl);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(by);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(s);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(n2);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(l);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setBigDecimal(bigDecimal);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(f);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(d);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setString(int n, String string2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(string2);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(byArray);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public final void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkAsciiStreamConditions(n);
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.setCharacterStreamInternal(n, inputStreamReader, false, l);
    }

    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Util.notImplemented("setUnicodeStream");
    }

    public final void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkCharacterStreamConditions(n);
        this.setCharacterStreamInternal(n, reader, false, l);
    }

    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    private final void checkCharacterStreamConditions(int n) throws SQLException {
        this.checkStatus();
        int n2 = this.getParameterJDBCType(n);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(n2)) {
            throw this.dataTypeConversion(n, "java.io.Reader");
        }
    }

    private final void checkAsciiStreamConditions(int n) throws SQLException {
        this.checkStatus();
        int n2 = this.getParameterJDBCType(n);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(n2)) {
            throw this.dataTypeConversion(n, "java.io.InputStream(ASCII)");
        }
    }

    private void setCharacterStreamInternal(int n, Reader reader, boolean bl, long l) throws SQLException {
        if (!bl && l < 0L) {
            throw this.newSQLException("XJ025.S");
        }
        int n2 = this.getParameterJDBCType(n);
        if (reader == null) {
            this.setNull(n, n2);
            return;
        }
        if (!bl && l > Integer.MAX_VALUE) {
            throw this.newSQLException("22003", this.getParameterSQLType(n));
        }
        try {
            ReaderToUTF8Stream readerToUTF8Stream;
            StringDataValue stringDataValue = (StringDataValue)this.getParms().getParameter(n - 1);
            stringDataValue.setStreamHeaderFormat(this.usePreTenFiveHdrFormat());
            DataTypeDescriptor[] dataTypeDescriptorArray = this.preparedStatement.getParameterTypes();
            int n3 = dataTypeDescriptorArray[n - 1].getMaximumWidth();
            int n4 = -1;
            if (!bl) {
                n4 = (int)l;
                int n5 = 0;
                if (n2 == 2005 && n4 > n3) {
                    n5 = n4 - n3;
                    n4 = n3;
                }
                readerToUTF8Stream = new ReaderToUTF8Stream(reader, n4, n5, this.getParameterSQLType(n), stringDataValue.getStreamHeaderGenerator());
            } else {
                readerToUTF8Stream = new ReaderToUTF8Stream(reader, n3, this.getParameterSQLType(n), stringDataValue.getStreamHeaderGenerator());
            }
            this.getParms().getParameterForSet(n - 1).setValue(readerToUTF8Stream, n4);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    private Boolean usePreTenFiveHdrFormat() throws StandardException {
        if (this.usePreTenFiveHdrFormat == null) {
            this.usePreTenFiveHdrFormat = !this.lcc.getDataDictionary().checkVersion(170, null);
        }
        return this.usePreTenFiveHdrFormat;
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checkBinaryStreamConditions(n);
        this.setBinaryStreamInternal(n, inputStream, true, -1L);
    }

    public final void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkBinaryStreamConditions(n);
        this.setBinaryStreamInternal(n, inputStream, false, l);
    }

    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    private void setBinaryStreamInternal(int n, InputStream inputStream, boolean bl, long l) throws SQLException {
        if (!bl && l < 0L) {
            throw this.newSQLException("XJ025.S");
        }
        int n2 = this.getParameterJDBCType(n);
        if (inputStream == null) {
            this.setNull(n, n2);
            return;
        }
        if (!bl && l > Integer.MAX_VALUE) {
            throw this.newSQLException("22003", this.getEmbedParameterSetMetaData().getParameterTypeName(n));
        }
        try {
            RawToBinaryFormatStream rawToBinaryFormatStream;
            if (bl) {
                l = -1L;
                DataTypeDescriptor[] dataTypeDescriptorArray = this.preparedStatement.getParameterTypes();
                rawToBinaryFormatStream = new RawToBinaryFormatStream(inputStream, dataTypeDescriptorArray[n - 1].getMaximumWidth(), dataTypeDescriptorArray[n - 1].getTypeName());
            } else {
                rawToBinaryFormatStream = new RawToBinaryFormatStream(inputStream, (int)l);
            }
            this.getParms().getParameterForSet(n - 1).setValue(rawToBinaryFormatStream, (int)l);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    private final void checkBinaryStreamConditions(int n) throws SQLException {
        this.checkStatus();
        int n2 = this.getParameterJDBCType(n);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(n2)) {
            throw this.dataTypeConversion(n, "java.io.InputStream");
        }
    }

    public void setNull(int n, int n2, String string2) throws SQLException {
        this.setNull(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.add(this.getParms().getClone());
            this.clearParameters();
        }
    }

    boolean executeBatchElement(Object object) throws SQLException, StandardException {
        ParameterValueSet parameterValueSet = (ParameterValueSet)object;
        int n = parameterValueSet.getParameterCount();
        for (int i = 0; i < n; ++i) {
            parameterValueSet.getParameter(i).setInto(this, i + 1);
        }
        return super.executeStatement(this.activation, false, true);
    }

    public void clearParameters() throws SQLException {
        this.checkStatus();
        ParameterValueSet parameterValueSet = this.getParms();
        if (parameterValueSet != null) {
            parameterValueSet.clearParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            ExecPreparedStatement execPreparedStatement = (ExecPreparedStatement)this.preparedStatement;
            this.setupContextStack();
            try {
                GeneratedClass generatedClass = null;
                ResultDescription resultDescription = null;
                Object object2 = execPreparedStatement;
                synchronized (object2) {
                    while (true) {
                        if (!execPreparedStatement.upToDate()) {
                            execPreparedStatement.rePrepare(this.lcc);
                            continue;
                        }
                        generatedClass = execPreparedStatement.getActivationClass();
                        resultDescription = execPreparedStatement.getResultDescription();
                        if (generatedClass != null) break;
                    }
                }
                if (this.gcDuringGetMetaData == null || !this.gcDuringGetMetaData.equals(generatedClass.getName())) {
                    this.rMetaData = null;
                    this.gcDuringGetMetaData = generatedClass.getName();
                }
                if (this.rMetaData == null && resultDescription != null) {
                    object2 = resultDescription.getStatementType();
                    this.rMetaData = ((String)object2).equals("INSERT") || ((String)object2).equals("UPDATE") || ((String)object2).equals("DELETE") ? null : this.newEmbedResultSetMetaData(resultDescription);
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
        return this.rMetaData;
    }

    public final void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        Util.checkForSupportedDataType(n2);
        int n4 = this.getParameterJDBCType(n);
        if (n4 != 2000 && !DataTypeDescriptor.isJDBCTypeEquivalent(n4, n2)) {
            throw this.dataTypeConversion(n, Util.typeName(n2));
        }
        this.setObject(n, object);
        if (n4 == 3 || n4 == 2) {
            this.setScale(n, n3);
        }
    }

    public final void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public final void setObject(int n, Object object) throws SQLException {
        this.checkStatus();
        int n2 = this.getParameterJDBCType(n);
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        if (n2 == 2000) {
            try {
                this.getParms().setParameterAsObject(n - 1, object);
                return;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
        }
        if (object instanceof String) {
            this.setString(n, (String)object);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
            return;
        }
        if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
            return;
        }
        if (object instanceof Short) {
            this.setShort(n, (Short)object);
            return;
        }
        if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.setLong(n, (Long)object);
            return;
        }
        if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.setDouble(n, (Double)object);
            return;
        }
        if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.setTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
            return;
        }
        if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
            return;
        }
        if (object instanceof java.util.Date) {
            this.setTimestamp(n, new Timestamp(((java.util.Date)object).getTime()));
            return;
        }
        if (object instanceof Calendar) {
            this.setTimestamp(n, new Timestamp(((Calendar)object).getTime().getTime()));
            return;
        }
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
            return;
        }
        if (object instanceof BigInteger) {
            this.setBigDecimal(n, new BigDecimal((BigInteger)object));
            return;
        }
        throw this.dataTypeConversion(n, object.getClass().getName());
    }

    public final boolean execute() throws SQLException {
        boolean bl = false;
        try {
            bl = this.executeStatement(this.activation, false, false);
        }
        catch (SQLException sQLException) {
            this.checkStatementValidity(sQLException);
        }
        return bl;
    }

    public final void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(date, calendar);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(time, calendar);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(timestamp, calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkBlobConditions(n);
        if (blob == null) {
            this.setNull(n, 2004);
        } else {
            long l = blob.length();
            this.setBinaryStreamInternal(n, blob.getBinaryStream(), false, l);
        }
    }

    private final void checkClobConditions(int n) throws SQLException {
        this.checkStatus();
        if (this.getParameterJDBCType(n) != 2005) {
            throw this.dataTypeConversion(n, "java.sql.Clob");
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkClobConditions(n);
        if (clob == null) {
            this.setNull(n, 2005);
        } else {
            long l = clob.length();
            this.setCharacterStreamInternal(n, clob.getCharacterStream(), false, l);
        }
    }

    public final ParameterValueSet getParms() {
        return this.activation.getParameterValueSet();
    }

    protected final DataTypeDescriptor[] getTypes(int n) throws SQLException {
        DataTypeDescriptor[] dataTypeDescriptorArray = this.preparedStatement.getParameterTypes();
        if (dataTypeDescriptorArray == null) {
            throw this.newSQLException("07009");
        }
        if (n < 1 || n > dataTypeDescriptorArray.length) {
            throw this.newSQLException("XCL13.S", new Integer(n), new Integer(dataTypeDescriptorArray.length));
        }
        return dataTypeDescriptorArray;
    }

    protected int getParameterJDBCType(int n) throws SQLException {
        DataTypeDescriptor[] dataTypeDescriptorArray = this.getTypes(n);
        int n2 = dataTypeDescriptorArray[n - 1] == null ? 1111 : dataTypeDescriptorArray[n - 1].getTypeId().getJDBCTypeId();
        return n2;
    }

    protected final String getParameterSQLType(int n) throws SQLException {
        DataTypeDescriptor[] dataTypeDescriptorArray = this.getTypes(n);
        return dataTypeDescriptorArray[n - 1].getTypeName();
    }

    private void setScale(int n, int n2) throws SQLException {
        this.checkStatus();
        if (n2 < 0) {
            throw this.newSQLException("XJ044.S", new Integer(n2));
        }
        try {
            ParameterValueSet parameterValueSet = this.getParms();
            DataValueDescriptor dataValueDescriptor = parameterValueSet.getParameter(n - 1);
            int n3 = dataValueDescriptor.getLength();
            ((VariableSizeDataValue)((Object)dataValueDescriptor)).setWidth(-1, n2, false);
            if (dataValueDescriptor.getLength() < n3) {
                this.activation.addWarning(StandardException.newWarning("01505", dataValueDescriptor.getString()));
            }
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    private EngineParameterMetaData getEmbedParameterSetMetaData() throws SQLException {
        this.checkExecStatus();
        return new EmbedParameterSetMetaData(this.getParms(), this.preparedStatement.getParameterTypes());
    }

    public final void setURL(int n, URL uRL) throws SQLException {
        throw Util.notImplemented();
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDescription) {
        return this.factory.newEmbedResultSetMetaData(resultDescription.getColumnInfo());
    }

    public String toString() {
        if (this.activation != null) {
            return this.activation.getPreparedStatement().getObjectName();
        }
        return super.toString();
    }

    public void transferParameters(EmbedPreparedStatement embedPreparedStatement) throws SQLException {
        try {
            embedPreparedStatement.activation.setParameters(this.getParms(), this.preparedStatement.getParameterTypes());
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        this.checkExecStatus();
        this.checkIfInMiddleOfBatch();
        this.clearResultSets();
        return super.executeStatement(activation, bl, bl2);
    }

    final SQLException dataTypeConversion(int n, String string2) throws SQLException {
        SQLException sQLException = this.newSQLException("22005", this.getEmbedParameterSetMetaData().getParameterTypeName(n), string2);
        return sQLException;
    }

    public void setBrokeredConnectionControl(BrokeredConnectionControl brokeredConnectionControl) {
        this.bcc = brokeredConnectionControl;
    }

    private void checkStatementValidity(SQLException sQLException) throws SQLException {
        if (this.bcc != null && this.isClosed()) {
            this.bcc.onStatementErrorOccurred((PreparedStatement)((Object)this.applicationStatement), sQLException);
        }
        throw sQLException;
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.checkAsciiStreamConditions(n);
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.setCharacterStreamInternal(n, inputStreamReader, true, -1L);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.checkCharacterStreamConditions(n);
        this.setCharacterStreamInternal(n, reader, true, -1L);
    }

    public void setClob(int n, Reader reader) throws SQLException {
        this.checkClobConditions(n);
        this.setCharacterStreamInternal(n, reader, true, -1L);
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.checkClobConditions(n);
        this.setCharacterStreamInternal(n, reader, false, l);
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.checkBlobConditions(n);
        this.setBinaryStreamInternal(n, inputStream, true, -1L);
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checkBlobConditions(n);
        this.setBinaryStreamInternal(n, inputStream, false, l);
    }

    private final void checkBlobConditions(int n) throws SQLException {
        this.checkStatus();
        if (this.getParameterJDBCType(n) != 2004) {
            throw this.dataTypeConversion(n, "java.sql.Blob");
        }
    }

    public final long getVersionCounter() throws SQLException {
        return this.preparedStatement.getVersionCounter();
    }
}

