/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.Level2CostEstimateImpl;
import org.apache.derby.impl.sql.compile.OptimizerImpl;

public class Level2OptimizerImpl
extends OptimizerImpl {
    private LanguageConnectionContext lcc;

    Level2OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, boolean bl, boolean bl2, boolean bl3, int n, JoinStrategy[] joinStrategyArray, int n2, RequiredRowOrdering requiredRowOrdering, int n3, LanguageConnectionContext languageConnectionContext) throws StandardException {
        super(optimizableList, optimizablePredicateList, dataDictionary, bl, bl2, bl3, n, joinStrategyArray, n2, requiredRowOrdering, n3);
        this.optimizerTrace = languageConnectionContext.getOptimizerTrace();
        this.optimizerTraceHtml = languageConnectionContext.getOptimizerTraceHtml();
        this.lcc = languageConnectionContext;
        if (this.optimizerTrace) {
            this.trace(1, 0, 0, 0.0, null);
        }
    }

    public int getLevel() {
        return 2;
    }

    public CostEstimate newCostEstimate() {
        return new Level2CostEstimateImpl();
    }

    public CostEstimateImpl getNewCostEstimate(double d, double d2, double d3) {
        return new Level2CostEstimateImpl(d, d2, d3);
    }

    public void trace(int n, int n2, int n3, double d, Object object) {
        String string2 = null;
        if (!this.optimizerTrace) {
            return;
        }
        switch (n) {
            case 1: {
                string2 = "Optimization started at time " + this.timeOptimizationStarted + " using optimizer " + this.hashCode();
                break;
            }
            case 2: {
                string2 = "Optimization time exceeded at time " + this.currentTime + "\n" + this.bestCost();
                break;
            }
            case 3: {
                string2 = "No tables to optimize.";
                break;
            }
            case 4: {
                string2 = "We have a complete join order.";
                break;
            }
            case 5: {
                string2 = "Cost of sorting is " + this.sortCost;
                break;
            }
            case 6: {
                string2 = "No best plan found.";
                break;
            }
            case 7: {
                string2 = "Modifying access paths using optimizer " + this.hashCode();
                break;
            }
            case 8: {
                String string3 = this.timeExceeded ? "time exceeded" : "cost";
                Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
                if (optimizable.getBestAccessPath().getCostEstimate() == null) {
                    string3 = "no best plan found";
                }
                string2 = "Short circuiting based on " + string3 + " at join position " + this.joinPosition;
                break;
            }
            case 9: {
                string2 = this.buildJoinOrder("\n\nSkipping join order: ", true, n2, this.proposedJoinOrder);
                break;
            }
            case 10: {
                string2 = "User specified join order is not legal.";
                break;
            }
            case 11: {
                string2 = "User-specified join order has now been optimized.";
                break;
            }
            case 12: {
                string2 = this.buildJoinOrder("\n\nConsidering join order: ", false, n2, this.proposedJoinOrder);
                break;
            }
            case 13: {
                string2 = "Total cost of non-sort-avoidance plan is " + this.currentCost;
                break;
            }
            case 14: {
                string2 = "Total cost of sort avoidance plan is " + this.currentSortAvoidanceCost;
                break;
            }
            case 15: {
                string2 = "Total cost of non-sort-avoidance plan with sort cost added is " + this.currentCost;
                break;
            }
            case 16: {
                string2 = "Current plan is a sort avoidance plan.\n\tBest cost is : " + this.bestCost + "\n\tThis cost is : " + this.currentSortAvoidanceCost;
                break;
            }
            case 17: {
                string2 = "This is the cheapest plan so far.";
                break;
            }
            case 18: {
                string2 = "Plan is a " + (n2 == 1 ? "normal" : "sort avoidance") + " plan.";
                break;
            }
            case 19: {
                string2 = "Cost of cheapest plan is " + this.currentCost;
                break;
            }
            case 20: {
                string2 = "Sort needed for ordering: " + (n2 != 2) + "\n\tRow ordering: " + this.requiredRowOrdering;
                break;
            }
            case 21: {
                string2 = this.buildJoinOrder("\n\nRemembering join order as best: ", false, n2, this.bestJoinOrder);
                break;
            }
            case 22: {
                string2 = "Skipping access path due to excess memory usage, maximum is " + this.maxMemoryPerTable;
                break;
            }
            case 23: {
                string2 = "Cost of " + d + " scans is: " + object + " for table " + n2;
                break;
            }
            case 24: {
                string2 = "Skipping HASH JOIN because optimizable is not materializable";
                break;
            }
            case 25: {
                string2 = "Skipping HASH JOIN because there are no hash key columns";
                break;
            }
            case 26: {
                int[] nArray = (int[])object;
                string2 = "# hash key columns = " + nArray.length;
                for (int i = 0; i < nArray.length; ++i) {
                    string2 = "\n" + string2 + "hashKeyColumns[" + i + "] = " + nArray[i];
                }
                break;
            }
            case 27: {
                string2 = "Calling optimizeIt() for join node";
                break;
            }
            case 28: {
                JoinStrategy joinStrategy = (JoinStrategy)object;
                string2 = "\nConsidering join strategy " + joinStrategy + " for table " + n2;
                break;
            }
            case 29: {
                string2 = "Remembering access path " + object + " as truly the best for table " + n2 + " for plan type " + (n3 == 1 ? " normal " : "sort avoidance") + "\n";
                break;
            }
            case 30: {
                string2 = "No more conglomerates to consider for table " + n2;
                break;
            }
            case 31: {
                ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)object;
                String string4 = this.dumpConglomerateDescriptor(conglomerateDescriptor);
                string2 = "\nConsidering conglomerate " + string4 + " for table " + n2;
                break;
            }
            case 32: {
                string2 = "Scanning heap, but we have a full match on a unique key.";
                break;
            }
            case 33: {
                string2 = "Adding unordered optimizable, # of predicates = " + n2;
                break;
            }
            case 34: {
                string2 = "Changing access path for table " + n2;
                break;
            }
            case 35: {
                string2 = "Lock mode set to MODE_TABLE because no start or stop position";
                break;
            }
            case 36: {
                string2 = "Index does not cover query - cost including base row fetch is: " + d + " for table " + n2;
                break;
            }
            case 37: {
                string2 = "Lock mode set to MODE_RECORD because all start and stop positions are constant";
                break;
            }
            case 38: {
                ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)object;
                String string5 = this.dumpConglomerateDescriptor(conglomerateDescriptor);
                string2 = "Estimating cost of conglomerate: " + this.costForTable(string5, n2);
                break;
            }
            case 39: {
                string2 = "Looking for user-specified index: " + object + " for table " + n2;
                break;
            }
            case 40: {
                string2 = "Guaranteed to match a single row - cost is: " + d + " for table " + n2;
                break;
            }
            case 41: {
                string2 = this.costIncluding("1st column", object, n2);
                string2 = "Cost including extra first column selectivity is : " + object + " for table " + n2;
                break;
            }
            case 42: {
                string2 = "Calling nextAccessPath() for base table " + object + " with " + n2 + " predicates.";
                break;
            }
            case 43: {
                string2 = this.lockModeThreshold("MODE_TABLE", "greater", d, n2);
                break;
            }
            case 44: {
                string2 = this.lockModeThreshold("MODE_RECORD", "less", d, n2);
                break;
            }
            case 45: {
                string2 = this.costIncluding("start/stop", object, n2);
                break;
            }
            case 46: {
                string2 = this.costIncluding("qualifier", object, n2);
                break;
            }
            case 47: {
                string2 = this.costIncluding("non-qualifier", object, n2);
                break;
            }
            case 60: {
                string2 = this.costIncluding("selectivity from statistics", object, n2);
                break;
            }
            case 62: {
                string2 = this.costIncluding("statistics for index being considered", object, n2);
                break;
            }
            case 61: {
                string2 = "Selectivity from statistics found. It is " + d;
                break;
            }
            case 48: {
                string2 = "Index does not cover query: cost including row fetch is: " + this.costForTable(object, n2);
                break;
            }
            case 49: {
                string2 = "\nRemembering join strategy " + object + " as best for table " + n2;
                break;
            }
            case 50: {
                string2 = "in best access path";
                break;
            }
            case 51: {
                string2 = "in best sort avoidance access path";
                break;
            }
            case 52: {
                string2 = "in best unknown access path";
                break;
            }
            case 53: {
                ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)object;
                String string6 = this.dumpConglomerateDescriptor(conglomerateDescriptor);
                string2 = "Cost of conglomerate " + string6 + " scan for table number " + n2 + " is : ";
                break;
            }
            case 54: {
                string2 = object.toString();
                break;
            }
            case 55: {
                string2 = "\tNumber of extra first column predicates is : " + n2 + ", extra first column selectivity is : " + d;
                break;
            }
            case 56: {
                string2 = "\tNumber of extra start/stop predicates is : " + n2 + ", extra start/stop selectivity is : " + d;
                break;
            }
            case 57: {
                string2 = "\tNumber of extra qualifiers is : " + n2 + ", extra qualifier selectivity is : " + d;
                break;
            }
            case 58: {
                string2 = "\tNumber of extra non-qualifiers is : " + n2 + ", extra non-qualifier selectivity is : " + d;
                break;
            }
            case 59: {
                string2 = "\tNumber of start/stop statistics predicates is : " + n2 + ", statistics start/stop selectivity is : " + d;
            }
        }
        this.lcc.appendOptimizerTraceOutput(string2 + "\n");
    }

    private String costForTable(Object object, int n) {
        return object + " for table " + n;
    }

    private String bestCost() {
        return "Best cost = " + this.bestCost + "\n";
    }

    private String buildJoinOrder(String string2, boolean bl, int n, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        for (int i = 0; i <= this.joinPosition; ++i) {
            stringBuffer.append(" ").append(nArray[i]);
        }
        if (bl) {
            stringBuffer.append(" ").append(n);
        }
        stringBuffer.append(" with assignedTableMap = ").append(this.assignedTableMap).append("\n\n");
        return stringBuffer.toString();
    }

    private String lockModeThreshold(String string2, String string3, double d, int n) {
        return "Lock mode set to " + string2 + " because estimated row count of " + d + " " + string3 + " than threshold of " + n;
    }

    private String costIncluding(String string2, Object object, int n) {
        return "Cost including extra " + string2 + " start/stop selectivity is : " + this.costForTable(object, n);
    }

    private String dumpConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor) {
        String string2 = "";
        String[] stringArray = conglomerateDescriptor.getColumnNames();
        if (conglomerateDescriptor.isIndex() && stringArray != null) {
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            int[] nArray = indexRowGenerator.baseColumnPositions();
            string2 = ", key columns = {" + stringArray[nArray[0] - 1];
            for (int i = 1; i < nArray.length; ++i) {
                string2 = string2 + ", " + stringArray[nArray[i] - 1];
            }
            string2 = string2 + "}";
        }
        return "CD: conglomerateNumber = " + conglomerateDescriptor.getConglomerateNumber() + " name = " + conglomerateDescriptor.getConglomerateName() + " uuid = " + conglomerateDescriptor.getUUID() + " indexable = " + conglomerateDescriptor.isIndex() + string2;
    }
}

