/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.MaterializeSubqueryNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class SubqueryNode
extends ValueNode {
    ResultSetNode resultSet;
    int subqueryType;
    boolean underTopAndNode;
    boolean preprocessed;
    boolean distinctExpression;
    boolean whereSubquery;
    ValueNode leftOperand;
    boolean pushedNewPredicate;
    boolean havingSubquery = false;
    BinaryComparisonOperatorNode parentComparisonOperator;
    private BooleanConstantNode trueNode;
    private int subqueryNumber = -1;
    private int pointOfAttachment = -1;
    private boolean foundCorrelation;
    private boolean doneCorrelationCheck;
    private boolean foundVariant;
    private boolean doneInvariantCheck;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    public static final int NOTIMPLEMENTED_SUBQUERY = -1;
    public static final int FROM_SUBQUERY = 0;
    public static final int IN_SUBQUERY = 1;
    public static final int NOT_IN_SUBQUERY = 2;
    public static final int EQ_ANY_SUBQUERY = 3;
    public static final int EQ_ALL_SUBQUERY = 4;
    public static final int NE_ANY_SUBQUERY = 5;
    public static final int NE_ALL_SUBQUERY = 6;
    public static final int GT_ANY_SUBQUERY = 7;
    public static final int GT_ALL_SUBQUERY = 8;
    public static final int GE_ANY_SUBQUERY = 9;
    public static final int GE_ALL_SUBQUERY = 10;
    public static final int LT_ANY_SUBQUERY = 11;
    public static final int LT_ALL_SUBQUERY = 12;
    public static final int LE_ANY_SUBQUERY = 13;
    public static final int LE_ALL_SUBQUERY = 14;
    public static final int EXISTS_SUBQUERY = 15;
    public static final int NOT_EXISTS_SUBQUERY = 16;
    public static final int EXPRESSION_SUBQUERY = 17;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.resultSet = (ResultSetNode)object;
        this.subqueryType = (Integer)object2;
        this.orderByList = (OrderByList)object4;
        this.offset = (ValueNode)object5;
        this.fetchFirst = (ValueNode)object6;
        this.hasJDBClimitClause = object7 == null ? false : (Boolean)object7;
        this.underTopAndNode = false;
        this.leftOperand = (ValueNode)object3;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getResultSet() {
        return this.resultSet;
    }

    public int getSubqueryType() {
        return this.subqueryType;
    }

    public void setSubqueryType(int n) {
        this.subqueryType = n;
    }

    public void setPointOfAttachment(int n) throws StandardException {
        if (!this.isMaterializable()) {
            this.pointOfAttachment = n;
        }
    }

    public boolean getUnderTopAndNode() {
        return this.underTopAndNode;
    }

    public int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    boolean getPreprocessed() {
        return this.preprocessed;
    }

    void setParentComparisonOperator(BinaryComparisonOperatorNode binaryComparisonOperatorNode) {
        this.parentComparisonOperator = binaryComparisonOperatorNode;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.resultSet instanceof SelectNode) {
            ResultColumnList resultColumnList = this.resultSet.getResultColumns();
            SelectNode selectNode = (SelectNode)this.resultSet;
            PredicateList predicateList = selectNode.getWherePredicates();
            resultColumnList.remapColumnReferencesToExpressions();
            predicateList.remapColumnReferencesToExpressions();
        }
        return this;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        this.checkReliability(32, "42Z91");
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        if (this.subqueryType != 15 && resultColumnList.visibleSize() != 1) {
            throw StandardException.newException("42X39");
        }
        this.resultSet.verifySelectStarSubquery(fromList, this.subqueryType);
        if (this.subqueryType == 15) {
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(true);
        }
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.pushCurrentPrivType(0);
        this.resultSet = this.resultSet.bindNonVTITables(this.getDataDictionary(), fromList);
        this.resultSet = this.resultSet.bindVTITables(fromList);
        if (this.subqueryNumber == -1) {
            this.subqueryNumber = compilerContext.getNextSubqueryNumber();
        }
        this.resultSet.rejectParameters();
        if (this.subqueryType == 15) {
            this.resultSet.bindTargetExpressions(fromList);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(false);
        }
        if (this.leftOperand != null) {
            this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, list);
        }
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.resultSet.bindExpressions(fromList);
        this.resultSet.bindResultColumns(fromList);
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        SubqueryNode.bindOffsetFetch(this.offset, this.fetchFirst);
        this.resultSet.bindUntypedNullsToResultColumns(null);
        resultColumnList = this.resultSet.getResultColumns();
        if (this.leftOperand != null && this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(((ResultColumn)resultColumnList.elementAt(0)).getTypeServices());
        }
        this.setDataTypeServices(resultColumnList);
        subqueryList.addSubqueryNode(this);
        compilerContext.popCurrentPrivType();
        return this;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        SelectNode selectNode;
        boolean bl;
        if (this.preprocessed) {
            return this;
        }
        this.preprocessed = true;
        ValueNode valueNode = this;
        this.resultSet = this.resultSet.preprocess(n, null, null);
        if (this.leftOperand != null) {
            this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        }
        if (this.resultSet instanceof SelectNode && ((SelectNode)this.resultSet).hasDistinct()) {
            ((SelectNode)this.resultSet).clearDistinct();
            if (this.subqueryType == 17) {
                this.distinctExpression = true;
            }
        }
        if ((this.isIN() || this.isANY()) && this.resultSet.returnsAtMostOneRow() && !this.hasCorrelatedCRs()) {
            this.changeToCorrespondingExpressionType();
        }
        boolean bl2 = bl = this.resultSet instanceof RowResultSetNode && this.underTopAndNode && !this.havingSubquery && this.orderByList == null && this.offset == null && this.fetchFirst == null && !this.isWhereExistsAnyInWithWhereSubquery() && this.parentComparisonOperator != null;
        if (bl) {
            this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            RowResultSetNode rowResultSetNode = (RowResultSetNode)this.resultSet;
            FromList fromList2 = new FromList();
            subqueryList.removeElement(this);
            if (rowResultSetNode.subquerys.size() != 0) {
                fromList2.addElement(rowResultSetNode);
                fromList.destructiveAppend(fromList2);
            }
            subqueryList.destructiveAppend(rowResultSetNode.subquerys);
            return this.getNewJoinCondition(this.leftOperand, this.getRightOperand());
        }
        boolean bl3 = this.isNOT_EXISTS() || this.canAllBeFlattened();
        boolean bl4 = bl = this.resultSet instanceof SelectNode && !((SelectNode)this.resultSet).hasWindows() && this.orderByList == null && this.offset == null && this.fetchFirst == null && this.underTopAndNode && !this.havingSubquery && !this.isWhereExistsAnyInWithWhereSubquery() && (this.isIN() || this.isANY() || this.isEXISTS() || bl3 || this.parentComparisonOperator != null);
        if (bl && !(selectNode = (SelectNode)this.resultSet).hasAggregatesInSelectList() && selectNode.havingClause == null) {
            FromBaseTable fromBaseTable;
            ValueNode valueNode2 = this.leftOperand;
            boolean bl5 = this.subqueryType == 1 || this.subqueryType == 3;
            boolean bl6 = bl5 = bl5 && (this.leftOperand instanceof ConstantNode || this.leftOperand instanceof ColumnReference || this.leftOperand.requiresTypeFromContext());
            if (this.parentComparisonOperator != null) {
                this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            }
            if (!bl3 && selectNode.uniqueSubquery(bl5)) {
                return this.flattenToNormalJoin(n, fromList, subqueryList, predicateList);
            }
            if ((this.isIN() || this.isANY() || this.isEXISTS() || bl3) && (this.leftOperand == null || this.leftOperand.categorize(new JBitSet(n), false)) && selectNode.getWherePredicates().allPushable() && (fromBaseTable = this.singleFromBaseTable(selectNode.getFromList())) != null && (!bl3 || selectNode.getWherePredicates().allReference(fromBaseTable) && this.rightOperandFlattenableToNotExists(n, fromBaseTable))) {
                return this.flattenToExistsJoin(n, fromList, subqueryList, predicateList, bl3);
            }
            this.leftOperand = valueNode2;
        }
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        if (this.leftOperand != null) {
            valueNode = this.pushNewPredicate(n);
            this.pushedNewPredicate = true;
        } else if (this.isEXISTS() || this.isNOT_EXISTS()) {
            valueNode = this.genIsNullTree(this.isEXISTS());
            this.subqueryType = 15;
        }
        this.isInvariant();
        this.hasCorrelatedCRs();
        if (this.parentComparisonOperator != null) {
            this.parentComparisonOperator.setRightOperand(valueNode);
            return this.parentComparisonOperator;
        }
        return valueNode;
    }

    private FromBaseTable singleFromBaseTable(FromList fromList) {
        FromBaseTable fromBaseTable = null;
        if (fromList.size() == 1) {
            ResultSetNode resultSetNode;
            FromTable fromTable = (FromTable)fromList.elementAt(0);
            if (fromTable instanceof FromBaseTable) {
                fromBaseTable = (FromBaseTable)fromTable;
            } else if (fromTable instanceof ProjectRestrictNode && (resultSetNode = ((ProjectRestrictNode)fromTable).getChildResult()) instanceof FromBaseTable) {
                fromBaseTable = (FromBaseTable)resultSetNode;
            }
        }
        return fromBaseTable;
    }

    private boolean rightOperandFlattenableToNotExists(int n, FromBaseTable fromBaseTable) throws StandardException {
        boolean bl = true;
        if (this.leftOperand != null) {
            JBitSet jBitSet = new JBitSet(n);
            this.getRightOperand().categorize(jBitSet, false);
            bl = jBitSet.get(fromBaseTable.getTableNumber());
        }
        return bl;
    }

    private boolean canAllBeFlattened() throws StandardException {
        boolean bl = false;
        if (this.isNOT_IN() || this.isALL()) {
            bl = !this.leftOperand.getTypeServices().isNullable() && !this.getRightOperand().getTypeServices().isNullable();
        }
        return bl;
    }

    private ValueNode flattenToNormalJoin(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        SelectNode selectNode = (SelectNode)this.resultSet;
        FromList fromList2 = selectNode.getFromList();
        int[] nArray = fromList2.getTableNumbers();
        subqueryList.removeElement(this);
        selectNode.decrementLevel(1);
        fromList.destructiveAppend(fromList2);
        predicateList.destructiveAppend(selectNode.getWherePredicates());
        subqueryList.destructiveAppend(selectNode.getWhereSubquerys());
        subqueryList.destructiveAppend(selectNode.getSelectSubquerys());
        if (this.leftOperand == null) {
            return (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        }
        ValueNode valueNode = this.getRightOperand();
        if (valueNode instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)valueNode;
            int n2 = columnReference.getTableNumber();
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 != nArray[i]) continue;
                columnReference.setSourceLevel(columnReference.getSourceLevel() - 1);
                break;
            }
        }
        return this.getNewJoinCondition(this.leftOperand, valueNode);
    }

    private ValueNode flattenToExistsJoin(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList, boolean bl) throws StandardException {
        SelectNode selectNode = (SelectNode)this.resultSet;
        selectNode.getFromList().genExistsBaseTables(this.resultSet.getReferencedTableMap(), fromList, bl);
        return this.flattenToNormalJoin(n, fromList, subqueryList, predicateList);
    }

    private ValueNode getRightOperand() {
        ResultColumn resultColumn = (ResultColumn)this.resultSet.getResultColumns().elementAt(0);
        return resultColumn.getExpression();
    }

    private boolean isInvariant() throws StandardException {
        if (this.doneInvariantCheck) {
            return !this.foundVariant;
        }
        this.doneInvariantCheck = true;
        HasVariantValueNodeVisitor hasVariantValueNodeVisitor = new HasVariantValueNodeVisitor();
        this.resultSet.accept(hasVariantValueNodeVisitor);
        this.foundVariant = hasVariantValueNodeVisitor.hasVariant();
        return !this.foundVariant;
    }

    public boolean hasCorrelatedCRs() throws StandardException {
        Object object;
        if (this.doneCorrelationCheck) {
            return this.foundCorrelation;
        }
        this.doneCorrelationCheck = true;
        ResultSetNode resultSetNode = this.resultSet;
        ResultColumnList resultColumnList = null;
        if (this.pushedNewPredicate && (resultColumnList = (resultSetNode = ((ProjectRestrictNode)this.resultSet).getChildResult()).getResultColumns()).size() > 1) {
            object = new ResultColumnList();
            ((ResultColumnList)object).addResultColumn(resultColumnList.getResultColumn(1));
            resultSetNode.setResultColumns((ResultColumnList)object);
        }
        object = new HasCorrelatedCRsVisitor();
        resultSetNode.accept((Visitor)object);
        this.foundCorrelation = ((HasCorrelatedCRsVisitor)object).hasCorrelatedCRs();
        if (this.pushedNewPredicate && resultColumnList.size() > 1) {
            resultSetNode.setResultColumns(resultColumnList);
        }
        return this.foundCorrelation;
    }

    private UnaryComparisonOperatorNode pushNewPredicate(int n) throws StandardException {
        BinaryComparisonOperatorNode binaryComparisonOperatorNode = null;
        UnaryComparisonOperatorNode unaryComparisonOperatorNode = null;
        this.resultSet = this.resultSet.ensurePredicateList(n);
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        ResultColumnList resultColumnList2 = resultColumnList.copyListAndObjects();
        resultColumnList2.genVirtualColumnNodes(this.resultSet, resultColumnList);
        this.resultSet = (ResultSetNode)this.getNodeFactory().getNode(151, this.resultSet, resultColumnList2, null, null, null, null, null, this.getContextManager());
        resultColumnList = resultColumnList2;
        ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(0);
        ValueNode valueNode = resultColumn.getExpression();
        BinaryOperatorNode binaryOperatorNode = binaryComparisonOperatorNode = this.getNewJoinCondition(this.leftOperand, valueNode);
        if (this.isNOT_IN() || this.isALL()) {
            boolean bl = this.leftOperand.getTypeServices().isNullable();
            boolean bl2 = valueNode.getTypeServices().isNullable();
            if (bl || bl2) {
                UnaryComparisonOperatorNode unaryComparisonOperatorNode2;
                BooleanConstantNode booleanConstantNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
                OrNode orNode = (OrNode)this.getNodeFactory().getNode(52, binaryComparisonOperatorNode, booleanConstantNode, this.getContextManager());
                orNode.postBindFixup();
                binaryOperatorNode = orNode;
                if (bl) {
                    unaryComparisonOperatorNode2 = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(25, this.leftOperand, this.getContextManager());
                    unaryComparisonOperatorNode2.bindComparisonOperator();
                    orNode = (OrNode)this.getNodeFactory().getNode(52, unaryComparisonOperatorNode2, binaryOperatorNode, this.getContextManager());
                    orNode.postBindFixup();
                    binaryOperatorNode = orNode;
                }
                if (bl2) {
                    unaryComparisonOperatorNode2 = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(25, valueNode, this.getContextManager());
                    unaryComparisonOperatorNode2.bindComparisonOperator();
                    orNode = (OrNode)this.getNodeFactory().getNode(52, unaryComparisonOperatorNode2, binaryOperatorNode, this.getContextManager());
                    orNode.postBindFixup();
                    binaryOperatorNode = orNode;
                }
            }
        }
        AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, binaryOperatorNode, this.getTrueNode(), this.getContextManager());
        JBitSet jBitSet = new JBitSet(n);
        andNode.postBindFixup();
        Predicate predicate = (Predicate)this.getNodeFactory().getNode(78, andNode, jBitSet, this.getContextManager());
        predicate.categorize();
        this.resultSet = this.resultSet.addNewPredicate(predicate);
        this.leftOperand = null;
        resultColumn.setType(this.getTypeServices());
        resultColumn.setExpression(this.getTrueNode());
        switch (this.subqueryType) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                unaryComparisonOperatorNode = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(24, this, this.getContextManager());
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                unaryComparisonOperatorNode = (UnaryComparisonOperatorNode)this.getNodeFactory().getNode(25, this, this.getContextManager());
            }
        }
        unaryComparisonOperatorNode.bindComparisonOperator();
        return unaryComparisonOperatorNode;
    }

    private BinaryComparisonOperatorNode getNewJoinCondition(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        int n;
        BinaryComparisonOperatorNode binaryComparisonOperatorNode = null;
        int n2 = this.subqueryType;
        if (this.subqueryType == 17) {
            n = -1;
            if (this.parentComparisonOperator.isRelationalOperator()) {
                RelationalOperator relationalOperator = (RelationalOperator)((Object)this.parentComparisonOperator);
                n = relationalOperator.getOperator();
            }
            if (n == 1) {
                n2 = 3;
            } else if (n == 2) {
                n2 = 5;
            } else if (n == 6) {
                n2 = 13;
            } else if (n == 5) {
                n2 = 11;
            } else if (n == 4) {
                n2 = 9;
            } else if (n == 3) {
                n2 = 7;
            }
        }
        n = 0;
        int n3 = 0;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n3 = 41;
                break;
            }
            case 4: 
            case 5: {
                n3 = 47;
                break;
            }
            case 8: 
            case 13: {
                n3 = 44;
                break;
            }
            case 10: 
            case 11: {
                n3 = 45;
                break;
            }
            case 9: 
            case 12: {
                n3 = 42;
                break;
            }
            case 7: 
            case 14: {
                n3 = 43;
                break;
            }
        }
        binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(n3, valueNode, valueNode2, Boolean.FALSE, this.getContextManager());
        binaryComparisonOperatorNode.bindComparisonOperator();
        return binaryComparisonOperatorNode;
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        ValueNode valueNode = this;
        if (bl) {
            switch (this.subqueryType) {
                case 17: {
                    valueNode = this.genEqualsFalseTree();
                    break;
                }
                case 15: {
                    this.subqueryType = 16;
                    break;
                }
                case 1: 
                case 3: {
                    this.subqueryType = 2;
                    break;
                }
                case 5: {
                    this.subqueryType = 4;
                    break;
                }
                case 9: {
                    this.subqueryType = 12;
                    break;
                }
                case 7: {
                    this.subqueryType = 14;
                    break;
                }
                case 13: {
                    this.subqueryType = 8;
                    break;
                }
                case 11: {
                    this.subqueryType = 10;
                    break;
                }
                case 4: {
                    this.subqueryType = 5;
                    break;
                }
                case 6: {
                    this.subqueryType = 3;
                    break;
                }
                case 10: {
                    this.subqueryType = 11;
                    break;
                }
                case 8: {
                    this.subqueryType = 13;
                    break;
                }
                case 14: {
                    this.subqueryType = 7;
                    break;
                }
                case 12: {
                    this.subqueryType = 9;
                    break;
                }
            }
        }
        return valueNode;
    }

    public ValueNode changeToCNF(boolean bl) throws StandardException {
        this.underTopAndNode = bl;
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        return this.isMaterializable();
    }

    boolean isMaterializable() throws StandardException {
        boolean bl;
        boolean bl2 = bl = this.subqueryType == 17 && !this.hasCorrelatedCRs() && this.isInvariant();
        if (bl && this.resultSet instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.resultSet;
            FromList fromList = selectNode.getFromList();
            fromList.setLevel(0);
        }
        return bl;
    }

    public void optimize(DataDictionary dataDictionary, double d) throws StandardException {
        this.resultSet = this.resultSet.optimize(dataDictionary, null, d);
    }

    public void modifyAccessPaths() throws StandardException {
        this.resultSet = this.resultSet.modifyAccessPaths();
    }

    protected int getOrderableVariantType() throws StandardException {
        if (this.isInvariant()) {
            if (!this.hasCorrelatedCRs() && this.subqueryType == 17) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        CompilerContext compilerContext = this.getCompilerContext();
        ActivationClassBuilder activationClassBuilder = (ActivationClassBuilder)expressionClassBuilder;
        String string2 = this.subqueryType == 17 ? "getOnceResultSet" : "getAnyResultSet";
        CostEstimate costEstimate = this.resultSet.getFinalCostEstimate();
        String string3 = this.getTypeCompiler().interfaceName();
        MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun(string3, 4);
        LocalField localField = activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.NoPutResultSet");
        ResultSetNode resultSetNode = null;
        if (!this.isMaterializable()) {
            MethodBuilder methodBuilder3 = activationClassBuilder.getExecuteMethod();
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                resultSetNode = ((ProjectRestrictNode)this.resultSet).getChildResult();
                LocalField localField2 = activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.NoPutResultSet");
                methodBuilder2.getField(localField2);
                methodBuilder2.conditionalIfNull();
                MaterializeSubqueryNode materializeSubqueryNode = new MaterializeSubqueryNode(localField2);
                materializeSubqueryNode.costEstimate = this.resultSet.getFinalCostEstimate();
                ((ProjectRestrictNode)this.resultSet).setChildResult(materializeSubqueryNode);
                resultSetNode.generate(activationClassBuilder, methodBuilder2);
                methodBuilder2.startElseCode();
                methodBuilder2.getField(localField2);
                methodBuilder2.completeConditional();
                methodBuilder2.setField(localField2);
                methodBuilder3.pushNull("org.apache.derby.iapi.sql.execute.NoPutResultSet");
                methodBuilder3.setField(localField2);
            }
            methodBuilder3.pushNull("org.apache.derby.iapi.sql.execute.NoPutResultSet");
            methodBuilder3.setField(localField);
            methodBuilder2.getField(localField);
            methodBuilder2.conditionalIfNull();
        }
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder2);
        this.resultSet.generate(activationClassBuilder, methodBuilder2);
        int n2 = compilerContext.getNextResultSetNumber();
        this.resultSet.getResultColumns().setResultSetNumber(n2);
        this.resultSet.getResultColumns().generateNulls(activationClassBuilder, methodBuilder2);
        if (this.subqueryType == 17) {
            int n3 = this.distinctExpression ? 3 : (this.resultSet.returnsAtMostOneRow() ? 2 : 1);
            methodBuilder2.push(n3);
            n = 8;
        } else {
            n = 7;
        }
        methodBuilder2.push(n2);
        methodBuilder2.push(this.subqueryNumber);
        methodBuilder2.push(this.pointOfAttachment);
        methodBuilder2.push(costEstimate.rowCount());
        methodBuilder2.push(costEstimate.getEstimatedCost());
        methodBuilder2.callMethod((short)185, null, string2, "org.apache.derby.iapi.sql.execute.NoPutResultSet", n);
        if (!this.isMaterializable()) {
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                ((ProjectRestrictNode)this.resultSet).setChildResult(resultSetNode);
            }
            methodBuilder2.startElseCode();
            methodBuilder2.getField(localField);
            methodBuilder2.completeConditional();
        }
        methodBuilder2.setField(localField);
        methodBuilder2.getField(localField);
        methodBuilder2.callMethod((short)185, null, "openCore", "void", 0);
        methodBuilder2.getField(localField);
        methodBuilder2.callMethod((short)185, null, "getNextRowCore", "org.apache.derby.iapi.sql.execute.ExecRow", 0);
        methodBuilder2.push(1);
        methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
        methodBuilder2.cast(string3);
        if (this.isMaterializable()) {
            methodBuilder2.getField(localField);
            methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.ResultSet", "close", "void", 0);
        }
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        if (this.isMaterializable()) {
            LocalField localField3 = this.generateMaterialization(activationClassBuilder, methodBuilder2, string3);
            methodBuilder.getField(localField3);
        } else {
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)182, null, methodBuilder2.getName(), string3, 0);
        }
    }

    private LocalField generateMaterialization(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, String string2) {
        MethodBuilder methodBuilder2 = activationClassBuilder.getExecuteMethod();
        LocalField localField = activationClassBuilder.newFieldDeclaration(2, string2);
        methodBuilder2.pushThis();
        methodBuilder2.callMethod((short)182, null, methodBuilder.getName(), string2, 0);
        methodBuilder2.setField(localField);
        return localField;
    }

    private BooleanConstantNode getTrueNode() throws StandardException {
        if (this.trueNode == null) {
            this.trueNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        }
        return this.trueNode;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (visitor instanceof HasCorrelatedCRsVisitor && this.doneCorrelationCheck) {
            ((HasCorrelatedCRsVisitor)visitor).setHasCorrelatedCRs(this.foundCorrelation);
            return;
        }
        if (this.resultSet != null) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(visitor);
        }
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
    }

    private boolean isIN() {
        return this.subqueryType == 1;
    }

    private boolean isNOT_IN() {
        return this.subqueryType == 2;
    }

    private boolean isANY() {
        switch (this.subqueryType) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean isALL() {
        switch (this.subqueryType) {
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private boolean isEXISTS() {
        return this.subqueryType == 15;
    }

    private boolean isNOT_EXISTS() {
        return this.subqueryType == 16;
    }

    private void changeToCorrespondingExpressionType() throws StandardException {
        BinaryOperatorNode binaryOperatorNode = null;
        switch (this.subqueryType) {
            case 1: 
            case 3: {
                binaryOperatorNode = (BinaryOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, this, Boolean.FALSE, this.getContextManager());
                break;
            }
            case 5: {
                binaryOperatorNode = (BinaryOperatorNode)this.getNodeFactory().getNode(47, this.leftOperand, this, Boolean.FALSE, this.getContextManager());
                break;
            }
            case 13: {
                binaryOperatorNode = (BinaryOperatorNode)this.getNodeFactory().getNode(44, this.leftOperand, this, Boolean.FALSE, this.getContextManager());
                break;
            }
            case 11: {
                binaryOperatorNode = (BinaryOperatorNode)this.getNodeFactory().getNode(45, this.leftOperand, this, Boolean.FALSE, this.getContextManager());
                break;
            }
            case 9: {
                binaryOperatorNode = (BinaryOperatorNode)this.getNodeFactory().getNode(42, this.leftOperand, this, Boolean.FALSE, this.getContextManager());
                break;
            }
            case 7: {
                binaryOperatorNode = (BinaryOperatorNode)this.getNodeFactory().getNode(43, this.leftOperand, this, Boolean.FALSE, this.getContextManager());
            }
        }
        this.subqueryType = 17;
        this.setDataTypeServices(this.resultSet.getResultColumns());
        this.parentComparisonOperator = (BinaryComparisonOperatorNode)binaryOperatorNode;
        this.parentComparisonOperator.bindComparisonOperator();
        this.leftOperand = null;
    }

    private void setDataTypeServices(ResultColumnList resultColumnList) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.subqueryType == 17 ? ((ResultColumn)resultColumnList.elementAt(0)).getTypeServices() : this.getTrueNode().getTypeServices();
        this.setType(dataTypeDescriptor.getNullabilityType(true));
    }

    protected boolean isEquivalent(ValueNode valueNode) {
        return false;
    }

    public boolean isHavingSubquery() {
        return this.havingSubquery;
    }

    public void setHavingSubquery(boolean bl) {
        this.havingSubquery = bl;
    }

    public boolean isWhereSubquery() {
        return this.whereSubquery;
    }

    public void setWhereSubquery(boolean bl) {
        this.whereSubquery = bl;
    }

    public boolean isWhereExistsAnyInWithWhereSubquery() throws StandardException {
        if (this.isWhereSubquery() && (this.isEXISTS() || this.isANY() || this.isIN())) {
            if (this.resultSet instanceof SelectNode) {
                SelectNode selectNode = (SelectNode)this.resultSet;
                if (selectNode.originalWhereClauseHadSubqueries) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    public boolean hasJDBClimitClause() {
        return this.hasJDBClimitClause;
    }
}

