/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropRoleConstantAction
extends DDLConstantAction {
    private final String roleName;

    DropRoleConstantAction(String string2) {
        this.roleName = string2;
    }

    public String toString() {
        return "DROP ROLE " + this.roleName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        String string2;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(this.roleName);
        if (roleGrantDescriptor == null) {
            throw StandardException.newException("0P000", this.roleName);
        }
        RoleClosureIterator roleClosureIterator = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), this.roleName, false);
        while ((string2 = roleClosureIterator.next()) != null) {
            RoleGrantDescriptor roleGrantDescriptor2 = dataDictionary.getRoleDefinitionDescriptor(string2);
            dataDictionary.getDependencyManager().invalidateFor(roleGrantDescriptor2, 47, languageConnectionContext);
        }
        roleGrantDescriptor.drop(languageConnectionContext);
        dataDictionary.dropRoleGrantsByGrantee(this.roleName, transactionController);
        dataDictionary.dropRoleGrantsByName(this.roleName, transactionController);
        dataDictionary.dropAllPermsByGrantee(this.roleName, transactionController);
    }
}

