/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.agg.Aggregator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class UserDefinedAggregator
implements ExecAggregator {
    private static final int FIRST_VERSION = 0;
    private Aggregator _aggregator;
    private DataTypeDescriptor _resultType;
    private boolean _eliminatedNulls;

    public void setup(ClassFactory classFactory, String string2, DataTypeDescriptor dataTypeDescriptor) {
        try {
            this.setup(classFactory.loadApplicationClass(string2), dataTypeDescriptor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logAggregatorInstantiationError(string2, classNotFoundException);
        }
    }

    private void setup(Class clazz, DataTypeDescriptor dataTypeDescriptor) {
        String string2 = clazz.getName();
        try {
            this._aggregator = (Aggregator)clazz.newInstance();
            this._aggregator.init();
        }
        catch (InstantiationException instantiationException) {
            this.logAggregatorInstantiationError(string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logAggregatorInstantiationError(string2, illegalAccessException);
        }
        this._resultType = dataTypeDescriptor;
    }

    public boolean didEliminateNulls() {
        return this._eliminatedNulls;
    }

    public void accumulate(DataValueDescriptor dataValueDescriptor, Object object) throws StandardException {
        if (dataValueDescriptor == null || dataValueDescriptor.isNull()) {
            this._eliminatedNulls = true;
            return;
        }
        Object object2 = dataValueDescriptor.getObject();
        this._aggregator.accumulate(object2);
    }

    public void merge(ExecAggregator execAggregator) throws StandardException {
        UserDefinedAggregator userDefinedAggregator = (UserDefinedAggregator)execAggregator;
        this._aggregator.merge(userDefinedAggregator._aggregator);
    }

    public DataValueDescriptor getResult() throws StandardException {
        Object r = this._aggregator.terminate();
        if (r == null) {
            return null;
        }
        DataValueDescriptor dataValueDescriptor = this._resultType.getNull();
        dataValueDescriptor.setObjectForCast(r, true, r.getClass().getName());
        return dataValueDescriptor;
    }

    public ExecAggregator newAggregator() {
        UserDefinedAggregator userDefinedAggregator = new UserDefinedAggregator();
        userDefinedAggregator.setup(this._aggregator.getClass(), this._resultType);
        return userDefinedAggregator;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this._aggregator);
        objectOutput.writeObject(this._resultType);
        objectOutput.writeBoolean(this._eliminatedNulls);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readInt();
        this._aggregator = (Aggregator)objectInput.readObject();
        this._resultType = (DataTypeDescriptor)objectInput.readObject();
        this._eliminatedNulls = objectInput.readBoolean();
    }

    public int getTypeFormatId() {
        return 323;
    }

    private void logAggregatorInstantiationError(String string2, Throwable throwable) {
        String string3 = MessageService.getTextMessage("C008", string2, throwable.getMessage());
        Monitor.getStream().println(string3);
        Exception exception = new Exception(string3, throwable);
        exception.printStackTrace(Monitor.getStream().getPrintWriter());
    }
}

