/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealUnionResultSetStatistics
extends RealNoPutResultSetStatistics {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public ResultSetStatistics leftResultSetStatistics;
    public ResultSetStatistics rightResultSetStatistics;

    public RealUnionResultSetStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, int n5, int n6, int n7, double d, double d2, ResultSetStatistics resultSetStatistics, ResultSetStatistics resultSetStatistics2) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.rowsSeenLeft = n5;
        this.rowsSeenRight = n6;
        this.rowsReturned = n7;
        this.leftResultSetStatistics = resultSetStatistics;
        this.rightResultSetStatistics = resultSetStatistics2;
    }

    public String getStatementExecutionPlanText(int n) {
        this.initFormatInfo(n);
        return this.indent + MessageService.getTextMessage("43Y14.U") + ":\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U") + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U") + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X81.U") + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U") + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U") + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    public String getScanStatisticsText(String string2, int n) {
        return this.leftResultSetStatistics.getScanStatisticsText(string2, n) + this.rightResultSetStatistics.getScanStatisticsText(string2, n);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.leftResultSetStatistics);
        vector.addElement(this.rightResultSetStatistics);
        return vector;
    }

    public String getNodeName() {
        return "Union";
    }

    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.leftResultSetStatistics != null) {
            ++n;
        }
        if (this.rightResultSetStatistics != null) {
            ++n;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.leftResultSetStatistics != null) {
            this.leftResultSetStatistics.accept(xPLAINVisitor);
        }
        if (this.rightResultSetStatistics != null) {
            this.rightResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    public String getRSXplainType() {
        return "UNION";
    }

    public String getRSXplainDetails() {
        return "(" + this.resultSetNumber + ")";
    }

    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, null, null, (UUID)object2, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeenLeft), new Integer(this.rowsSeenRight), new Integer(this.rowsFiltered), new Integer(this.rowsReturned), null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

