/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.adapter;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.testng.ISuite;
import org.testng.internal.Utils;
import org.testng.remote.ConnectionInfo;
import org.testng.remote.adapter.IWorkerAdapter;
import org.testng.xml.XmlSuite;

public class DefaultWorkerAdapter
implements IWorkerAdapter {
    public static final String SLAVE_PORT = "slave.port";
    private ConnectionInfo m_connectionInfo;
    private int m_clientPort;

    @Override
    public void init(Properties prop) throws Exception {
        this.m_clientPort = Integer.parseInt(prop.getProperty(SLAVE_PORT, "0"));
        this.m_connectionInfo = DefaultWorkerAdapter.resetSocket(this.m_clientPort, null);
    }

    @Override
    public XmlSuite getSuite(long timeout) throws InterruptedException, IOException {
        try {
            return (XmlSuite)this.m_connectionInfo.getOis().readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e);
        }
        catch (IOException ex) {
            DefaultWorkerAdapter.log("Connection closed " + ex.getMessage());
            this.m_connectionInfo = DefaultWorkerAdapter.resetSocket(this.m_clientPort, this.m_connectionInfo);
            throw ex;
        }
    }

    @Override
    public void returnResult(ISuite result) throws IOException {
        try {
            this.m_connectionInfo.getOos().writeObject(result);
        }
        catch (IOException ex) {
            DefaultWorkerAdapter.log("Connection closed " + ex.getMessage());
            this.m_connectionInfo = DefaultWorkerAdapter.resetSocket(this.m_clientPort, this.m_connectionInfo);
            throw ex;
        }
    }

    private static ConnectionInfo resetSocket(int clientPort, ConnectionInfo oldCi) throws IOException {
        ConnectionInfo result = new ConnectionInfo();
        ServerSocket serverSocket = new ServerSocket(clientPort);
        serverSocket.setReuseAddress(true);
        DefaultWorkerAdapter.log("Waiting for connections on port " + clientPort);
        Socket socket = serverSocket.accept();
        result.setSocket(socket);
        return result;
    }

    private static void log(String string2) {
        Utils.log("", 2, string2);
    }
}

