/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.NameSpace;
import bsh.SimpleNode;

public class EvalError
extends Exception {
    SimpleNode node;
    String message;
    CallStack callstack;

    public EvalError(String string2, SimpleNode simpleNode, CallStack callStack) {
        this.setMessage(string2);
        this.node = simpleNode;
        if (callStack != null) {
            this.callstack = callStack.copy();
        }
    }

    public String toString() {
        String string2 = this.node != null ? " : at Line: " + this.node.getLineNumber() + " : in file: " + this.node.getSourceFile() + " : " + this.node.getText() : ": <at unknown location>";
        if (this.callstack != null) {
            string2 = string2 + "\n" + this.getScriptStackTrace();
        }
        return this.getMessage() + string2;
    }

    public void reThrow(String string2) throws EvalError {
        this.prependMessage(string2);
        throw this;
    }

    SimpleNode getNode() {
        return this.node;
    }

    void setNode(SimpleNode simpleNode) {
        this.node = simpleNode;
    }

    public String getErrorText() {
        if (this.node != null) {
            return this.node.getText();
        }
        return "<unknown error>";
    }

    public int getErrorLineNumber() {
        if (this.node != null) {
            return this.node.getLineNumber();
        }
        return -1;
    }

    public String getErrorSourceFile() {
        if (this.node != null) {
            return this.node.getSourceFile();
        }
        return "<unknown file>";
    }

    public String getScriptStackTrace() {
        if (this.callstack == null) {
            return "<Unknown>";
        }
        String string2 = "";
        CallStack callStack = this.callstack.copy();
        while (callStack.depth() > 0) {
            NameSpace nameSpace = callStack.pop();
            SimpleNode simpleNode = nameSpace.getNode();
            if (!nameSpace.isMethod) continue;
            string2 = string2 + "\nCalled from method: " + nameSpace.getName();
            if (simpleNode == null) continue;
            string2 = string2 + " : at Line: " + simpleNode.getLineNumber() + " : in file: " + simpleNode.getSourceFile() + " : " + simpleNode.getText();
        }
        return string2;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string2) {
        this.message = string2;
    }

    protected void prependMessage(String string2) {
        if (string2 == null) {
            return;
        }
        this.message = this.message == null ? string2 : string2 + " : " + this.message;
    }
}

