/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import com.occamlab.te.TEClassLoader;
import com.occamlab.te.util.DomUtils;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Misc {
    public static void deleteDir(File dir2) {
        if (dir2.isDirectory()) {
            Misc.deleteDirContents(dir2);
            dir2.delete();
        }
    }

    public static void deleteDirContents(File dir2) {
        if (!dir2.isDirectory() || !dir2.exists()) {
            throw new IllegalArgumentException(dir2.getAbsolutePath() + " is not a directory or does not exist.");
        }
        String[] children = dir2.list();
        for (int i = 0; i < children.length; ++i) {
            File f = new File(dir2, children[i]);
            if (f.isDirectory()) {
                Misc.deleteDirContents(f);
            }
            f.delete();
        }
    }

    public static void deleteSubDirs(File dir2) {
        String[] children = dir2.list();
        for (int i = 0; i < children.length; ++i) {
            File f = new File(dir2, children[i]);
            if (!f.isDirectory()) continue;
            Misc.deleteDir(f);
        }
    }

    public static File getResourceAsFile(String resource) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            return new File(URLDecoder.decode(cl.getResource(resource).getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    Document getResourceAsDoc(String resource) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(resource);
        if (is != null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer t = tf.newTransformer();
            Document doc = db.newDocument();
            t.transform(new StreamSource(is), new DOMResult(doc));
            is.close();
            return doc;
        }
        return null;
    }

    public static String getResourceURL(String resource) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.getResource(resource).toString();
    }

    public static Method getMethod(String className, String methodName, TEClassLoader cl, int minArgs, int maxArgs) throws Exception {
        Class<?> c = Class.forName(className, true, cl);
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            int count = m.getParameterTypes().length;
            if (!m.getName().equals(methodName) || count < minArgs || count > maxArgs) continue;
            return m;
        }
        String argsDesc = Integer.toString(minArgs);
        if (maxArgs > minArgs) {
            argsDesc = argsDesc + " to " + Integer.toString(maxArgs) + " argument";
        }
        if (minArgs > 1 || maxArgs > 1) {
            argsDesc = argsDesc + "s";
        }
        throw new Exception("Error: Method " + methodName + " with " + argsDesc + " was not found in class " + className);
    }

    public static Method getMethod(String className, String methodName, TEClassLoader cl, int argCount) throws Exception {
        return Misc.getMethod(className, methodName, cl, argCount, argCount);
    }

    public static Object makeInstance(String className, List<Node> classParams, TEClassLoader cl) throws Exception {
        Class<?> c = Class.forName(className, true, cl);
        Constructor<?>[] constructors = c.getConstructors();
        int paramCount = 0;
        if (classParams != null) {
            paramCount = classParams.size();
        }
        Object[] classParamObjects = new Object[paramCount];
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] types = constructors[i].getParameterTypes();
            if (types.length != paramCount) continue;
            boolean constructorCorrect = true;
            for (int j = 0; j < types.length; ++j) {
                Node n = classParams.get(j);
                if (Document.class.isAssignableFrom(types[j])) {
                    if (n instanceof Document) {
                        classParamObjects[j] = (Document)n;
                        continue;
                    }
                    classParamObjects[j] = DomUtils.createDocument(n);
                    continue;
                }
                if (Node.class.isAssignableFrom(types[j])) {
                    classParamObjects[j] = n;
                    continue;
                }
                if (types[j].equals(String.class)) {
                    classParamObjects[j] = n.getTextContent();
                    continue;
                }
                if (types[j].toString().equals("char")) {
                    classParamObjects[j] = Character.valueOf(n.getTextContent().charAt(0));
                    continue;
                }
                if (types[j].toString().equals("boolean")) {
                    classParamObjects[j] = Boolean.parseBoolean(n.getTextContent());
                    continue;
                }
                if (types[j].toString().equals("byte")) {
                    classParamObjects[j] = Byte.parseByte(n.getTextContent());
                    continue;
                }
                if (types[j].toString().equals("short")) {
                    classParamObjects[j] = Short.parseShort(n.getTextContent());
                    continue;
                }
                if (types[j].toString().equals("int")) {
                    classParamObjects[j] = Integer.parseInt(n.getTextContent());
                    continue;
                }
                if (types[j].toString().equals("float")) {
                    classParamObjects[j] = Float.valueOf(Float.parseFloat(n.getTextContent()));
                    continue;
                }
                if (types[j].toString().equals("double")) {
                    classParamObjects[j] = Double.parseDouble(n.getTextContent());
                    continue;
                }
                constructorCorrect = false;
                break;
            }
            if (!constructorCorrect) continue;
            return constructors[i].newInstance(classParamObjects);
        }
        throw new Exception("No compatible constructors found in class " + className);
    }
}

