/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void zipDir(File zipFile, File dirObj) throws Exception {
        if (!dirObj.isDirectory()) {
            System.err.println(dirObj.getName() + " is not a directory");
            System.exit(1);
        }
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            System.out.println("Creating : " + zipFile);
            ZipUtils.addDir(dirObj, out);
            out.close();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    private static void addDir(File dirObj, ZipOutputStream out) throws IOException {
        File[] dirList = dirObj.listFiles();
        byte[] tmpBuf = new byte[1024];
        for (int i = 0; i < dirList.length; ++i) {
            int len;
            if (dirList[i].isDirectory()) {
                ZipUtils.addDir(dirList[i], out);
                continue;
            }
            FileInputStream in = new FileInputStream(dirList[i].getAbsolutePath());
            System.out.println(" Adding: " + dirList[i].getAbsolutePath());
            out.putNextEntry(new ZipEntry(dirList[i].getAbsolutePath().replaceAll("^/+", "")));
            while ((len = in.read(tmpBuf)) > 0) {
                out.write(tmpBuf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }
}

