/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import com.occamlab.te.web.TEBaseNotFoundException;
import com.occamlab.te.web.TEException;
import com.occamlab.te.web.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigFileCreator {
    private static Logger LOGR = Logger.getLogger("com.occamlab.te.web.ConfigFileCreator");
    private DocumentBuilder builder;
    private Document docMain;
    private Element config;
    private Element scripts;

    public ConfigFileCreator() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setExpandEntityReferences(false);
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void create(String tebase) throws TEException {
        File f = new File(tebase);
        if (f.exists()) {
            try {
                this.process(tebase);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new TEBaseNotFoundException(tebase);
        }
    }

    public void create(File tebase) throws TEException {
        this.create(tebase.toString() + File.separator);
    }

    private void deleteConfigFile(String tebase) {
        File f = new File(tebase + "config.xml");
        if (f.exists()) {
            f.delete();
            LOGR.info("Old onfig file removed " + f);
        } else {
            LOGR.info("Config file not removed, since there was no file at " + f);
        }
    }

    private void process(String tebase) {
        this.deleteConfigFile(tebase);
        this.docMain = this.builder.newDocument();
        this.config = this.docMain.createElement("config");
        this.docMain.appendChild(this.config);
        this.scripts = this.docMain.createElement("scripts");
        this.config.appendChild(this.scripts);
        String scriptsDir = tebase + "scripts";
        LOGR.info("Scripts directory found at " + scriptsDir);
        File[] testScriptsDir = new File(scriptsDir).listFiles();
        if (testScriptsDir != null) {
            for (File dir2 : testScriptsDir) {
                this.processDir(dir2);
            }
        }
        String mainconfig = tebase + "config.xml";
        this.saveConfigFile(this.docMain, mainconfig);
    }

    public void processDir(File dir2) {
        if (dir2.isDirectory() && !dir2.getName().startsWith(".")) {
            List configFiles = this.getConfigFiles(dir2);
            for (File file : configFiles) {
                this.processTestConfigFile(file);
            }
        }
    }

    private void processTestConfigFile(File configFile) {
        if (configFile != null) {
            Document docTest = this.getDocument(configFile);
            Node orgInTest = XMLUtils.getFirstNode((Document)docTest, (String)"/organization/name[1]");
            String org = orgInTest.getTextContent();
            String xpath = "/config/scripts/organization/name[text()='" + org + "']";
            Node orgInMainConfig = XMLUtils.getFirstNode((Document)this.docMain, (String)xpath);
            if (orgInMainConfig == null) {
                Node orgInTestImported = this.docMain.importNode(orgInTest.getParentNode(), true);
                this.scripts.appendChild(orgInTestImported);
            } else {
                Node standardInTest = XMLUtils.getFirstNode((Document)docTest, (String)"/organization/standard[1]");
                String standardInTestName = XMLUtils.getFirstNode((Document)docTest, (String)"/organization/standard[1]/name").getTextContent();
                xpath = "/config/scripts/organization/standard/name[text()='" + standardInTestName + "']";
                Node standardInMain = XMLUtils.getFirstNode((Document)this.docMain, (String)xpath);
                if (standardInMain == null) {
                    Node orgInMain = orgInMainConfig.getParentNode();
                    orgInMain.appendChild(this.docMain.importNode(standardInTest, true));
                } else {
                    Node versionInTest = XMLUtils.getFirstNode((Document)docTest, (String)"/organization/standard/version[1]");
                    standardInMain.getParentNode().appendChild(this.docMain.importNode(versionInTest, true));
                }
            }
            LOGR.config("Added " + configFile.getAbsolutePath() + " to config file");
        } else {
            LOGR.config("No config file was found in dir " + configFile.getAbsolutePath() + ". It was not registered in the main config file.");
        }
    }

    public void saveConfigFile(Document docMain, String mainconfig) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(docMain);
            StreamResult result = new StreamResult(new FileOutputStream(mainconfig));
            LOGR.info("SUCCESSFULLY created config.xml at " + mainconfig);
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception e) {
            LOGR.warning("The main config file was not created at " + mainconfig);
            e.printStackTrace();
        }
    }

    public Document getDocument(File xml) {
        try {
            Document doc = this.builder.parse(xml);
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<File> getConfigFiles(File dir2) {
        String[] extensions = new String[]{"xml"};
        ArrayList<File> configFiles = new ArrayList<File>();
        Collection<File> files = FileUtils.listFiles(dir2, extensions, true);
        for (File file : files) {
            if (!file.getName().equals("config.xml")) continue;
            configFiles.add(file);
        }
        return configFiles;
    }
}

