/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.web;

import com.occamlab.te.util.Misc;
import java.io.File;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ViewTestServlet
extends HttpServlet {
    private static final long serialVersionUID = -1396673675342836097L;
    Templates viewTestTemplates;

    @Override
    public void init() throws ServletException {
        try {
            File stylesheet = Misc.getResourceAsFile("com/occamlab/te/web/viewtest.xsl");
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.viewTestTemplates = tf.newTemplates(new StreamSource(stylesheet));
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            File file = new File(request.getParameter("file"));
            Transformer t = this.viewTestTemplates.newTransformer();
            t.setParameter("namespace-uri", request.getParameter("namespace"));
            t.setParameter("local-name", request.getParameter("name"));
            URL url = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
            t.setParameter("baseURL", url.toString());
            t.setParameter("user", request.getRemoteUser());
            t.transform(new StreamSource(file), new StreamResult(response.getOutputStream()));
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }
}

