/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.ClassNameInfo;
import java.io.File;

public class DirectoryUtil {
    public static File getOutputDirectoryFor(String theClass, File rootDir, ProcessorEnvironment env) throws GeneratorException {
        File outputDir = null;
        String qualifiedClassName = theClass;
        String packagePath = null;
        String packageName = ClassNameInfo.getQualifier(qualifiedClassName);
        if (packageName == null) {
            packageName = "";
        } else if (packageName.length() > 0) {
            packagePath = packageName.replace('.', File.separatorChar);
        }
        if (rootDir != null) {
            if (packagePath != null) {
                outputDir = new File(rootDir, packagePath);
                DirectoryUtil.ensureDirectory(outputDir, env);
            } else {
                outputDir = rootDir;
            }
        } else {
            String workingDirPath = System.getProperty("user.dir");
            File workingDir = new File(workingDirPath);
            if (packagePath == null) {
                outputDir = workingDir;
            } else {
                outputDir = new File(workingDir, packagePath);
                DirectoryUtil.ensureDirectory(outputDir, env);
            }
        }
        return outputDir;
    }

    private static void ensureDirectory(File dir2, ProcessorEnvironment env) throws GeneratorException {
        if (!dir2.exists()) {
            dir2.mkdirs();
            if (!dir2.exists()) {
                throw new GeneratorException("generator.cannot.create.dir", dir2.getAbsolutePath());
            }
        }
    }
}

