/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ModelFileModelInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.tools.wscompile.CompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;

public class EndpointCompileTool
extends CompileTool {
    protected EndpointInfo endpointInfo;
    protected WebServicesInfo webServicesInfo;
    protected File targetDirectory;
    protected boolean useModel;
    protected String additionalClasspath;
    protected Hashtable hashtable;
    protected ArrayList vector;
    protected boolean localUseWSIBasicProfile = false;
    private static final String PS = System.getProperty("path.separator");
    private static final char PSCHAR = System.getProperty("path.separator").charAt(0);
    private static final String FS = System.getProperty("file.separator");
    private static final char FSCHAR = System.getProperty("file.separator").charAt(0);

    public EndpointCompileTool(OutputStream out, String program, WebServicesInfo wsi, ArrayList list, File dir2, String target, Properties props, String classpath, ProcessorNotificationListener l) {
        super(out, program);
        this.webServicesInfo = wsi;
        this.targetDirectory = dir2;
        this.additionalClasspath = classpath;
        this.listener = l;
        this.vector = list;
        this.endpointInfo = (EndpointInfo)this.vector.get(0);
        this.useModel = this.endpointInfo.getModel() != null;
        this.targetVersion = target;
        this.verbose = new Boolean(props.getProperty("verbose"));
        this.keepGenerated = new Boolean(props.getProperty("keepGenerated"));
        this.donotOverride = true;
        this.resetOptionsForTargetVersion();
    }

    public EndpointCompileTool(OutputStream out, String program, EndpointInfo ei, WebServicesInfo wsi, File dir2, String target, Properties props, String classpath, ProcessorNotificationListener l) {
        super(out, program);
        this.endpointInfo = ei;
        this.webServicesInfo = wsi;
        this.targetDirectory = dir2;
        this.additionalClasspath = classpath;
        this.listener = l;
        this.useModel = this.endpointInfo.getModel() != null;
        this.targetVersion = target;
        this.verbose = new Boolean(props.getProperty("verbose"));
        this.keepGenerated = new Boolean(props.getProperty("keepGenerated"));
        this.donotOverride = true;
        this.resetOptionsForTargetVersion();
    }

    protected boolean classExists(String className, String message) {
        try {
            Class<?> c = Class.forName(className, true, this.environment.getClassLoader());
            if (c != null) {
                return true;
            }
        }
        catch (ClassNotFoundException ce) {
            this.onError(this.getMessage("wscompile.fileNotFound", message));
        }
        return false;
    }

    protected void beforeHook() {
        String targetPath = this.targetDirectory.getAbsolutePath();
        this.nonclassDestDir = new File(targetPath + FS + "WEB-INF");
        this.userClasspath = targetPath + FS + "WEB-INF" + FS + "classes";
        this.destDir = new File(this.userClasspath);
        if (new File(targetPath + FS + "WEB-INF" + FS + "lib").exists()) {
            File[] fs = new File(targetPath + FS + "WEB-INF" + FS + "lib").listFiles();
            for (int counter = 0; counter < fs.length; ++counter) {
                this.userClasspath = this.userClasspath + PS + fs[counter];
            }
        }
        if (this.additionalClasspath != null && this.additionalClasspath.length() > 0) {
            this.userClasspath = this.userClasspath + PS + this.additionalClasspath;
        }
        if (!this.useModel) {
            this.modelFile = new File(this.makeModelFileName());
        } else if (this.targetVersion != null) {
            this.onWarning(this.getMessage("wscompile.warning.ignoringTargetVersionForModel", this.endpointInfo.getModel(), this.targetVersion));
            this.targetVersion = null;
        }
        this.serializerInfix = "_" + this.endpointInfo.getName() + "_";
        this.compilerDebug = false;
        this.compilerOptimize = true;
        super.beforeHook();
    }

    protected void withModelHook() {
        Iterator services;
        EndpointInfo ei = null;
        if ((this.endpointInfo.getClientHandlerChainInfo() != null || this.endpointInfo.getServerHandlerChainInfo() != null) && (services = this.processor.getModel().getServices()).hasNext()) {
            Service service = (Service)services.next();
            this.endpointInfo.setRuntimeServiceName(service.getName());
            Iterator ports = service.getPorts();
            Port port = null;
            Object qName = null;
            while (ports.hasNext()) {
                port = (Port)ports.next();
                if (this.endpointInfo.getModel() == null) {
                    if (!port.getJavaInterface().getName().equals(this.endpointInfo.getInterface())) continue;
                    port.setClientHandlerChainInfo(this.endpointInfo.getClientHandlerChainInfo());
                    port.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
                    continue;
                }
                for (int counter = 0; counter < this.vector.size(); ++counter) {
                    ei = (EndpointInfo)this.vector.get(counter);
                    if (!port.getJavaInterface().getName().equals(ei.getInterface())) continue;
                    ei.setRuntimeServiceName(service.getName());
                    port.setClientHandlerChainInfo(ei.getClientHandlerChainInfo());
                    port.setServerHandlerChainInfo(ei.getServerHandlerChainInfo());
                    counter = this.vector.size();
                }
            }
        }
    }

    protected void afterHook() {
        boolean isCommonInterface = false;
        HashSet<EndpointInfo> hSet = new HashSet<EndpointInfo>();
        if (this.environment.getErrorCount() == 0) {
            this.endpointInfo.setRuntimeModel(this.useModel ? this.endpointInfo.getModel() : this.makeAppRelative(this.modelFile));
            if (this.endpointInfo.getRuntimeWSDL() == null) {
                this.endpointInfo.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
            }
            Iterator services = this.processor.getModel().getServices();
            String modelVersion = ((Model)this.processor.getModel()).getSource();
            if (services.hasNext()) {
                Service service = (Service)services.next();
                this.endpointInfo.setRuntimeServiceName(service.getName());
                Iterator ports = service.getPorts();
                Port port = null;
                EndpointInfo endpoint = null;
                String name = null;
                if (this.endpointInfo.getModel() != null) {
                    for (int counter = 0; counter < this.vector.size(); ++counter) {
                        endpoint = (EndpointInfo)this.vector.get(counter);
                        name = "";
                        for (int index = counter + 1; index < this.vector.size(); ++index) {
                            if (!endpoint.getInterface().equals(((EndpointInfo)this.vector.get(index)).getInterface())) continue;
                            hSet.add(endpoint);
                            hSet.add((EndpointInfo)this.vector.get(index));
                        }
                    }
                }
                while (ports.hasNext()) {
                    port = (Port)ports.next();
                    QName portName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
                    if (portName == null) {
                        portName = port.getName();
                    }
                    if (this.endpointInfo.getModel() == null) {
                        this.classExists(this.endpointInfo.getInterface(), "Interface specified in jaxrpc-ri.xml for " + this.endpointInfo.getName() + " is incorrect");
                        this.classExists(this.endpointInfo.getImplementation(), "Implementation specified in jaxrpc-ri.xml for " + this.endpointInfo.getName() + " is incorrect");
                        if (!port.getJavaInterface().getName().equals(this.endpointInfo.getInterface())) continue;
                        this.endpointInfo.setRuntimePortName(portName);
                        JavaInterface intf = port.getJavaInterface();
                        this.endpointInfo.setRuntimeTie(this.environment.getNames().tieFor(port));
                        this.endpointInfo.setRuntimeDeployed(true);
                        continue;
                    }
                    for (int counter = 0; counter < this.vector.size(); ++counter) {
                        this.endpointInfo = (EndpointInfo)this.vector.get(counter);
                        this.classExists(this.endpointInfo.getInterface(), "Interface specified in jaxrpc-ri.xml for " + this.endpointInfo.getName() + " is incorrect");
                        this.classExists(this.endpointInfo.getImplementation(), "Implementation specified in jaxrpc-ri.xml for " + this.endpointInfo.getName() + " is incorrect");
                        if (this.vector.size() > 1) {
                            if (VersionUtil.isVersion103(modelVersion) || VersionUtil.isVersion101(modelVersion)) {
                                if (!port.getJavaInterface().getName().equals(this.endpointInfo.getInterface())) continue;
                                this.setEndpointInfo(this.endpointInfo, portName, service, port);
                                continue;
                            }
                            if (hSet.contains(this.endpointInfo) && this.endpointInfo.getRuntimePortName() == null) {
                                this.onWarning(this.getMessage("wscompile.warning.noportInfo", this.endpointInfo.getName()));
                                continue;
                            }
                            if (hSet.contains(this.endpointInfo) && portName.equals(this.endpointInfo.getRuntimePortName())) {
                                this.setEndpointInfo(this.endpointInfo, portName, service, port);
                                continue;
                            }
                            if (!port.getJavaInterface().getName().equals(this.endpointInfo.getInterface()) || hSet.contains(this.endpointInfo)) continue;
                            this.setEndpointInfo(this.endpointInfo, portName, service, port);
                            continue;
                        }
                        if (!port.getJavaInterface().getName().equals(this.endpointInfo.getInterface())) continue;
                        this.setEndpointInfo(this.endpointInfo, portName, service, port);
                    }
                }
            }
        }
        if (this.delegate != null) {
            this.delegate.postRun();
        }
    }

    private void setEndpointInfo(EndpointInfo ei, QName portName, Service service, Port port) {
        ei.setRuntimeModel(this.useModel ? ei.getModel() : this.makeAppRelative(this.modelFile));
        if (ei.getRuntimeWSDL() == null) {
            ei.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
        }
        ei.setRuntimeServiceName(service.getName());
        if (ei.getRuntimePortName() == null) {
            ei.setRuntimePortName(portName);
        }
        JavaInterface intf = port.getJavaInterface();
        ei.setRuntimeTie(this.environment.getNames().tieFor(port));
        ei.setRuntimeDeployed(true);
    }

    public com.sun.xml.rpc.spi.tools.Configuration createConfiguration() throws Exception {
        Configuration config = new Configuration(this.environment);
        if (this.useModel) {
            ModelFileModelInfo modelInfo = new ModelFileModelInfo();
            modelInfo.setLocation(this.makeAbsolute(this.endpointInfo.getModel()));
            config.setModelInfo(modelInfo);
        } else {
            RmiModelInfo modelInfo = new RmiModelInfo();
            modelInfo.setName(this.endpointInfo.getName());
            modelInfo.setTargetNamespaceURI(this.makeTargetNamespaceURI());
            modelInfo.setTypeNamespaceURI(this.makeTypeNamespaceURI());
            modelInfo.setJavaPackageName(this.makeJavaPackageName());
            RmiInterfaceInfo interfaceInfo = new RmiInterfaceInfo();
            interfaceInfo.setName(this.endpointInfo.getInterface());
            interfaceInfo.setServantName(this.endpointInfo.getImplementation());
            interfaceInfo.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
            modelInfo.add(interfaceInfo);
            config.setModelInfo(modelInfo);
        }
        return config;
    }

    protected String makeTargetNamespaceURI() {
        String base = this.webServicesInfo.getTargetNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointInfo.getName();
        }
        return base + "/" + this.endpointInfo.getName();
    }

    protected String makeTypeNamespaceURI() {
        String base = this.webServicesInfo.getTypeNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointInfo.getName();
        }
        return base + "/" + this.endpointInfo.getName();
    }

    protected String makeModelFileName() {
        return this.targetDirectory.getAbsolutePath() + FS + "WEB-INF" + FS + this.endpointInfo.getName() + "_model.xml.gz";
    }

    protected String makeJavaPackageName() {
        return "jaxrpc.generated." + this.environment.getNames().validJavaPackageName(this.endpointInfo.getName());
    }

    protected String makeAbsolute(String s) {
        if (s == null) {
            return null;
        }
        return new File(this.targetDirectory.getAbsolutePath() + s).getAbsolutePath();
    }

    protected String makeAppRelative(File f) {
        String target;
        if (f == null) {
            return null;
        }
        String s = f.getAbsolutePath();
        if (s.startsWith(target = this.targetDirectory.getAbsolutePath())) {
            return s.substring(target.length()).replace(FSCHAR, '/');
        }
        return null;
    }

    protected File findGeneratedFileEndingWith(String s) {
        Iterator iter = this.environment.getGeneratedFiles();
        while (iter.hasNext()) {
            GeneratedFileInfo fileInfo = (GeneratedFileInfo)iter.next();
            File file = fileInfo.getFile();
            if (!file.getAbsolutePath().endsWith(s)) continue;
            return file;
        }
        return null;
    }

    protected void registerProcessorActions(Processor processor) {
        if (!this.useModel) {
            try {
                processor.add(new XMLModelWriter(this.modelFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        processor.add(this.getAction("enumeration.generator"));
        processor.add(this.getAction("enumeration.encoder.generator"));
        processor.add(this.getAction("holder.generator"));
        processor.add(this.getAction("custom.class.generator"));
        processor.add(this.getAction("soap.object.serializer.generator"));
        processor.add(this.getAction("interface.serializer.generator"));
        processor.add(this.getAction("soap.object.builder.generator"));
        processor.add(this.getAction("literal.object.serializer.generator"));
        processor.add(this.getAction("custom.exception.generator"));
        processor.add(this.getAction("soap.fault.serializer.generator"));
        processor.add(this.getAction("fault.exception.builder.generator"));
        processor.add(this.getAction("serializer.registry.generator"));
        processor.add(this.getAction("tie.generator"));
        processor.add(this.getAction("wsdl.generator"));
        if (this.delegate != null) {
            this.delegate.postRegisterProcessorActions();
        }
    }

    public void onError(Localizable msg) {
        if (this.delegate != null) {
            this.delegate.preOnError();
        }
        this.report(this.getMessage("wscompile.error", this.localizer.localize(msg)));
    }

    public void onWarning(Localizable msg) {
        this.report(this.getMessage("wscompile.warning", this.localizer.localize(msg)));
    }

    public void onInfo(Localizable msg) {
        this.report(this.getMessage("wscompile.info", this.localizer.localize(msg)));
    }
}

