/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.servlet;

import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.TCPResourceLoader;
import com.sun.xml.ws.transport.tcp.server.TCPServletContext;
import com.sun.xml.ws.transport.tcp.server.WSTCPModule;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;

public final class WSStartupServlet
extends HttpServlet
implements ServletContextAttributeListener,
ServletContextListener {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.server");
    private static final String JAXWS_RI_RUNTIME = "/WEB-INF/sun-jaxws.xml";
    private WSTCPModule registry;
    private List<TCPAdapter> adapters;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    @Override
    public void contextInitialized(ServletContextEvent contextEvent) {
        logger.log(Level.FINE, "WSStartupServlet.contextInitialized");
        ServletContext servletContext = contextEvent.getServletContext();
        TCPServletContext context = new TCPServletContext(servletContext);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ServletContainer container = new ServletContainer(servletContext);
        try {
            this.registry = WSTCPModule.getInstance();
            DeploymentDescriptorParser<TCPAdapter> parser = new DeploymentDescriptorParser<TCPAdapter>(classLoader, new TCPResourceLoader(context), container, TCPAdapter.FACTORY);
            URL sunJaxWsXml = context.getResource(JAXWS_RI_RUNTIME);
            if (sunJaxWsXml == null) {
                throw new WebServiceException(MessagesMessages.WSTCP_0014_NO_JAXWS_DESCRIPTOR());
            }
            this.adapters = parser.parse(sunJaxWsXml.toExternalForm(), sunJaxWsXml.openStream());
            this.registry.register(servletContext.getContextPath(), this.adapters);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalStateException("listener.parsingFailed", e);
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent contextEvent) {
        logger.log(Level.FINE, "WSStartupServlet.contextDestroyed");
        if (this.registry != null && this.adapters != null) {
            this.registry.free(contextEvent.getServletContext().getContextPath(), this.adapters);
        }
    }

    @Override
    public void attributeAdded(ServletContextAttributeEvent scab) {
    }

    @Override
    public void attributeRemoved(ServletContextAttributeEvent scab) {
    }

    @Override
    public void attributeReplaced(ServletContextAttributeEvent scab) {
    }

    private static final class ServletContainer
    extends Container {
        private final ServletContext servletContext;

        ServletContainer(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public <T> T getSPI(Class<T> spiType) {
            if (spiType == ServletContext.class) {
                return (T)this.servletContext;
            }
            return null;
        }
    }
}

