/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.DatatypeValue;
import com.thaiopensource.relaxng.pattern.InconsistentDataDerivType;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValueDataDerivType
extends DataDerivType {
    private final Datatype dt;
    private final Name dtName;
    private PatternMemo noValue;
    private Map<DatatypeValue, PatternMemo> valueMap;

    ValueDataDerivType(Datatype datatype, Name name) {
        this.dt = datatype;
        this.dtName = name;
    }

    @Override
    DataDerivType copy() {
        return new ValueDataDerivType(this.dt, this.dtName);
    }

    @Override
    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string2, ValidationContext validationContext, List<DataDerivFailure> list) {
        PatternMemo patternMemo;
        Object object = this.dt.createValue(string2, validationContext);
        if (object == null) {
            if (this.noValue == null) {
                this.noValue = super.dataDeriv(validatorPatternBuilder, pattern, string2, validationContext, list);
            } else if (list != null && this.noValue.isNotAllowed()) {
                try {
                    this.dt.checkValid(string2, validationContext);
                }
                catch (DatatypeException datatypeException) {
                    list.add(new DataDerivFailure(this.dt, this.dtName, datatypeException));
                }
            }
            return this.noValue;
        }
        DatatypeValue datatypeValue = new DatatypeValue(object, this.dt);
        if (this.valueMap == null) {
            this.valueMap = new HashMap<DatatypeValue, PatternMemo>();
        }
        if ((patternMemo = this.valueMap.get(datatypeValue)) == null) {
            patternMemo = super.dataDeriv(validatorPatternBuilder, pattern, string2, validationContext, list);
            this.valueMap.put(datatypeValue, patternMemo);
        } else if (patternMemo.isNotAllowed() && list != null) {
            super.dataDeriv(validatorPatternBuilder, pattern, string2, validationContext, list);
        }
        return patternMemo;
    }

    @Override
    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)dataDerivType).dt == this.dt) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return dataDerivType.combine(this);
    }

    Datatype getDatatype() {
        return this.dt;
    }
}

