/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.resolver.catalog.CatalogResolver;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.util.Version;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.FlagOption;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.OptionArgumentException;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.StringOption;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Driver {
    private static String usageKey = "usage";
    private boolean timing = false;
    private String encoding = null;
    private Localizer localizer = new Localizer(Driver.class);

    Driver() {
    }

    public static void setUsageKey(String string2) {
        usageKey = string2;
    }

    public static void main(String[] stringArray) {
        System.exit(new Driver().doMain(stringArray));
    }

    public int doMain(String[] stringArray) {
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(System.out);
        OptionParser optionParser = new OptionParser("itcdfe:p:sC:", stringArray);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, errorHandlerImpl);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        SchemaReader schemaReader = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'i': {
                        propertyMapBuilder.put(RngProperty.CHECK_ID_IDREF, null);
                        break;
                    }
                    case 'C': {
                        arrayList.add(UriOrFile.toUri(optionParser.getOptionArg()));
                        break;
                    }
                    case 'c': {
                        bl = true;
                        break;
                    }
                    case 'd': {
                        Option option;
                        if (schemaReader == null) {
                            schemaReader = new AutoSchemaReader();
                        }
                        if ((option = (FlagOption)schemaReader.getOption("http://www.thaiopensource.com/validate/diagnose")) == null) {
                            errorHandlerImpl.print(this.localizer.message("no_schematron", optionParser.getOptionCharString()));
                            return 2;
                        }
                        propertyMapBuilder.put(((FlagOption)option).getPropertyId(), Flag.PRESENT);
                        break;
                    }
                    case 't': {
                        this.timing = true;
                        break;
                    }
                    case 'e': {
                        this.encoding = optionParser.getOptionArg();
                        break;
                    }
                    case 'f': {
                        RngProperty.FEASIBLE.add(propertyMapBuilder);
                        break;
                    }
                    case 's': {
                        bl2 = true;
                        break;
                    }
                    case 'p': {
                        Option option;
                        if (schemaReader == null) {
                            schemaReader = new AutoSchemaReader();
                        }
                        if ((option = (StringOption)schemaReader.getOption("http://www.thaiopensource.com/validate/phase")) == null) {
                            errorHandlerImpl.print(this.localizer.message("no_schematron", optionParser.getOptionCharString()));
                            return 2;
                        }
                        try {
                            propertyMapBuilder.put(((StringOption)option).getPropertyId(), ((StringOption)option).valueOf(optionParser.getOptionArg()));
                            break;
                        }
                        catch (OptionArgumentException optionArgumentException) {
                            errorHandlerImpl.print(this.localizer.message("invalid_phase", optionParser.getOptionArg()));
                            return 2;
                        }
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            errorHandlerImpl.print(this.localizer.message("invalid_option", optionParser.getOptionCharString()));
            return 2;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            errorHandlerImpl.print(this.localizer.message("option_missing_argument", optionParser.getOptionCharString()));
            return 2;
        }
        if (!arrayList.isEmpty()) {
            try {
                propertyMapBuilder.put(ValidateProperty.RESOLVER, new CatalogResolver(arrayList));
            }
            catch (LinkageError linkageError) {
                errorHandlerImpl.print(this.localizer.message("resolver_not_found"));
                return 2;
            }
        }
        if (bl) {
            schemaReader = CompactSchemaReader.getInstance();
        }
        if ((stringArray = optionParser.getRemainingArgs()).length < 1) {
            errorHandlerImpl.print(this.localizer.message(usageKey, Version.getVersion(Driver.class)));
            return 2;
        }
        long l = System.currentTimeMillis();
        long l2 = -1L;
        boolean bl3 = false;
        try {
            ValidationDriver validationDriver = new ValidationDriver(propertyMapBuilder.toPropertyMap(), schemaReader);
            InputSource inputSource = ValidationDriver.uriOrFileInputSource(stringArray[0]);
            if (this.encoding != null) {
                inputSource.setEncoding(this.encoding);
            }
            if (validationDriver.loadSchema(inputSource)) {
                l2 = System.currentTimeMillis();
                if (bl2) {
                    String string2 = validationDriver.getSchemaProperties().get(RngProperty.SIMPLIFIED_SCHEMA);
                    if (string2 == null) {
                        errorHandlerImpl.print(this.localizer.message("no_simplified_schema"));
                        bl3 = true;
                    } else {
                        System.out.print(string2);
                    }
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    if (validationDriver.validate(ValidationDriver.uriOrFileInputSource(stringArray[i]))) continue;
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
        }
        catch (SAXException sAXException) {
            bl3 = true;
            errorHandlerImpl.printException(sAXException);
        }
        catch (IOException iOException) {
            bl3 = true;
            errorHandlerImpl.printException(iOException);
        }
        if (this.timing) {
            long l3 = System.currentTimeMillis();
            if (l2 < 0L) {
                l2 = l3;
            }
            errorHandlerImpl.print(this.localizer.message("elapsed_time", new Object[]{l2 - l, l3 - l2, l3 - l}));
        }
        if (bl3) {
            return 1;
        }
        return 0;
    }
}

