/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.catalog;

import com.thaiopensource.resolver.AbstractResolver;
import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.catalog.OasisCatalog;
import com.thaiopensource.resolver.catalog.ResolverIOException;
import com.thaiopensource.resolver.catalog.SimpleCatalogManager;
import com.thaiopensource.resolver.xml.ExternalDTDSubsetIdentifier;
import com.thaiopensource.resolver.xml.ExternalEntityIdentifier;
import com.thaiopensource.resolver.xml.ExternalIdentifier;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import java.io.IOException;
import java.util.List;
import org.apache.xml.resolver.Catalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogResolver
extends AbstractResolver {
    private final Catalog catalog;
    private boolean catalogLoaded = false;
    private boolean hadCatalogError = false;

    public CatalogResolver(Catalog catalog) {
        this.catalog = catalog;
    }

    public CatalogResolver(List<String> list, SAXResolver sAXResolver) {
        this(new OasisCatalog(new SimpleCatalogManager(list), sAXResolver));
    }

    public CatalogResolver(List<String> list, Resolver resolver2) {
        this(list, new SAXResolver(resolver2));
    }

    public CatalogResolver(List<String> list) {
        this(list, new SAXResolver());
    }

    @Override
    public synchronized void resolve(Identifier identifier, Input input) throws IOException, ResolverException {
        if (input.isResolved()) {
            return;
        }
        if (this.hadCatalogError) {
            return;
        }
        String string2 = null;
        try {
            string2 = BasicResolver.resolveUri(identifier);
            if (identifier.getUriReference().equals(string2)) {
                string2 = null;
            }
        }
        catch (ResolverException resolverException) {
            // empty catch block
        }
        String string3 = null;
        boolean bl = identifier instanceof ExternalIdentifier;
        try {
            if (!this.catalogLoaded) {
                this.catalogLoaded = true;
                this.catalog.loadSystemCatalogs();
            }
            if (string2 != null) {
                String string4 = string3 = bl ? this.catalog.resolveSystem(string2) : this.catalog.resolveURI(string2);
            }
            if (string3 == null) {
                if (!bl) {
                    string3 = this.catalog.resolveURI(identifier.getUriReference());
                } else if (identifier instanceof ExternalEntityIdentifier) {
                    ExternalEntityIdentifier externalEntityIdentifier = (ExternalEntityIdentifier)identifier;
                    string3 = this.catalog.resolveEntity(externalEntityIdentifier.getEntityName(), externalEntityIdentifier.getPublicId(), externalEntityIdentifier.getUriReference());
                } else if (identifier instanceof ExternalDTDSubsetIdentifier) {
                    ExternalDTDSubsetIdentifier externalDTDSubsetIdentifier = (ExternalDTDSubsetIdentifier)identifier;
                    string3 = this.catalog.resolveDoctype(externalDTDSubsetIdentifier.getDoctypeName(), externalDTDSubsetIdentifier.getPublicId(), externalDTDSubsetIdentifier.getUriReference());
                } else {
                    ExternalIdentifier externalIdentifier = (ExternalIdentifier)identifier;
                    string3 = this.catalog.resolvePublic(externalIdentifier.getPublicId(), externalIdentifier.getUriReference());
                }
            }
        }
        catch (ResolverIOException resolverIOException) {
            this.hadCatalogError = true;
            throw resolverIOException.getResolverException();
        }
        if (string3 != null) {
            input.setUri(string3);
        }
    }
}

