/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ValidationDriver {
    private XMLReader xr;
    private final CountingErrorHandler eh;
    private final SchemaReader sr;
    private final PropertyMap schemaProperties;
    private final PropertyMap instanceProperties;
    private Validator validator;
    private Schema schema;

    public ValidationDriver(PropertyMap propertyMap, PropertyMap propertyMap2, SchemaReader schemaReader) {
        PropertyMapBuilder propertyMapBuilder;
        ErrorHandler errorHandler = propertyMap.get(ValidateProperty.ERROR_HANDLER);
        if (errorHandler == null) {
            errorHandler = new ErrorHandlerImpl();
            propertyMapBuilder = new PropertyMapBuilder(propertyMap);
            propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, errorHandler);
            this.schemaProperties = propertyMapBuilder.toPropertyMap();
        } else {
            this.schemaProperties = propertyMap;
        }
        propertyMapBuilder = new PropertyMapBuilder(propertyMap2);
        ErrorHandler errorHandler2 = propertyMap2.get(ValidateProperty.ERROR_HANDLER);
        if (errorHandler2 == null) {
            errorHandler2 = errorHandler;
        }
        this.eh = new CountingErrorHandler(errorHandler2);
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, this.eh);
        this.instanceProperties = propertyMapBuilder.toPropertyMap();
        this.sr = schemaReader == null ? new AutoSchemaReader() : schemaReader;
    }

    public ValidationDriver(PropertyMap propertyMap, PropertyMap propertyMap2) {
        this(propertyMap, propertyMap2, null);
    }

    public ValidationDriver(PropertyMap propertyMap, SchemaReader schemaReader) {
        this(propertyMap, propertyMap, schemaReader);
    }

    public ValidationDriver(PropertyMap propertyMap) {
        this(propertyMap, propertyMap, null);
    }

    public ValidationDriver(SchemaReader schemaReader) {
        this(PropertyMap.EMPTY, schemaReader);
    }

    public ValidationDriver() {
        this(PropertyMap.EMPTY, PropertyMap.EMPTY, null);
    }

    public boolean loadSchema(InputSource inputSource) throws SAXException, IOException {
        try {
            this.schema = this.sr.createSchema(new SAXSource(inputSource), this.schemaProperties);
            this.validator = null;
            return true;
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(InputSource inputSource) throws SAXException, IOException {
        if (this.schema == null) {
            throw new IllegalStateException("cannot validate without schema");
        }
        if (this.validator == null) {
            this.validator = this.schema.createValidator(this.instanceProperties);
        }
        if (this.xr == null) {
            this.xr = ResolverFactory.createResolver(this.instanceProperties).createXMLReader();
            this.xr.setErrorHandler(this.eh);
        }
        this.eh.reset();
        this.xr.setContentHandler(this.validator.getContentHandler());
        DTDHandler dTDHandler = this.validator.getDTDHandler();
        if (dTDHandler != null) {
            this.xr.setDTDHandler(dTDHandler);
        }
        try {
            this.xr.parse(inputSource);
            boolean bl = !this.eh.getHadErrorOrFatalError();
            return bl;
        }
        finally {
            this.validator.reset();
        }
    }

    public PropertyMap getSchemaProperties() {
        if (this.schema == null) {
            throw new IllegalStateException("getSchemaProperties requires a schema");
        }
        return this.schema.getProperties();
    }

    public static InputSource fileInputSource(String string2) {
        return ValidationDriver.fileInputSource(new File(string2));
    }

    public static InputSource fileInputSource(File file) {
        return new InputSource(UriOrFile.fileToUri(file));
    }

    public static InputSource uriOrFileInputSource(String string2) {
        return new InputSource(UriOrFile.toUri(string2));
    }
}

