/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.derby.diag.DiagUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTITemplate;

public class StatementDuration
extends VTITemplate {
    private boolean gotFile;
    private InputStreamReader inputFileStreamReader;
    private InputStream inputStream;
    private BufferedReader bufferedReader;
    private String inputFileName;
    private Hashtable hashTable;
    private String line;
    private int endTimestampIndex;
    private int threadIndex;
    private int xidIndex;
    private int lccidIndex;
    private String[] currentRow;
    private static final String END_TIMESTAMP = " Thread";
    private static final String BEGIN_THREAD_STRING = "[";
    private static final String END_THREAD_STRING = "]";
    private static final String BEGIN_XID_STRING = "= ";
    private static final String END_XID_STRING = ")";
    private static final String BEGIN_EXECUTING_STRING = "Executing prepared";
    private static final String END_EXECUTING_STRING = " :End prepared";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("TS", 12, false, 29), EmbedResultSetMetaData.getResultColumnDescriptor("THREADID", 12, false, 80), EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("LCCID", 12, false, 10), EmbedResultSetMetaData.getResultColumnDescriptor("LOGTEXT", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("DURATION", 12, false, 10)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public StatementDuration() throws StandardException {
        DiagUtil.checkAccess();
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("derby.system.home");
            }
        });
        this.inputFileName = "derby.log";
        if (string2 != null) {
            this.inputFileName = string2 + "/" + this.inputFileName;
        }
    }

    public StatementDuration(String string2) throws StandardException {
        DiagUtil.checkAccess();
        this.inputFileName = string2;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public boolean next() throws SQLException {
        String[] stringArray;
        String[] stringArray2;
        if (!this.gotFile) {
            this.gotFile = true;
            try {
                this.inputFileStreamReader = new InputStreamReader(new FileInputStream(this.inputFileName));
                this.bufferedReader = new BufferedReader(this.inputFileStreamReader, 32768);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLException(fileNotFoundException.getMessage());
            }
            this.hashTable = new Hashtable();
        }
        while (true) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (this.line == null) {
                return false;
            }
            this.endTimestampIndex = this.line.indexOf(END_TIMESTAMP);
            this.threadIndex = this.line.indexOf(BEGIN_THREAD_STRING);
            this.xidIndex = this.line.indexOf(BEGIN_XID_STRING);
            this.lccidIndex = this.line.indexOf(BEGIN_XID_STRING, this.xidIndex + 1);
            if (this.endTimestampIndex == -1 || this.threadIndex == -1 || this.xidIndex == -1) continue;
            stringArray2 = new String[6];
            for (int i = 1; i <= 5; ++i) {
                stringArray2[i - 1] = this.setupColumn(i);
            }
            stringArray = this.hashTable.put(stringArray2[3], stringArray2);
            if (stringArray != null) break;
        }
        this.currentRow = stringArray;
        Timestamp timestamp = this.stringToTimestamp(stringArray2[0]);
        long l = timestamp.getTime() + (long)(timestamp.getNanos() / 1000000);
        Timestamp timestamp2 = this.stringToTimestamp(this.currentRow[0]);
        long l2 = timestamp2.getTime() + (long)(timestamp2.getNanos() / 1000000);
        this.currentRow[5] = Long.toString(l - l2);
        return true;
    }

    private Timestamp stringToTimestamp(String string2) throws SQLException {
        String string3 = string2.trim();
        if (!Character.isDigit(string3.charAt(string3.length() - 1))) {
            string3 = string3.substring(0, string3.length() - 4);
            return Timestamp.valueOf(string3);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        try {
            return new Timestamp(simpleDateFormat.parse(string3).getTime());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void close() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
                this.inputFileStreamReader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bufferedReader = null;
                this.inputFileStreamReader = null;
            }
        }
    }

    public String getString(int n) throws SQLException {
        return this.currentRow[n - 1];
    }

    private String setupColumn(int n) throws SQLException {
        switch (n) {
            case 1: {
                return this.line.substring(0, this.endTimestampIndex);
            }
            case 2: {
                return this.line.substring(this.threadIndex + 1, this.line.indexOf(END_THREAD_STRING));
            }
            case 3: {
                return this.line.substring(this.xidIndex + 2, this.line.indexOf(END_XID_STRING, this.xidIndex));
            }
            case 4: {
                return this.line.substring(this.lccidIndex + 2, this.line.indexOf(END_XID_STRING, this.lccidIndex));
            }
            case 5: {
                StringBuffer stringBuffer = new StringBuffer(64);
                if (this.line.indexOf(BEGIN_EXECUTING_STRING) == -1) {
                    stringBuffer.append(this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3));
                } else {
                    int n2 = this.line.indexOf(END_EXECUTING_STRING, this.lccidIndex);
                    if (n2 == -1) {
                        stringBuffer.append(this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3));
                    } else {
                        stringBuffer.append(this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3, n2));
                    }
                    while (n2 == -1) {
                        try {
                            this.line = this.bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            throw new SQLException("Error reading file " + iOException);
                        }
                        n2 = this.line.indexOf(END_EXECUTING_STRING);
                        if (n2 == -1) {
                            stringBuffer.append(this.line);
                            continue;
                        }
                        stringBuffer.append(this.line.substring(0, n2));
                    }
                }
                return StringUtil.truncate(stringBuffer.toString(), 32672);
            }
        }
        return null;
    }

    public boolean wasNull() {
        return false;
    }
}

