/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConsInfo;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class DDUtils {
    public static ReferencedKeyConstraintDescriptor locateReferencedConstraint(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string2, String[] stringArray, ConsInfo consInfo) throws StandardException {
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        if (tableDescriptor2 == null) {
            throw StandardException.newException("X0Y46.S", (Object)string2, (Object)consInfo.getReferencedTableName());
        }
        ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = null;
        String[] stringArray2 = consInfo.getReferencedColumnNames();
        if (stringArray2 == null || stringArray2.length == 0) {
            referencedKeyConstraintDescriptor = tableDescriptor2.getPrimaryKey();
            if (referencedKeyConstraintDescriptor == null) {
                throw StandardException.newException("X0Y41.S", (Object)string2, (Object)tableDescriptor2.getQualifiedName());
            }
            ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
            if (columnDescriptorList.size() != referencedKeyConstraintDescriptor.getColumnDescriptors().size()) {
                throw StandardException.newException("X0Y43.S", (Object)string2, (Object)String.valueOf(columnDescriptorList.size()), (Object)String.valueOf(referencedKeyConstraintDescriptor.getColumnDescriptors().size()));
            }
            if (!referencedKeyConstraintDescriptor.areColumnsComparable(columnDescriptorList)) {
                throw StandardException.newException("X0Y42.S", string2);
            }
            return referencedKeyConstraintDescriptor;
        }
        ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor2);
        int n = constraintDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) || !constraintDescriptor.areColumnsComparable(columnDescriptorList) || !DDUtils.columnNamesMatch(stringArray2, constraintDescriptor.getColumnDescriptors())) continue;
            return (ReferencedKeyConstraintDescriptor)constraintDescriptor;
        }
        throw StandardException.newException("X0Y44.S", (Object)string2, (Object)tableDescriptor2.getQualifiedName());
    }

    public static ColumnDescriptorList getColumnDescriptors(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String[] stringArray) throws StandardException {
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i]);
            columnDescriptorList.add(tableDescriptor.getUUID(), columnDescriptor);
        }
        return columnDescriptorList;
    }

    public static boolean columnNamesMatch(String[] stringArray, ColumnDescriptorList columnDescriptorList) throws StandardException {
        if (stringArray.length != columnDescriptorList.size()) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = columnDescriptorList.elementAt(i).getColumnName();
            if (string2.equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static void validateReferentialActions(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string2, ConsInfo consInfo, String[] stringArray) throws StandardException {
        int n = consInfo.getReferentialActionDeleteRule();
        if (n == 3) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i]);
                if (!columnDescriptor.getType().isNullable()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw StandardException.newException("42834", string2);
            }
        }
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        Hashtable hashtable = new Hashtable();
        boolean bl = tableDescriptor2.getUUID().equals(tableDescriptor.getUUID());
        String string3 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
        int n2 = DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor, -1, hashtable, false, true);
        DDUtils.validateDeleteConnection(dataDictionary, tableDescriptor, tableDescriptor2, n, hashtable, (Hashtable)hashtable.clone(), true, string2, false, new StringBuffer(0), string3, bl, n2);
        if (!bl) {
            DDUtils.checkForAnyExistingDeleteConnectionViolations(dataDictionary, tableDescriptor, n, hashtable, string2);
        }
    }

    private static int getCurrentDeleteConnections(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n, Hashtable hashtable, boolean bl, boolean bl2) throws StandardException {
        int n2 = -1;
        tableDescriptor.emptyConstraintDescriptorList();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n3 = constraintDescriptorList.size();
        boolean bl3 = bl;
        for (int i = 0; i < n3; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            String string2 = foreignKeyConstraintDescriptor.getConstraintName();
            int n4 = foreignKeyConstraintDescriptor.getRaDeleteRule();
            int n5 = foreignKeyConstraintDescriptor.getRaUpdateRule();
            if (bl2 && foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                n2 = n4;
                bl2 = false;
            }
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            TableDescriptor tableDescriptor2 = referencedKeyConstraintDescriptor.getTableDescriptor();
            int n6 = n == -1 ? n4 : n;
            String string3 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
            Integer n7 = (Integer)hashtable.get(string3);
            if (n7 != null) {
                bl = bl3;
                continue;
            }
            if (n4 != 0) {
                if (bl) {
                    bl = bl3;
                    continue;
                }
                bl = true;
            }
            hashtable.put(string3, new Integer(n6));
            if (!foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor2, n6, hashtable, true, false);
            }
            bl = bl3;
        }
        return n2;
    }

    private static void validateDeleteConnection(DataDictionary dataDictionary, TableDescriptor tableDescriptor, TableDescriptor tableDescriptor2, int n, Hashtable hashtable, Hashtable hashtable2, boolean bl, String string2, boolean bl2, StringBuffer stringBuffer, String string3, boolean bl3, int n2) throws StandardException {
        Integer n3;
        if (bl) {
            String string4 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
            n3 = (Integer)hashtable.get(string4);
            if (bl3) {
                if (n2 != -1) {
                    if (n2 != n) {
                        if (n2 == 3) {
                            throw DDUtils.generateError("XCL33.S", string2, string3);
                        }
                        throw DDUtils.generateError("XCL36.S", string2, n2);
                    }
                    if (n2 == 3 && n == 3) {
                        throw DDUtils.generateError("XCL33.S", string2, string3);
                    }
                }
                if (bl3 && hashtable.contains(new Integer(0)) && n != 0) {
                    throw DDUtils.generateError("XCL37.S", string2, 0);
                }
                return;
            }
            if (n2 != -1 && n == 0 && n2 != 0) {
                throw DDUtils.generateError("XCL39.S", string2);
            }
            if (n3 != null) {
                DDUtils.checkForMultiplePathInvalidCases(n3, n, string2, string3);
            }
            if (n != 0) {
                bl2 = true;
            }
            stringBuffer = stringBuffer.append(n);
        }
        boolean bl4 = bl2;
        boolean bl5 = true;
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor2);
        int n4 = constraintDescriptorList.size();
        for (int i = 0; i < n4; ++i) {
            String string5;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            String string6 = foreignKeyConstraintDescriptor.getConstraintName();
            int n5 = foreignKeyConstraintDescriptor.getRaDeleteRule();
            int n6 = foreignKeyConstraintDescriptor.getRaUpdateRule();
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            TableDescriptor tableDescriptor3 = referencedKeyConstraintDescriptor.getTableDescriptor();
            if (n5 != 0) {
                if (bl2) {
                    bl2 = bl4;
                    continue;
                }
                bl2 = true;
                bl5 = false;
            }
            boolean bl6 = foreignKeyConstraintDescriptor.isSelfReferencingFK();
            stringBuffer = stringBuffer.append(n5);
            boolean bl7 = tableDescriptor3.getUUID().equals(tableDescriptor.getUUID());
            if (bl7) {
                for (int j = 0; j < stringBuffer.length(); ++j) {
                    int n7 = Character.getNumericValue(stringBuffer.charAt(j));
                    if (n7 == n) continue;
                    if (n7 != 0) {
                        throw DDUtils.generateError("XCL40.S", string2);
                    }
                    throw DDUtils.generateError("XCL34.S", string2, string3);
                }
            }
            if ((n3 = (Integer)hashtable2.get(string5 = tableDescriptor3.getSchemaName() + "." + tableDescriptor3.getName())) != null) {
                if (!bl6 && bl5) {
                    DDUtils.checkForMultiplePathInvalidCases(n3, n, string2, string3);
                }
            } else {
                n3 = (Integer)hashtable.get(string5);
                if (n3 == null) {
                    if (bl5) {
                        hashtable.put(string5, new Integer(n));
                    }
                    if (!bl6) {
                        DDUtils.validateDeleteConnection(dataDictionary, tableDescriptor, tableDescriptor3, n, hashtable, hashtable2, false, string2, bl2, stringBuffer, string3, bl3, n2);
                    }
                }
            }
            bl2 = bl4;
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
    }

    private static void checkForMultiplePathInvalidCases(int n, int n2, String string2, String string3) throws StandardException {
        if (n != n2) {
            if (n == 3) {
                throw DDUtils.generateError("XCL35.S", string2, string3);
            }
            throw DDUtils.generateError("XCL38.S", string2, n);
        }
        if (n == 3 && n2 == 3) {
            throw DDUtils.generateError("XCL35.S", string2, string3);
        }
    }

    private static void checkForAnyExistingDeleteConnectionViolations(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n, Hashtable hashtable, String string2) throws StandardException {
        if (n != 0) {
            return;
        }
        String string3 = tableDescriptor.getSchemaName() + "." + tableDescriptor.getName();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n2 = constraintDescriptorList.size();
        for (int i = 0; i < n2; ++i) {
            ConstraintDescriptorList constraintDescriptorList2;
            int n3;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) || (n3 = (constraintDescriptorList2 = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(3))).size()) == 0) continue;
            Hashtable hashtable2 = new Hashtable();
            for (int j = 0; j < n3; ++j) {
                ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptorList2.elementAt(j);
                TableDescriptor tableDescriptor2 = foreignKeyConstraintDescriptor.getTableDescriptor();
                int n4 = foreignKeyConstraintDescriptor.getRaDeleteRule();
                if (!foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                    DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor2, -1, hashtable2, false, true);
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        int n5;
                        String string4 = (String)enumeration.nextElement();
                        if (string4.equals(string3) || !hashtable.containsKey(string4) || ((n5 = ((Integer)hashtable2.get(string4)).intValue()) != 3 || n4 != 3) && n5 == n4) continue;
                        throw DDUtils.generateError("XCL41.S", string2);
                    }
                }
                hashtable2.clear();
            }
        }
    }

    private static StandardException generateError(String string2, String string3) {
        String string4 = MessageService.getTextMessage(string2);
        return StandardException.newException("42915", (Object)string3, (Object)string4);
    }

    private static StandardException generateError(String string2, String string3, int n) {
        String string4;
        switch (n) {
            case 0: {
                string4 = "CASCADE";
                break;
            }
            case 1: {
                string4 = "RESTRICT";
                break;
            }
            case 3: {
                string4 = "SET NULL";
                break;
            }
            case 4: {
                string4 = "SET DEFAULT";
                break;
            }
            default: {
                string4 = "NO ACTION";
            }
        }
        String string5 = MessageService.getTextMessage(string4);
        String string6 = MessageService.getTextMessage(string2, string5);
        return StandardException.newException("42915", (Object)string3, (Object)string6);
    }

    private static StandardException generateError(String string2, String string3, String string4) {
        String string5 = MessageService.getTextMessage(string2, string4);
        return StandardException.newException("42915", (Object)string3, (Object)string5);
    }
}

