/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.tools.i18n;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;

public final class LocalizedResource
implements PrivilegedAction {
    private static final boolean SUPPORTS_BIG_DECIMAL_CALLS;
    private ResourceBundle res;
    private Locale locale;
    private String encode;
    private static final String MESSAGE_FILE = "org.apache.derby.loc.toolsmessages";
    private static final String ENV_CODESET = "derby.ui.codeset";
    private static final String ENV_LOCALE = "derby.ui.locale";
    private String messageFileName;
    private String resourceKey;
    private LocalizedOutput out;
    private LocalizedInput in;
    private boolean enableLocalized;
    private boolean unicodeEscape;
    private static LocalizedResource local;
    private int dateSize;
    private int timeSize;
    private int timestampSize;
    private DateFormat formatDate;
    private DateFormat formatTime;
    private DateFormat formatTimestamp;
    private NumberFormat formatNumber;
    private DecimalFormat formatDecimal;

    public LocalizedResource() {
        this.init();
    }

    public LocalizedResource(String string2, String string3, String string4) {
        this.init(string2, string3, string4);
    }

    public static LocalizedResource getInstance() {
        if (local == null) {
            local = new LocalizedResource();
        }
        return local;
    }

    public static void resetLocalizedResourceCache() {
        local = null;
    }

    public void init() {
        this.init(null, null, null);
    }

    public void init(String string2, String string3, String string4) {
        String string5;
        if (string2 != null) {
            this.encode = string2;
        }
        if (this.encode == null && (string5 = this.getEnvProperty(ENV_CODESET)) != null) {
            this.encode = string5;
        }
        this.locale = this.getNewLocale(string3);
        if (this.locale == null) {
            string5 = this.getEnvProperty(ENV_LOCALE);
            this.locale = this.getNewLocale(string5);
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.messageFileName = string4 != null ? string4 : MESSAGE_FILE;
        this.out = this.getNewOutput(System.out);
        this.in = this.getNewInput(System.in);
        if (this.enableLocalized && this.locale != null) {
            this.formatDecimal = (DecimalFormat)DecimalFormat.getInstance(this.locale);
            this.formatNumber = NumberFormat.getInstance(this.locale);
            this.formatDate = DateFormat.getDateInstance(1, this.locale);
            this.formatTime = DateFormat.getTimeInstance(1, this.locale);
            this.formatTimestamp = DateFormat.getDateTimeInstance(1, 1, this.locale);
        } else {
            this.formatDecimal = (DecimalFormat)DecimalFormat.getInstance();
            this.formatNumber = NumberFormat.getInstance();
            this.formatDate = DateFormat.getDateInstance(1);
            this.formatTime = DateFormat.getTimeInstance(1);
            this.formatTimestamp = DateFormat.getDateTimeInstance(1, 1);
        }
        this.initMaxSizes2();
    }

    private void setResource() {
        if (this.res != null) {
            return;
        }
        if (this.locale == null || this.locale.toString().equals("none")) {
            this.res = ResourceBundle.getBundle(this.messageFileName);
        } else {
            try {
                this.res = ResourceBundle.getBundle(this.messageFileName, this.locale);
            }
            catch (MissingResourceException missingResourceException) {
                this.res = ResourceBundle.getBundle(this.messageFileName, Locale.ENGLISH);
            }
        }
    }

    private void initMaxSizes2() {
        int n;
        int n2;
        this.dateSize = 0;
        this.timeSize = 0;
        this.timestampSize = 0;
        java.util.Date date = new java.util.Date(60907276800000L);
        Timestamp timestamp = new Timestamp(date.getTime());
        for (n2 = 0; n2 <= 11; ++n2) {
            n = this.getDateAsString(date).length();
            if (n > this.dateSize) {
                this.dateSize = n;
            }
            timestamp.setTime(date.getTime() + 79199L);
            n = this.getTimestampAsString(timestamp).length();
            if (n > this.timestampSize) {
                this.timestampSize = n;
            }
            date.setTime(date.getTime() + 2592000000L);
        }
        n = 18;
        for (n2 = 0; n2 < 24; ++n2) {
            long l = (long)n2 * 3600L + 3540L + 59L;
            long l2 = l * 1000L;
            java.util.Date date2 = new java.util.Date(l2);
            String string2 = this.formatTime.format(date2);
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        this.timeSize = n;
    }

    public LocalizedInput getNewInput(InputStream inputStream) {
        try {
            if (this.encode != null) {
                return new LocalizedInput(inputStream, this.encode);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new LocalizedInput(inputStream);
    }

    public LocalizedInput getNewEncodedInput(InputStream inputStream, String string2) {
        try {
            return new LocalizedInput(inputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new LocalizedInput(inputStream);
        }
    }

    public LocalizedOutput getNewOutput(OutputStream outputStream) {
        try {
            if (this.encode != null) {
                return new LocalizedOutput(outputStream, this.encode);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new LocalizedOutput(outputStream);
    }

    public LocalizedOutput getNewEncodedOutput(OutputStream outputStream, String string2) throws UnsupportedEncodingException {
        this.out = new LocalizedOutput(outputStream, string2);
        return this.out;
    }

    public String getTextMessage(String string2) {
        return this.getTextMessage(string2, new Object[0]);
    }

    public String getTextMessage(String string2, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.getTextMessage(string2, objectArray);
    }

    public String getTextMessage(String string2, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.getTextMessage(string2, objectArray);
    }

    public String getTextMessage(String string2, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.getTextMessage(string2, objectArray);
    }

    public String getTextMessage(String string2, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return this.getTextMessage(string2, objectArray);
    }

    private Locale getNewLocale(String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
        try {
            string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
            return new Locale(string3, string4, string5);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTextMessage(String string2, Object[] objectArray) {
        if (this.res == null) {
            this.setResource();
        }
        try {
            return MessageFormat.format(this.res.getString(string2), objectArray);
        }
        catch (Exception exception) {
            String string3 = string2;
            for (int i = 0; i < objectArray.length; ++i) {
                string3 = string3 + ", <{" + i + "}>";
            }
            return MessageFormat.format(string3, objectArray);
        }
    }

    public String getLocalizedString(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        if (!this.enableLocalized) {
            return resultSet.getString(n);
        }
        int n2 = resultSetMetaData.getColumnType(n);
        if (n2 == 91) {
            return this.getDateAsString(resultSet.getDate(n));
        }
        if (n2 == 4 || n2 == 5 || n2 == -5 || n2 == -6) {
            return this.getNumberAsString(resultSet.getLong(n));
        }
        if (n2 == 7 || n2 == 6 || n2 == 8) {
            return this.getNumberAsString(resultSet.getDouble(n));
        }
        if (SUPPORTS_BIG_DECIMAL_CALLS && (n2 == 2 || n2 == 3)) {
            return this.getNumberAsString(resultSet.getObject(n));
        }
        if (n2 == 92) {
            return this.getTimeAsString(resultSet.getTime(n));
        }
        if (n2 == 93) {
            return this.getTimestampAsString(resultSet.getTimestamp(n));
        }
        return resultSet.getString(n);
    }

    public String getDateAsString(java.util.Date date) {
        if (!this.enableLocalized) {
            return date.toString();
        }
        return this.formatDate.format(date);
    }

    public String getTimeAsString(java.util.Date date) {
        if (!this.enableLocalized) {
            return date.toString();
        }
        return this.formatTime.format(date, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String getNumberAsString(int n) {
        if (this.enableLocalized) {
            return this.formatNumber.format(n);
        }
        return String.valueOf(n);
    }

    public String getNumberAsString(long l) {
        if (this.enableLocalized) {
            return this.formatNumber.format(l);
        }
        return String.valueOf(l);
    }

    public String getNumberAsString(Object object) {
        if (this.enableLocalized) {
            return this.formatNumber.format(object, new StringBuffer(), new FieldPosition(0)).toString();
        }
        return object.toString();
    }

    public String getNumberAsString(double d) {
        if (!this.enableLocalized) {
            return String.valueOf(d);
        }
        return this.formatDecimal.format(d);
    }

    public String getTimestampAsString(Timestamp timestamp) {
        if (!this.enableLocalized) {
            return timestamp.toString();
        }
        return this.formatTimestamp.format(timestamp, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public int getColumnDisplaySize(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        if (!this.enableLocalized) {
            return resultSetMetaData.getColumnDisplaySize(n);
        }
        int n2 = resultSetMetaData.getColumnType(n);
        if (n2 == 91) {
            return this.dateSize;
        }
        if (n2 == 92) {
            return this.timeSize;
        }
        if (n2 == 93) {
            return this.timestampSize;
        }
        return resultSetMetaData.getColumnDisplaySize(n);
    }

    public String getStringFromDate(String string2) throws ParseException {
        if (!this.enableLocalized) {
            return string2;
        }
        java.util.Date date = this.formatDate.parse(string2);
        return new Date(date.getTime()).toString();
    }

    public String getStringFromTime(String string2) throws ParseException {
        if (!this.enableLocalized) {
            return string2;
        }
        java.util.Date date = this.formatTime.parse(string2);
        return new Time(date.getTime()).toString();
    }

    public String getStringFromValue(String string2) throws ParseException {
        if (!this.enableLocalized) {
            return string2;
        }
        return this.formatNumber.parse(string2).toString();
    }

    public String getStringFromTimestamp(String string2) throws ParseException {
        if (!this.enableLocalized) {
            return string2;
        }
        java.util.Date date = this.formatTimestamp.parse(string2);
        return new Timestamp(date.getTime()).toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    private final synchronized String getEnvProperty(String string2) {
        String string3;
        try {
            this.resourceKey = string2;
            string3 = (String)AccessController.doPrivileged(this);
        }
        catch (SecurityException securityException) {
            string3 = null;
        }
        return string3;
    }

    public final Object run() {
        String string2 = System.getProperty(this.resourceKey);
        return string2;
    }

    public static boolean enableLocalization(boolean bl) {
        LocalizedResource.getInstance().enableLocalized = bl;
        LocalizedResource.getInstance().init();
        return bl;
    }

    public boolean isLocalized() {
        return LocalizedResource.getInstance().enableLocalized;
    }

    public static String getMessage(String string2) {
        return LocalizedResource.getInstance().getTextMessage(string2);
    }

    public static String getMessage(String string2, Object object) {
        return LocalizedResource.getInstance().getTextMessage(string2, object);
    }

    public static String getMessage(String string2, Object object, Object object2) {
        return LocalizedResource.getInstance().getTextMessage(string2, object, object2);
    }

    public static String getMessage(String string2, Object object, Object object2, Object object3) {
        return LocalizedResource.getInstance().getTextMessage(string2, object, object2, object3);
    }

    public static String getMessage(String string2, Object object, Object object2, Object object3, Object object4) {
        return LocalizedResource.getInstance().getTextMessage(string2, object, object2, object3, object4);
    }

    public static LocalizedOutput OutputWriter() {
        return LocalizedResource.getInstance().out;
    }

    public static LocalizedInput InputReader() {
        return LocalizedResource.getInstance().in;
    }

    public static String getNumber(long l) {
        return LocalizedResource.getInstance().getNumberAsString(l);
    }

    public static String getNumber(int n) {
        return LocalizedResource.getInstance().getNumberAsString(n);
    }

    public String toString() {
        String string2 = "toString(){\nlocale=" + (this.locale == null ? "null" : this.locale.toString()) + "\n" + "encode=" + this.encode + "\n" + "messageFile=" + this.messageFileName + "\n" + "resourceKey=" + this.resourceKey + "\n" + "enableLocalized=" + this.enableLocalized + " \n" + "dateSize=" + this.dateSize + "\n" + "timeSize=" + this.timeSize + "\n" + "timestampSize=" + this.timestampSize + "\n}";
        return string2;
    }

    static {
        boolean bl;
        try {
            Class.forName("java.math.BigDecimal");
            bl = true;
            Method method = ResultSet.class.getMethod("getBigDecimal", Integer.TYPE);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        SUPPORTS_BIG_DECIMAL_CALLS = bl;
    }
}

