/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.jdbc.InternalDriver;

abstract class ConnectionChild {
    EmbedConnection localConn;
    final InternalDriver factory;
    private Calendar cal;

    ConnectionChild(EmbedConnection embedConnection) {
        this.localConn = embedConnection;
        this.factory = embedConnection.getLocalDriver();
    }

    final EmbedConnection getEmbedConnection() {
        return this.localConn;
    }

    final Object getConnectionSynchronization() {
        return this.localConn.getConnectionSynchronization();
    }

    final SQLException handleException(Throwable throwable) throws SQLException {
        return this.localConn.handleException(throwable);
    }

    final void needCommit() {
        this.localConn.needCommit();
    }

    final void commitIfNeeded() throws SQLException {
        this.localConn.commitIfNeeded();
    }

    final void commitIfAutoCommit() throws SQLException {
        this.localConn.commitIfAutoCommit();
    }

    final void setupContextStack() throws SQLException {
        this.localConn.setupContextStack();
    }

    final void restoreContextStack() throws SQLException {
        this.localConn.restoreContextStack();
    }

    Calendar getCal() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    SQLException newSQLException(String string2) {
        return EmbedConnection.newSQLException(string2);
    }

    SQLException newSQLException(String string2, Object object) {
        return EmbedConnection.newSQLException(string2, object);
    }

    SQLException newSQLException(String string2, Object object, Object object2) {
        return EmbedConnection.newSQLException(string2, object, object2);
    }

    protected static void restoreIntrFlagIfSeen(boolean bl, EmbedConnection embedConnection) {
        if (bl) {
            InterruptStatus.restoreIntrFlagIfSeen(embedConnection.getLanguageConnection());
        } else {
            InterruptStatus.restoreIntrFlagIfSeen();
        }
    }
}

